#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectSound3DListener::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectSound3DListener_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectSound3DListener::AddRef(THIS)
{
	ULONG res;
	res = IDirectSound3DListener_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectSound3DListener::Release(THIS)
{
	ULONG res;
	res = IDirectSound3DListener_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::GetAllParameters(THIS_ LPDS3DLISTENER lpListener)
{
	HRESULT res;
	res = IDirectSound3DListener_GetAllParameters(p, lpListener);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_GetAllParameters(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::GetDistanceFactor(THIS_ LPD3DVALUE lpflDistanceFactor)
{
	HRESULT res;
	res = IDirectSound3DListener_GetDistanceFactor(p, lpflDistanceFactor);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_GetDistanceFactor(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::GetDopplerFactor(THIS_ LPD3DVALUE lpflDopplerFactor)
{
	HRESULT res;
	res = IDirectSound3DListener_GetDopplerFactor(p, lpflDopplerFactor);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_GetDopplerFactor(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::GetOrientation(THIS_ LPD3DVECTOR lpvOrientFront, LPD3DVECTOR lpvOrientTop)
{
	HRESULT res;
	res = IDirectSound3DListener_GetOrientation(p, lpvOrientFront, lpvOrientTop);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_GetOrientation(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::GetPosition(THIS_ LPD3DVECTOR lpvPosition)
{
	HRESULT res;
	res = IDirectSound3DListener_GetPosition(p, lpvPosition);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_GetPosition(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::GetRolloffFactor(THIS_ LPD3DVALUE lpflRolloffFactor)
{
	HRESULT res;
	res = IDirectSound3DListener_GetRolloffFactor(p, lpflRolloffFactor);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_GetRolloffFactor(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::GetVelocity(THIS_ LPD3DVECTOR lpvVelocity)
{
	HRESULT res;
	res = IDirectSound3DListener_GetVelocity(p, lpvVelocity);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_GetVelocity(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::SetAllParameters(THIS_ LPCDS3DLISTENER lpcListener, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DListener_SetAllParameters(p, lpcListener, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_SetAllParameters(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::SetDistanceFactor(THIS_ D3DVALUE flDistanceFactor, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DListener_SetDistanceFactor(p, flDistanceFactor, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_SetDistanceFactor(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::SetDopplerFactor(THIS_ D3DVALUE flDopplerFactor, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DListener_SetDopplerFactor(p, flDopplerFactor, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_SetDopplerFactor(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::SetOrientation(THIS_ D3DVALUE xFront, D3DVALUE yFront, D3DVALUE zFront, D3DVALUE xTop, D3DVALUE yTop, D3DVALUE zTop, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DListener_SetOrientation(p, xFront, yFront, zFront, xTop, yTop, zTop, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_SetOrientation(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::SetPosition(THIS_ D3DVALUE x, D3DVALUE y, D3DVALUE z, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DListener_SetPosition(p, x, y, z, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_SetPosition(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::SetRolloffFactor(THIS_ D3DVALUE flRolloffFactor, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DListener_SetRolloffFactor(p, flRolloffFactor, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_SetRolloffFactor(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::SetVelocity(THIS_ D3DVALUE x, D3DVALUE y, D3DVALUE z, DWORD dwApply)
{
	HRESULT res;
	res = IDirectSound3DListener_SetVelocity(p, x, y, z, dwApply);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_SetVelocity(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound3DListener::CommitDeferredSettings(THIS)
{
	HRESULT res;
	res = IDirectSound3DListener_CommitDeferredSettings(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound3DListener_CommitDeferredSettings(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
