#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectSoundBuffer::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectSoundBuffer_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectSoundBuffer::AddRef(THIS)
{
	ULONG res;
	res = IDirectSoundBuffer_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectSoundBuffer::Release(THIS)
{
	ULONG res;
	res = IDirectSoundBuffer_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::GetCaps(THIS_ LPDSBCAPS lpDSBufferCaps)
{
	HRESULT res;
	res = IDirectSoundBuffer_GetCaps(p, lpDSBufferCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_CreateSoundBuffer(this=%08x, lpDSBufferCaps=%08x) = %s",
		p, lpDSBufferCaps, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::GetCurrentPosition(THIS_ LPDWORD lpdwCurrentPlayCursor, LPDWORD lpdwCurrentWriteCursor)
{
	HRESULT res;
	res = IDirectSoundBuffer_GetCurrentPosition(p, lpdwCurrentPlayCursor, lpdwCurrentWriteCursor);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_GetCurrentPosition(this=%08x, *lpdwCurrentPlayCursor=%s, *lpdwCurrentWriteCursor=%s) = %s",
		p, LpDwtoStr(lpdwCurrentPlayCursor), LpDwtoStr(lpdwCurrentWriteCursor), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::GetFormat(THIS_ LPWAVEFORMATEX lpwfxFormat, DWORD dwSizeAllocated, LPDWORD lpdwSizeWritten)
{
	HRESULT res;
	res = IDirectSoundBuffer_GetFormat(p, lpwfxFormat, dwSizeAllocated, lpdwSizeWritten);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_GetFormat(this=%08x, lpwfxFormat=%08x, dwSizeAllocated=%s, *lpdwSizeWritten=%08x) = %s",
		p, lpwfxFormat, dwSizeAllocated, LpDwtoStr(lpdwSizeWritten), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::GetVolume(THIS_ LPLONG lplVolume)
{
	HRESULT res;
	res = IDirectSoundBuffer_GetVolume(p, lplVolume);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_GetVolume(this=%08x, *lplVolume=%s) = %s",
		p, LpDwtoStr((LPDWORD)lplVolume), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::GetPan(THIS_ LPLONG lplPan)
{
	HRESULT res;
	res = IDirectSoundBuffer_GetPan(p, lplPan);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_GetPan(this=%08x, *lplPan=%s) = %s",
		p, LpDwtoStr((LPDWORD)lplPan), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::GetFrequency(THIS_ LPDWORD lpdwFrequency)
{
	HRESULT res;
	res = IDirectSoundBuffer_GetFrequency(p, lpdwFrequency);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_GetFrequency(this=%08x, *lpdwFrequency=%s) = %s",
		p, LpDwtoStr(lpdwFrequency), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::GetStatus(THIS_ LPDWORD lpdwStatus)
{
	HRESULT res;
	res = IDirectSoundBuffer_GetStatus(p, lpdwStatus);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_GetStatus(this=%08x, *lpdwStatus=%s) = %s",
		p, LpDwtoStr(lpdwStatus), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::Initialize(THIS_ LPDIRECTSOUND lpDirectSound, LPCDSBUFFERDESC lpcDSBufferDesc)
{
	HRESULT res;
	lpDirectSound = myIDirectSound::getBaseInterface(lpDirectSound);
	res = IDirectSoundBuffer_Initialize(p, lpDirectSound, lpcDSBufferDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_Initialize(this=%08x, lpDirectSound=%08x, lpcDSBufferDesc=%08x) = %s",
		p, lpDirectSound, lpcDSBufferDesc, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::Lock(THIS_ DWORD dwWriteCursor, DWORD dwWriteBytes, LPVOID *lplpvAudioPtr1, LPDWORD lpdwAudioBytes1, LPVOID *lplpvAudioPtr2, LPDWORD lpdwAudioBytes2, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectSoundBuffer_Lock(p, dwWriteCursor, dwWriteBytes, lplpvAudioPtr1, lpdwAudioBytes1, lplpvAudioPtr2, lpdwAudioBytes2, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_Lock(this=%08x, dwWriteCursor=%08x, dwWriteBytes=%08x, lplpvAudioPtr1=%08x, lpdwAudioBytes1=%08x, lplpvAudioPtr2=%08x, lpdwAudioBytes2=%08x, dwFlags=%08x) = %s",
		p, dwWriteCursor, dwWriteBytes, lplpvAudioPtr1, lpdwAudioBytes1, lplpvAudioPtr2, lpdwAudioBytes2, dwFlags, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::Play(THIS_ DWORD dwReserved1, DWORD dwReserved2, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectSoundBuffer_Play(p, dwReserved1, dwReserved2, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_Play(this=%08x, dwReserved1=%08x, dwReserved2=%08x, dwFlags=%08x) = %s",
		p, dwReserved1, dwReserved2, dwFlags, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::SetCurrentPosition(THIS_ DWORD dwNewPosition)
{
	HRESULT res;
	res = IDirectSoundBuffer_SetCurrentPosition(p, dwNewPosition);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_SetCurrentPosition(this=%08x, dwNewPosition=%08x) = %s",
		p, dwNewPosition, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::SetFormat(THIS_ LPCWAVEFORMATEX lpcfxFormat)
{
	HRESULT res;
	res = IDirectSoundBuffer_SetFormat(p, lpcfxFormat);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_SetFormat(this=%08x, lpcfxFormat=%08x) = %s",
		p, lpcfxFormat, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::SetVolume(THIS_ LONG lVolume)
{
	HRESULT res;
	res = IDirectSoundBuffer_SetVolume(p, lVolume);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_SetVolume(this=%08x, lVolume=%08x) = %s",
		p, lVolume, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::SetPan(THIS_ LONG lPan)
{
	HRESULT res;
	res = IDirectSoundBuffer_SetPan(p, lPan);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_SetPan(this=%08x, lPan=%08x) = %s",
		p, lPan, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::SetFrequency(THIS_ DWORD dwFrequency)
{
	HRESULT res;
	res = IDirectSoundBuffer_SetFrequency(p, dwFrequency);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_SetFrequency(this=%08x, dwFrequency=%08x) = %s",
		p, dwFrequency, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::Stop(THIS)
{
	HRESULT res;
	res = IDirectSoundBuffer_Stop(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_Stop(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::Unlock(THIS_ LPVOID lpvAudioPtr1, DWORD dwAudioBytes1, LPVOID lpvAudioPtr2, DWORD dwAudioBytes2)
{
	HRESULT res;
	res = IDirectSoundBuffer_Unlock(p, lpvAudioPtr1, dwAudioBytes1, lpvAudioPtr2, dwAudioBytes2);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_Unlock(this=%08x, lpvAudioPtr1=%08x, dwAudioBytes1=%08x, lpvAudioPtr2=%08x, dwAudioBytes2=%08x) = %s",
		p, lpvAudioPtr1, dwAudioBytes1, lpvAudioPtr2, dwAudioBytes2, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundBuffer::Restore(THIS)
{
	HRESULT res;
	res = IDirectSoundBuffer_Restore(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundBuffer_Restore(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
