#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectSoundCaptureBuffer::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectSoundCaptureBuffer::AddRef(THIS)
{
	ULONG res;
	res = IDirectSoundCaptureBuffer_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectSoundCaptureBuffer::Release(THIS)
{
	ULONG res;
	res = IDirectSoundCaptureBuffer_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::GetCaps(THIS_ LPDSCBCAPS lpDSCBCaps)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_GetCaps(p, lpDSCBCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_GetCaps(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::GetCurrentPosition(THIS_ LPDWORD lpdwCapturePosition, LPDWORD lpdwReadPosition)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_GetCurrentPosition(p, lpdwCapturePosition, lpdwReadPosition);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_GetCurrentPosition(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::GetFormat(THIS_ LPWAVEFORMATEX lpwfxFormat, DWORD dwSizeAllocated, LPDWORD lpdwSizeWritten)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_GetFormat(p, lpwfxFormat, dwSizeAllocated, lpdwSizeWritten);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_GetFormat(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::GetStatus(THIS_ LPDWORD lpdwStatus)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_GetStatus(p, lpdwStatus);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_GetStatus(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::Initialize(THIS_ LPDIRECTSOUNDCAPTURE lpDirectSoundCapture, LPCDSCBUFFERDESC lpcDSBufferDesc)
{
	HRESULT res;
	lpDirectSoundCapture = myIDirectSoundCapture::getBaseInterface(lpDirectSoundCapture);
	res = IDirectSoundCaptureBuffer_Initialize(p, lpDirectSoundCapture, lpcDSBufferDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_Initialize(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::Lock(THIS_ DWORD dwReadCursor, DWORD dwReadBytes, LPVOID *lplpvAudioPtr1, LPDWORD lpdwAudioBytes1, LPVOID *lplpvAudioPtr2, LPDWORD lpdwAudioBytes2, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_Lock(p, dwReadCursor, dwReadBytes, lplpvAudioPtr1, lpdwAudioBytes1, lplpvAudioPtr2, lpdwAudioBytes2, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_Lock(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::Start(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_Start(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_Start(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::Stop(THIS)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_Stop(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_Stop(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCaptureBuffer::Unlock(THIS_ LPVOID lpvAudioPtr1, DWORD dwAudioBytes1, LPVOID lpvAudioPtr2, DWORD dwAudioBytes2)
{
	HRESULT res;
	res = IDirectSoundCaptureBuffer_Unlock(p, lpvAudioPtr1, dwAudioBytes1, lpvAudioPtr2, dwAudioBytes2);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCaptureBuffer_Unlock(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
