#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectSoundNotify::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectSoundNotify_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundNotify_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectSoundNotify::AddRef(THIS)
{
	ULONG res;
	res = IDirectSoundNotify_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundNotify_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectSoundNotify::Release(THIS)
{
	ULONG res;
	res = IDirectSoundNotify_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundNotify_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectSoundNotify::SetNotificationPositions(THIS_ DWORD cPositionNotifies, LPCDSBPOSITIONNOTIFY lpcPositionNotifies)
{
	HRESULT res;
	res = IDirectSoundNotify_SetNotificationPositions(p, cPositionNotifies, lpcPositionNotifies);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundNotify_SetNotificationPositions(this=%08x, cPositionNotifies=%08x, lpcPositionNotifies=%08x) = %s",
		p, cPositionNotifies, lpcPositionNotifies, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
