#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIKsPropertySet::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IKsPropertySet_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IKsPropertySet_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIKsPropertySet::AddRef(THIS)
{
	ULONG res;
	res = IKsPropertySet_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IKsPropertySet_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIKsPropertySet::Release(THIS)
{
	ULONG res;
	res = IKsPropertySet_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IKsPropertySet_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIKsPropertySet::Get(THIS_ REFGUID rguidPropSet, ULONG ulId, LPVOID pInstanceData, ULONG ulInstanceLength, LPVOID pPropertyData, ULONG ulDataLength, PULONG pulBytesReturned)
{
	HRESULT res;
	res = IKsPropertySet_Get(p, rguidPropSet, ulId, pInstanceData, ulInstanceLength, pPropertyData, ulDataLength, pulBytesReturned);
#ifdef	DXWRAP_LOG
	::Log("IKsPropertySet_Get(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIKsPropertySet::Set(THIS_ REFGUID rguidPropSet, ULONG ulId, LPVOID pInstanceData, ULONG ulInstanceLength, LPVOID pPropertyData, ULONG ulDataLength)
{
	HRESULT res;
	res = IKsPropertySet_Set(p, rguidPropSet, ulId, pInstanceData, ulInstanceLength, pPropertyData, ulDataLength);
#ifdef	DXWRAP_LOG
	::Log("IKsPropertySet_Set(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIKsPropertySet::QuerySupport(THIS_ REFGUID rguidPropSet, ULONG ulId, PULONG pulTypeSupport)
{
	HRESULT res;
	res = IKsPropertySet_QuerySupport(p, rguidPropSet, ulId, pulTypeSupport);
#ifdef	DXWRAP_LOG
	::Log("IKsPropertySet_QuerySupport(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
