//******************************************************************************
//*
//* KRNPATCH.SYS: NT Kernel Patcher for WinNT/2K/XP operating systems
//*
//*		Copyright (c) 2002, by SaPu. All rights reserved.
//*
//*		This program is FREEWARE and cannot be used for any commercial purposes
//*		and/or for profit without an explicit consent of the author.
//*		The term FREEWARE refers only to the mode of distribution, the program
//*		and the relative source code are copyrighted.
//*		Reuse of this code in a commercial applications is not allowed.
//*		Author is not responsible for any damage derived from use of this program.
//*
//* Purpose:
//*		Allowing an user-mode program to search, read, and modify data inside
//*		any loaded kernel-mode device driver.
//*
//******************************************************************************

// Define the various device type values.  Note that values used by Microsoft
// Corporation are in the range 0-32767, and 32768-65535 are reserved for use
// by customers.
#define FILE_DEVICE_KRNPATCH			0x81F0

// Device driver names (used to load / access the device driver)
#define	KRNPATCH_DRIVER_FILENAME		"krnpatch.sys"
#define	KRNPATCH_DEVICENAME				__TEXT("krnpatch")	// internal device name: L"\\Device\\krnpatch"
#define	KRNPATCH_DOS_DEVICENAME			__TEXT("KRNPATCH")	// dos device link name: L"\\DosDevices\\KRNPATCH"

// IOCTL codes:
#define IOCTL_KRNPATCH_FIND_DATA		CTL_CODE(FILE_DEVICE_KRNPATCH, 0x01, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_KRNPATCH_READ_DATA		CTL_CODE(FILE_DEVICE_KRNPATCH, 0x02, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_KRNPATCH_WRITE_DATA		CTL_CODE(FILE_DEVICE_KRNPATCH, 0x03, METHOD_BUFFERED, FILE_ANY_ACCESS)

// scan device driver memory for data & return the offset where data was found:
typedef struct _KRNPATCH_FIND_DATA {
	IN	CHAR	module_name[32];		// name of the device driver to access
	IN	ULONG	scn_cnt_type;			// section types to look for data
	IN	ULONG	start_offset;			// start search offset (0 = from the beginning)
	IN	ULONG	data_len;				// length of data to search
	IN	UCHAR	data[256];				// data to search
	OUT	ULONG	found_offset;			// (out) offset where data was found
} KRNPATCH_FIND_DATA, *PKRNPATCH_FIND_DATA;
// Note: the 'scn_cnt_type' field needs to be initialized ...
//		 ... with one or more of the following flags:
//	IMAGE_SCN_CNT_CODE					// scan sections containing code
//	IMAGE_SCN_CNT_INITIALIZED_DATA		// scan sections containing initialized data
//	IMAGE_SCN_CNT_UNINITIALIZED_DATA	// scan sections containing uninitialized data

// read device driver memory & return the readed data:
typedef struct _KRNPATCH_READ_DATA {
	IN	CHAR	module_name[32];		// name of the device driver to access
	IN	ULONG	start_offset;			// start read offset
	IN	ULONG	data_len;				// length of data to read
	OUT	UCHAR	data[256];				// (out) readed data
} KRNPATCH_READ_DATA, *PKRNPATCH_READ_DATA;

// write device driver memory, replacing old_data with new_data:
typedef struct _KRNPATCH_WRITE_DATA {
	IN	CHAR	module_name[32];		// name of the device driver to access
	IN	ULONG	start_offset;			// start write offset
	IN	ULONG	data_len;				// length of data to write
	IN	UCHAR	old_data[256];			// old data espected to read
	IN	UCHAR	new_data[256];			// new data to write
} KRNPATCH_WRITE_DATA, *PKRNPATCH_WRITE_DATA;
