
#include <stdio.h>
#include <windows.h>
#include <signal.h>
#include "bleem_nt.h"

// TEST_VERSION: if defined, use memory patching on loader code
//#define	TEST_VERSION	// DO NOT DEFINE (not full working !!!)

// Size of a memory page for _PageReserve / _PageCommit calls:
#define		PAGE_SIZE			0x1000

// Size of shared memory pages for PSX RAM and JMP_TABLE
#define		PSXRAM_SHMEM_SIZE	0x200000

//******************************************************************************

HANDLE	hInstance;						// instance of the DLL
HANDLE	hProcessHeap;					// process heap (for HeapAlloc() / HeapFree())
OSVERSIONINFO	os_version;
BOOL	nt_dos_translate_adr = FALSE;
CRITICAL_SECTION	vxdcall_crtsec;

LPVOID	VxDCall, QT_Thunk, MapLS, SMapLS, UnMapLS,
		LoadLibrary16, FreeLibrary16, GetProcAddress16;

static DWORD	vmm_psxram_adr = NULL;	// shared PSX memory base address

//******************************************************************************

// local variables initialized from 'init_hooks()':
static char		kernel32_dll_name[] = "kernel32.dll";
static char		user32_dll_name[] = "user32.dll";
static char		dinput_dll_name[] = "dinput.dll";
static char		bleem_nt_dll_name[MAX_PATH];
static HMODULE	kernel32_dll = NULL;
static HMODULE	dinput_dll = NULL;
static HMODULE	bleem_exe = NULL;

static BOOL psxram_shmem_alloc(DWORD base_adr);

//******************************************************************************
//
// VxDCall services emulation:
//	This section is used to emulate the Win9x-specific function 'VxDCall'.
//  The called VxD services are used for the following purposed:
// - memory allocation handling:
//	VMM_PageReserve: Reserves a range of linear address memory
//	VMM_PageCommit:	 commit physical pages to a linear address
//	VMM_PageFree:	 free a linear address memory block
//	VMM_PageModifyPermissions:	modify the pages permissions
//	VMM_GetDemandPageInfo:	get informations used for demand paging
// - real-mode (MSDOS) interrupts dispatching:
//	VWin32_Int21Dispatch:	calls a DOS (INT 21) service
//	VWin32_Int31Dispatch:	calls a DPMI service:
//	- DPMI_SimulateRealModeInterrupt:	calls a real-mode 'INT nn' service
//	- DPMI_AllocateLDTDescriptors:		allocate an LDT descriptor
//	- DPMI_FreeLDTDescriptors:			release an LDT descriptor
// - other services:
//	VWin32_Get_Version:	get VWIN32 VxD version number
//
//******************************************************************************

static void WINAPI VxDCall_VMM_PageReserve(VXDCALL_REGS *regs, ULONG page, ULONG npages, ULONG flags)
{
	DWORD	mem = NULL;
	if (page & 0x80000000) {
		mem = (DWORD)VirtualAlloc(NULL, npages * PAGE_SIZE, MEM_RESERVE, PAGE_EXECUTE_READWRITE);
	} else {
		// allocate PSX ram data area & compiler jump table at specified address (mirrored)
		DWORD	adr = page * PAGE_SIZE;
		// verify address & number of requested pages (0xA00 = 4 x 0x200 (RAM) + 0x200 (JMP_TABLE))
		if (psxram_shmem_alloc(adr & 0x1FFFFFFF) &&	// map shared memory for PSX RAM & JMP_TABLE
			vmm_psxram_adr != NULL &&
			npages == (5 * PSXRAM_SHMEM_SIZE / PAGE_SIZE) &&
			((adr - vmm_psxram_adr) & 0x5FFFFFFF) == 0) {
			mem = adr;	// if address ok, use it as return value (!= NULL)
		}
	}
	regs->reg_EAX = (mem != NULL) ? mem : (DWORD)-1;
}
static void WINAPI VxDCall_VMM_PageCommit(VXDCALL_REGS *regs, ULONG page, ULONG npages, ULONG hpd, ULONG pagerdata, ULONG flags)
{
	DWORD	adr = page * PAGE_SIZE;
	DWORD	mem = (adr != vmm_psxram_adr && adr != (vmm_psxram_adr + 4 * PSXRAM_SHMEM_SIZE)) ?
		(DWORD)VirtualAlloc((LPVOID)adr, npages * PAGE_SIZE, MEM_COMMIT, PAGE_EXECUTE_READWRITE) : adr;
	regs->reg_EAX = mem;
}
static void WINAPI VxDCall_VMM_PageFree(VXDCALL_REGS *regs, ULONG hMem, DWORD flags)
{
	BOOL	res = 1;
	if (((hMem - vmm_psxram_adr) & 0x5FFFFFFF) != 0) {
		VirtualFree((LPVOID)hMem, 0, MEM_DECOMMIT);
		res = VirtualFree((LPVOID)hMem, 0, MEM_RELEASE);
	}
	regs->reg_EAX = res;
}
static void WINAPI VxDCall_VMM_PageModifyPermissions(VXDCALL_REGS *regs, ULONG page, ULONG npages, ULONG permand, ULONG permor)
{
//	__asm int 3
}
static void WINAPI VxDCall_VMM_GetDemandPageInfo(VXDCALL_REGS *regs, DEMANDINFOSTRUC *DemandInfo, DWORD flags)
{
	memset(DemandInfo, 0, sizeof(*DemandInfo));
//	__asm int 3
}
static void WINAPI VxDCall_VWin32_Get_Version(VXDCALL_REGS *regs)
{
	regs->reg_EAX = 0x0102;
}
static void WINAPI VxDCall_VWin32_Int21Dispatch(VXDCALL_REGS *regs, DWORD _eax, DWORD _ecx)
{
	switch (_eax) {
	case DOS_ResetDrive:
		// cx = action (0x0001 = flush filesystem buffers and cache for drive, and reset drive)
		// dx = drive number
		regs->reg_EAX = 0;
		break;
	default:
		__asm int 3
		break;
	}
}
static void WINAPI VxDCall_VWin32_Int31Dispatch(VXDCALL_REGS *regs, DWORD _eax, DWORD _ecx)
{
	switch (_eax) {
	case DPMI_SimulateRealModeInterrupt:
		switch (regs->reg_EBX & 0xFF) {	// BL=int-no, BH=flags(0)
		case 0x2F:				// INT 2F (MSCDEX)
			MSCDEXRequest((REAL_MODE_CALL_REGS *)regs->reg_EDI);	// EDI = register buffer
			regs->reg_EAX = 0;
			break;
		default:
			__asm int 3
			break;
		}
		break;
	case DPMI_AllocateLDTDescriptors:
		// Note: Return an LDT descriptor with a NULL base address to raise a
		//		 STATUS_ACCESS_VIOLATION exception when the program tries
		//		 to write into the descriptor (see manage_exception())
		if (!AllocLDTDescriptor(&regs->reg_EAX))
			__asm int 3;
		break;
	case DPMI_FreeLDTDescriptors:
		if (!FreeLDTDescriptor(regs->reg_EBX))
			__asm int 3;
		regs->reg_EAX = 0;
		break;
	default:
		__asm int 3
		break;
	}
}
static void WINAPI VxDCall_VWin32_Int41Dispatch(VXDCALL_REGS *regs, DWORD _eax)
{
	switch (_eax) {
	case D386_DebuggerInstallationCheck:
		regs->reg_EAX = 0;				// return 0xF386 if debugger installed
		break;
	default:
		__asm int 3
	}
}

// save & restore regs macros for VxDCall() service:
// Warning: The macro differs from the 'w9x' one because
//			this one DO NOT RESTORE the ESP register !!!
#define	SAVE_REGS(regs) \
	__asm mov	regs.reg_EAX,eax \
	__asm mov	regs.reg_EBX,ebx \
	__asm mov	regs.reg_ECX,ecx \
	__asm mov	regs.reg_EDX,edx \
	__asm mov	regs.reg_EDI,edi \
	__asm mov	regs.reg_ESI,esi \
	__asm mov	regs.reg_EBP,ebp \
	__asm mov	regs.reg_ESP,esp \
	__asm pushfd				 \
	__asm pop	regs.reg_Flags \
	__asm cld
#define	LOAD_REGS(regs) \
	__asm mov	eax,dword ptr [regs.reg_EAX] \
	__asm mov	ebx,dword ptr [regs.reg_EBX] \
	__asm mov	ecx,dword ptr [regs.reg_ECX] \
	__asm mov	edx,dword ptr [regs.reg_EDX] \
	__asm mov	edi,dword ptr [regs.reg_EDI] \
	__asm mov	esi,dword ptr [regs.reg_ESI] \
	__asm mov	ebp,dword ptr [regs.reg_EBP] \
	__asm push	dword ptr [regs.reg_Flags]	 \
	__asm popfd

__declspec(naked) void my_VxDCall()
{
	static	VXDCALL_REGS	regs;
#ifdef	_DEBUG
	static	DWORD	args[5];
	static	REAL_MODE_CALL_REGS	dpmi_regs;
#endif//_DEBUG

	// enter VxDCall() critical section to avoid multithreading behaviours
	__asm pushfd
	__asm pushad
	EnterCriticalSection(&vxdcall_crtsec);
	__asm popad
	__asm popfd

	// save caller return address, vxd service & input registers
	__asm pop	regs.ret_address
	__asm pop	regs.vxd_service
	SAVE_REGS(regs)

#ifdef	_DEBUG
	// save input data from the stack (args[])
	memcpy(args, (LPVOID)(regs.reg_ESP), sizeof(args));
	if (regs.vxd_service == VWin32_Int31Dispatch &&
		args[0] == DPMI_SimulateRealModeInterrupt) {
		// save input DPMI registers
		memcpy(&dpmi_regs, (LPVOID)regs.reg_EDI, sizeof(dpmi_regs));
	}
#endif//_DEBUG

	// call the VxDCall-equivalent function:
	// Note: args[] are popped from stack from the called function
	__asm push	offset regs
#define	CASE(service)									\
	__asm cmp	dword ptr [regs.vxd_service],service	\
	__asm jne	no_##service							\
	__asm call	VxDCall_##service						\
	__asm jmp	ret_from_VxDCall						\
	__asm no_##service:
	CASE(VMM_PageReserve)
	CASE(VMM_PageCommit)
	CASE(VMM_PageFree)
	CASE(VMM_PageModifyPermissions)
	CASE(VMM_GetDemandPageInfo)
	CASE(VWin32_Get_Version)
	CASE(VWin32_Int21Dispatch)
	CASE(VWin32_Int31Dispatch)
	CASE(VWin32_Int41Dispatch)
#undef	CASE
	__asm int	3	// unknown VxDCall service

	__asm ret_from_VxDCall:
#ifdef	_DEBUG
	Log_VxDCall(&regs, args, &dpmi_regs);
#endif//_DEBUG

	// restore output registers & caller return address
	LOAD_REGS(regs)
	__asm push	regs.ret_address
	// leave VxDCall() critical section
	__asm pushfd
	__asm pushad
	LeaveCriticalSection(&vxdcall_crtsec);
	__asm popad
	__asm popfd
	// ret to caller return address
	__asm ret
}

#undef	SAVE_REGS
#undef	LOAD_REGS

//******************************************************************************

static BOOL psxram_shmem_alloc(DWORD base_adr)
{
	HANDLE	psxram_hmap;	// handle to PSX_RAM file mapping object
	HANDLE	jmptab_hmap;	// handle to JMP_TABLE file mapping object
	DWORD	pmap_adr;
	LPVOID	pmap[4][5];
	int		i, j;
	// Base address offsets from 'adr'
	static const DWORD shmem_adr_offsets[4] = {
		0x00000000, 0x20000000, 0x80000000, 0xA0000000 };

	if (vmm_psxram_adr != NULL)
		return TRUE;

	// create file mapping objects
	psxram_hmap = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, PSXRAM_SHMEM_SIZE, NULL);
	jmptab_hmap = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, PSXRAM_SHMEM_SIZE, NULL);
	if (psxram_hmap != NULL && jmptab_hmap != NULL) {
		// scan memory to locate a free address space
		memset(pmap, 0, sizeof(pmap));
		for (i = 0; i < 4; i++) {		// 4 base address ranges
			for (j = 0; j < 5; j++) {	// 4 x PSX RAM + 1 x JMP_TABLE
				pmap_adr = base_adr + shmem_adr_offsets[i] + j * PSXRAM_SHMEM_SIZE;
				pmap[i][j] = MapViewOfFileEx((j < 4) ? psxram_hmap : jmptab_hmap, FILE_MAP_WRITE, 0, 0, PSXRAM_SHMEM_SIZE, (LPVOID)pmap_adr);
				if (pmap[i][j] != (LPVOID)pmap_adr)
					break;
			}
			if (j < 5)
				break;
		}
		if (i == 4) {
// success mapping shared memory: save base address on 'vmm_psxram_adr' & return
			vmm_psxram_adr = base_adr;
		} else {
// error mapping shared memory: release all the mapped pages & ret with error
			for (i = 0; i < 4; i++)
				for (j = 0; j < 5; j++)
					if (pmap[i][j] != NULL)
						UnmapViewOfFile(pmap[i][j]);
			//vmm_psxram_adr = NULL;
		}
	}
	// close file mapping handles (no more needed)
	if (jmptab_hmap != NULL)
		CloseHandle(jmptab_hmap);
	if (psxram_hmap != NULL)
		CloseHandle(psxram_hmap);
	return (vmm_psxram_adr != NULL) ? TRUE : FALSE;
}

//******************************************************************************

/*
original code (v 1.4demo):
	..........
	mov eax, 0x00000960					// 48 bytes for request/control + 2352 bytes for data
	call call_GlobalDosAlloc
	je alloc_error
	mov dword ptr [dos_mem_handle], eax	// DOS original handle (used bits 0-15 only)
	shr eax, 0x10
	mov dword ptr [dos_ES_segment], eax	// DOS ES segment (used bits 0-15 only)
	shl eax, 0x04
	mov dword ptr [cd_request_ptr], eax	// request/control address
	add eax, 0x00000030
	mov dword ptr [cd_buffer_ptr], eax	// buffer address
	..........
call_GlobalDosAlloc:
	mov ebp, esp
	sub esp, 0x00000040
	push eax
	mov edx, dword ptr [GlobalDosAlloc]
	call QT_Thunk
	add esp, 0x00000040
	and eax, 0x0000FFFF
	shl edx, 0x10
	or eax, edx
	jne alloc_ok
	mov eax, 0x21310000
alloc_ok:
	ret

// Note: The 'GlobalDosAlloc' code espects a DOS memory block in range 0 - 1Mb, ...
// ... and doesn't work for addresses > 1Mb !!!
// To make it working, i'll need to replace into the original code:
//	shr eax, 0x10	->	shr eax, 0x00
//	shl eax, 0x04	->	shl eax, 0x10

*/
static DWORDLONG WINAPI QT_Thunk_GlobalDosAlloc(DWORD size)
{
	ULARGE_INTEGER	res;
	LPVOID	mem = VirtualAlloc(NULL, size, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE);
	if ((DWORD)mem & 0x0000FFFF) __asm int 3	// VirtualAlloc() MUST return a 64K-bytes aligned page
	// Note: This was the right 'GlobalDosAlloc' code, but it works ONLY for addresses <= 1Mb !!!
	// res.LowPart = 0;					// protected mode memory segment
	// res.HighPart = (DWORD)mem >> 4;	// real mode memory segment (mem >> 4)
	res.LowPart = (DWORD)mem >> 16;
	res.HighPart = 0;
	// Remember we'll need a different DOS address translation on MSCDEX calls
	nt_dos_translate_adr = TRUE;
	return res.QuadPart;
}
static WORD WINAPI QT_Thunk_GlobalDosFree(WORD pm_seg)
{
	VirtualFree((LPVOID)((DWORD)pm_seg << 16), 0, MEM_RELEASE);
	return 0;
}

HINSTANCE WINAPI my_LoadLibrary16(LPCTSTR lpLibFileName)
{
	return (HINSTANCE)0xFFFF;
}
BOOL WINAPI my_FreeLibrary16(HMODULE hLibModule)
{
	return TRUE;
}
FARPROC WINAPI my_GetProcAddress16(HMODULE hModule, LPCSTR lpProcName)
{
	if (!strcmp(lpProcName, "GlobalDosAlloc")) return (FARPROC)QT_Thunk_GlobalDosAlloc;
	if (!strcmp(lpProcName, "GlobalDosFree")) return (FARPROC)QT_Thunk_GlobalDosFree;
	__asm int	3
	return NULL;
}
static void WINAPI patch_GlobalDosAlloc(LPCONTEXT context)
{
	static const BYTE	shr_eax_10[] = { 0xC1, 0xE8, 0x10 };
	static const BYTE	shl_eax_04[] = { 0xC1, 0xE0, 0x04 };
	BYTE	*adr = (BYTE *)(*(DWORD *)(context->Esp));
	BYTE	**frame = (BYTE **)context->Ebp;
	BYTE	*shr_eax_10_addr = NULL;
	BYTE	*shl_eax_04_addr = NULL;

	for (int idx = 0; idx < 2; idx++)
	{
		if (idx == 0) {		// 1.5b loader
			shr_eax_10_addr = adr + 0x17;
			shl_eax_04_addr = adr + 0x20;
		} else {			// 1.4demo / 1.5b program
			shr_eax_10_addr = *frame + 0x0B;
			shl_eax_04_addr = *frame + 0x13;
		}
		if (memcmp(shr_eax_10_addr, shr_eax_10, sizeof(shr_eax_10)) ||
			memcmp(shl_eax_04_addr, shl_eax_04, sizeof(shl_eax_04)))
			continue;
		while (context->Eip != (DWORD)shr_eax_10_addr)
			if (!TrackX86Opcode(context))
				__asm int 3
		context->Eax >>= 0x00;	// ES seg = 'eax >> 0' instead of 'eax >> 16'
		context->Eip += sizeof(shr_eax_10);
		while (context->Eip != (DWORD)shl_eax_04_addr)
			if (!TrackX86Opcode(context))
				__asm int 3
		context->Eax <<= 0x10;	// buffer = 'eax << 16' instead of 'eax << 4'
		context->Eip += sizeof(shl_eax_04);
		return;
	}
	__asm int 3;
}

__declspec(naked) void my_QT_Thunk(void)
{
	static DWORD	ret_addr;
	__asm pop	dword ptr [ret_addr]
	__asm cmp	edx,offset QT_Thunk_GlobalDosAlloc
	__asm jne	no_GlobalDosAlloc
	// does the 'GlobalDosAlloc' code patching (see comment above)
	__asm call	QT_Thunk_GlobalDosAlloc
	__asm push	dword ptr [ret_addr]	// save return address
	__asm push	offset patch_GlobalDosAlloc
	__asm call	ExecX86ContextTrap
	__asm add	esp,4					// free return address
	__asm jmp	ret_from_QT_Thunk
	__asm no_GlobalDosAlloc:
	__asm cmp	edx,offset QT_Thunk_GlobalDosFree
	__asm jne	no_GlobalDosFree
	__asm pop	ax		// convert pushed word to dword to handle ...
	__asm push	eax		// ... stack args correctly on function return
	__asm call	QT_Thunk_GlobalDosFree
	__asm jmp	ret_from_QT_Thunk
	__asm no_GlobalDosFree:
	__asm int 3
	__asm ret_from_QT_Thunk:
	__asm jmp dword ptr [ret_addr]
}

//******************************************************************************

// Note: The following function are called to find the Ring-0 (kernel-mode) segment.
//		 Return a NULL segment to easily recognize an LDT selector write access simply
//		 checking the value of the DS register == 0 (see manage_exception())
// How it works: The program create 2 LDT descriptors (thru VxdCall), set DS = ring0
//		 segment (to write the LDT descriptors), fill first LDT as CODE_SEGMENT
//		 and the second as CALL_GATE, and then execute 'call fword ptr [ldt_descrs]' to
//		 enter kernel-mode and starts executing ring-0 code until executing 'retf'.
DWORD WINAPI my_MapLS(DWORD)
{
	return LDT_SEG;
}
DWORD WINAPI my_SMapLS(void)
{
	return LDT_SEG;
}
DWORD WINAPI my_UnMapLS(DWORD)
{
	return LDT_SEG;
}

//******************************************************************************

#ifdef	TEST_VERSION
static BYTE		*file_map_addr = NULL;
static DWORD	file_map_size = 0;
static DWORD	*chksum_table = NULL;
static int		chksum_table_size = 0;

static void update_chksum_table(void)
{
	int		idx;
	if (chksum_table == NULL)
		return;
#define	ROR(value, nloops)	(((value) >> ((nloops) & 0x1F)) | ((value) << (-(nloops) & 0x1F)))
	for (idx = chksum_table_size * 4; idx >= 4; idx -= 4)
	{
		DWORD start_addr = ROR(chksum_table[idx], idx) & ~3;
		DWORD end_addr = ROR(chksum_table[idx + 4], idx + 4) & ~3;
		DWORD chksum = (start_addr ^ 0x52414E44) + start_addr;
		chksum_table[idx + 2] = 0;
		for (DWORD addr = start_addr; addr < end_addr; addr += 4)
			chksum ^= *(DWORD *)(file_map_addr + addr);
		chksum_table[idx + 2] = chksum;
	}
#undef	ROR
}

static BYTE *scan_for_pattern(BYTE *mem, DWORD mem_size, const BYTE *pattern, DWORD pattern_size)
{
	for (; mem_size >= pattern_size; mem++, mem_size--)
		if (!memcmp(mem, pattern, pattern_size))
			return mem;
	return NULL;
}
#endif//TEST_VERSION

static void PATCH_BYTE(BYTE *address, BYTE value)
{
	*address = value;
#ifdef	TEST_VERSION
	if (address >= file_map_addr && address < (file_map_addr + file_map_size))
		update_chksum_table();
#endif//TEST_VERSION
}

static HANDLE	hMapFile = INVALID_HANDLE_VALUE;

HANDLE WINAPI my_CreateFileMappingA(HANDLE hFile, LPSECURITY_ATTRIBUTES lpFileMappingAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCSTR lpName)
{
	hMapFile = hFile;
	flProtect = PAGE_WRITECOPY;	// change access mode to allow debugging
	return CreateFileMapping(hFile, lpFileMappingAttributes, flProtect, dwMaximumSizeHigh, dwMaximumSizeLow, lpName);
}

LPVOID WINAPI my_MapViewOfFile(HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, DWORD dwNumberOfBytesToMap)
{
	LPVOID	mem;
	DWORD	size = GetFileSize(hMapFile, NULL);
	dwDesiredAccess = FILE_MAP_COPY;	// change access mode to allow debugging
	// Warning: the mapped file address MUST be >= 0x80000000
	for (DWORD map_addr = 0x80000000; map_addr < 0xC0000000; map_addr += PAGE_SIZE)
		if ((mem = MapViewOfFileEx(hFileMappingObject, dwDesiredAccess, dwFileOffsetHigh, dwFileOffsetLow, dwNumberOfBytesToMap, (LPVOID)map_addr)) != NULL)
			break;

#ifdef	TEST_VERSION
	// save mapped address & size for 'PATCH_BYTE()' function:
	file_map_addr = (BYTE *)mem;
	file_map_size = size;

	DWORD	himem_scan_check_offset[2] = { 0, 0 };
	switch (size) {
	case 693240:	// version 1.5b
		himem_scan_check_offset[0] = 0x000A717C;
		himem_scan_check_offset[1] = 0x000A6F18;
		chksum_table = (DWORD *)((BYTE *)mem + 0x00013800);
		chksum_table_size = 0xA8;
		break;
	case 351732:	// version 1.4demo
		break;
	default:
		__asm int 3
		break;
	}
#endif//TEST_VERSION

// - detect if a debugger is present
	// mov	eax,fs:[00000020]
	// test	eax,eax			<- xor eax,eax
	// ret
#ifdef	TEST_VERSION
	DWORD	debug_present_flg = 0;
	__asm mov	eax,fs:[0x20]
	__asm mov	[debug_present_flg],eax
	if (debug_present_flg != 0) {
		static const BYTE	debug_present_pattern[] = {
			0x64, 0xA1, 0x20, 0x00, 0x00, 0x00,
			0x85, 0xC0,
		};
		BYTE *pb = scan_for_pattern((BYTE *)mem, size, debug_present_pattern, sizeof(debug_present_pattern));
		if (pb != NULL && pb[6] == 0x85 && pb[7] == 0xC0)
			PATCH_BYTE(pb + 6, 0x31);
	}
#else //TEST_VERSION
	__asm xor	eax,eax
	__asm mov	fs:[0x20],eax
#endif//TEST_VERSION

// - scan the memory range C0010000-C0800000 for debugger vxd's (use SEH)
// The SEH handler crashes if the program was mapped at address < 0x80000000 !!!
	// mov	esi,dword ptr [ebp]
	// test	esi,esi			<- xor esi,esi
	// je	done
#ifdef	TEST_VERSION
	if ((DWORD)file_map_addr < 0x80000000) {
		if (himem_scan_check_offset[0] != 0) {
			BYTE *pb = (BYTE *)mem + himem_scan_check_offset[0];
			if (pb[0] == 0x85 && pb[1] == 0xF6)
				PATCH_BYTE(pb + 0, 0x31);
		}
		if (himem_scan_check_offset[1] != 0) {
			BYTE *pb = (BYTE *)mem + himem_scan_check_offset[1];
			if (pb[0] == 0x85 && pb[1] == 0xF6)
				PATCH_BYTE(pb + 0, 0x31);
		}
	}
#endif//TEST_VERSION

#ifdef	_DEBUG
	Log("MapViewOfFile(): adr=%08x size=%08x", mem, size);
#endif//_DEBUG
	return mem;
}

BOOL WINAPI my_UnmapViewOfFile(LPVOID lpBaseAddress)
{
	return UnmapViewOfFile(lpBaseAddress);
}

// When used a 'dump.bli' file, the program checks for:
// GetVolumeInformation() -> compare with "bleem! Key "
// GetDiskFreeSpaceA() -> test ret = TRUE & free space = 0
// GetTickCount() -> ret values with increment step by 1

BOOL WINAPI my_GetVolumeInformationA(LPCSTR lpRootPathName, LPSTR lpVolumeNameBuffer, DWORD nVolumeNameSize, LPDWORD lpVolumeSerialNumber, LPDWORD lpMaximumComponentLength, LPDWORD lpFileSystemFlags, LPSTR lpFileSystemNameBuffer, DWORD nFileSystemNameSize)
{
	static const char bleem_key_str[] = "bleem! Key ";
	BOOL res = GetVolumeInformation(lpRootPathName, lpVolumeNameBuffer, nVolumeNameSize, lpVolumeSerialNumber, lpMaximumComponentLength, lpFileSystemFlags, lpFileSystemNameBuffer, nFileSystemNameSize);
#ifdef	USE_DUMP_BLI_FILE
	if (dump_bli_file != INVALID_HANDLE_VALUE) {
		res = TRUE;
		strcpy(lpVolumeNameBuffer, bleem_key_str);
	}
#endif//USE_DUMP_BLI_FILE
	// Note: WinNT 'eats' the trailing ' ' character
	if (res && !strncmp(lpVolumeNameBuffer, bleem_key_str, 10)) {
		strcpy(lpVolumeNameBuffer, bleem_key_str);
	}
#ifdef	_DEBUG
	if (res) Log("GetVolumeInformation(\"%s\"): VolumeName=\"%s\"", lpRootPathName, lpVolumeNameBuffer);
#endif//_DEBUG
	return res;
}

#ifdef	USE_DUMP_BLI_FILE
BOOL WINAPI my_GetDiskFreeSpaceA(LPCTSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters)
{
	BOOL res = GetDiskFreeSpaceA(lpRootPathName, lpSectorsPerCluster, lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters);
	if (dump_bli_file != INVALID_HANDLE_VALUE) {
		res = TRUE;
		*lpSectorsPerCluster = 1;
		*lpBytesPerSector = 2048;
		*lpNumberOfFreeClusters = 0;
		*lpTotalNumberOfClusters = 1;
	}
	return res;
}

__declspec(naked) void my_GetTickCount(void)
{
	static DWORD	timer_val = 0;
	__asm mov	eax,dword ptr [dump_bli_file]
	__asm cmp	eax, offset INVALID_HANDLE_VALUE
	__asm je	ret_tick_count
	__asm mov	eax,dword ptr [esp]	// eax = return address
	__asm cmp	dword ptr [eax+0x13],0xE64451E6
	__asm je	ret_timer_val
	__asm cmp	dword ptr [eax+0x10],0xE64451E6
	__asm je	ret_timer_val
	__asm cmp	dword ptr [eax+0x08],0xF174D02B
	__asm je	ret_timer_val
	__asm cmp	dword ptr [eax+0x02],0xF174D02B
	__asm je	ret_timer_val
	__asm ret_tick_count:
	__asm jmp	dword ptr [GetTickCount]
	__asm ret_timer_val:
	__asm mov	eax,dword ptr [timer_val]
	__asm inc	dword ptr [timer_val]
	__asm ret
}
#endif//USE_DUMP_BLI_FILE

HANDLE WINAPI my_CreateFileA(LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
	if (!strcmp(lpFileName, "\\\\.\\VWIN32"))
		return (HANDLE)-2;
	HANDLE h = CreateFile(lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
	if (h == INVALID_HANDLE_VALUE) {
// Note: The program use a read-write access mode when opening files from the CDROM drive.
//		 On NT-based OS, the open fails with error ACCESS_DENIED (CDROM is read-only !!!).
//		 When it happens, retry the open with read-only mode.
		int error_code = GetLastError();
		if (error_code == ERROR_ACCESS_DENIED &&
			dwDesiredAccess == (GENERIC_READ | GENERIC_WRITE)) 
		{
			dwDesiredAccess &= ~GENERIC_WRITE;
			h = CreateFile(lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
		}
	}
	return h;
}

BOOL WINAPI my_CloseHandle(HANDLE hObject)
{
	if (hObject == (HANDLE)-2)
		return TRUE;
	return CloseHandle(hObject);
}

BOOL WINAPI my_DeviceIoControl(HANDLE hDevice, DWORD dwIoControlCode, LPVOID lpInBuffer, DWORD nInBufferSize, LPVOID lpOutBuffer, DWORD nOutBufferSize, LPDWORD lpBytesReturned, LPOVERLAPPED lpOverlapped)
{
	if (hDevice != (HANDLE)-2)
		return DeviceIoControl(hDevice, dwIoControlCode, lpInBuffer, nInBufferSize, lpOutBuffer, nOutBufferSize, lpBytesReturned, lpOverlapped);//FALSE;
	switch (dwIoControlCode) {
	case VWIN32_DIOC_DOS_IOCTL:
//		DIOC_REGISTERS	*in = (DIOC_REGISTERS *)lpInBuffer;
//		DIOC_REGISTERS	*out = (DIOC_REGISTERS *)lpOutBuffer;
//		if (in->reg_EAX != 0x440D || in->reg_ECX != 0x0866)
//			break;
		return TRUE;
	default:
		break;
	}
	__asm int 3
	return FALSE;
}

BOOL WINAPI my_SetEvent(HANDLE hEvent)
{
	BOOL	res = SetEvent(hEvent);
	// Warning: bleem! espect an ECX value > 0x80000000 on return
	__asm mov	ecx,0x87654321
	return res;
}

FARPROC WINAPI my_GetProcAddress(HMODULE hModule, LPCSTR lpProcName)
{
	extern void dxwrap_GetProcAddressHook(LPCSTR lpProcName, FARPROC *lpProcAddr);
	FARPROC	res = GetProcAddress(hModule, lpProcName);
	// handle DirectX hooked functions:
	dxwrap_GetProcAddressHook(lpProcName, &res);
#ifdef	_DEBUG
	Log("GetProcAddress(%08x, %s) = %08x", hModule, lpProcName, res);
#endif//_DEBUG
	return res;
}

BOOL WINAPI my_GetVersionExA(LPOSVERSIONINFOA lpVersionInformation)
{
	BOOL res = GetVersionEx(lpVersionInformation);
	switch (lpVersionInformation->dwPlatformId) {
	case VER_PLATFORM_WIN32_NT:
		lpVersionInformation->dwPlatformId = VER_PLATFORM_WIN32_WINDOWS;
		break;
	case VER_PLATFORM_WIN32_WINDOWS:
		break;
	case VER_PLATFORM_WIN32s:
	default:
		break;
	}
	return res;
}

// translate 'dinput.dll' resource strings (returned by EnumDevices & ...
// ...  EnumObjects callbacks) to US-English (hardcoded on bleem!.exe)
int WINAPI myDirectInput_LoadStringA(HINSTANCE hinst, UINT uID, LPSTR lpBuffer, int nBufferMax)
{
	int res;
	res = LoadStringA(hInstance, uID, lpBuffer, nBufferMax);
	if (res == 0)
		res = LoadStringA(hinst, uID, lpBuffer, nBufferMax);
	return res;
}
int WINAPI myDirectInput_LoadStringW(HINSTANCE hinst, UINT uID, LPWSTR lpBuffer, int nBufferMax)
{
	int res;
	res = LoadStringW(hInstance, uID, lpBuffer, nBufferMax);
	if (res == 0)
		res = LoadStringW(hinst, uID, lpBuffer, nBufferMax);
	return res;
}

//******************************************************************************

static LONG manage_exception(DWORD exception_code, LPCONTEXT context)
{
	static BOOL	ring0_mode = FALSE;
#define	eip		((LPBYTE)context->Eip)

	switch (exception_code) {
	case STATUS_ILLEGAL_INSTRUCTION:
		break;

	case STATUS_ACCESS_VIOLATION:
#define	IS_CALL_F(eip)		(eip[0] == 0xFF && (eip[1] & 0x38) == 0x18)
#define	IS_INT_20(eip)		(eip[0] == 0xCD && eip[1] == 0x20)
#define	IS_RETF(eip)		(eip[0] == 0xCB)
		if (context->SegDs == 0 && !ring0_mode) {
			// When DS == 0, write an LDT descriptor:
			// DS = 0 (see MapLS()), EAX = 0-based LDT offset (see DPMI_AllocateLDTDescriptors)
			if (!TrackX86Opcode(context))
				break;
		} else if (!ring0_mode) {
			// Enter Ring0-mode thru callgate:
			if (IS_CALL_F(eip)) {	// call fword ptr [addr]
				if (!TrackX86Opcode(context))
					break;
				ring0_mode = TRUE;
			} else if (eip[0] == 0x8B && eip[1] == 0x46 && eip[2] == 0x04) {	// mov eax,dword ptr [esi+4]
				// bypass scanning of 'sgdt' descriptors table
				context->Eax = 0;
				context->Eip += 3;
			} else {
				break;
			}
		} else {	// if (ring0_mode)
			// Execute Int20 (VxDCall service) requests:
			if (IS_INT_20(eip)) {	// int 20 + dword service (VxDCall service)
				DWORD service = *(DWORD *)(eip+2);
				switch (service) {
				case VMMCall_CopyPageTable:
				case VMMCall_PageCommitPhys:
				case VMMCall_PageModifyPermissions:
					context->Eax = 1;		// success
					break;
				case VMMCall_Get_DDB:
					if (memcmp((LPVOID)context->Edi, "CDVSD   ", 8))
						__asm int 3
					context->Ecx = 0;		// device not installed
					break;
				default:
					__asm int 3
					break;
				}
				context->Eip += 6;
			// Leave from Ring0-mode:
			} else if (IS_RETF(eip)) {	// retf
				if (!TrackX86Opcode(context))
					break;
				ring0_mode = FALSE;
			} else if (eip[0] == 0x8B && eip[1] == 0x04 && eip[2] == 0x8D && *(DWORD *)(eip+3) == 0) {	// mov eax,dword ptr [ecx*4]
				context->Eax = 0;
				context->Eip += 7;
			} else if (eip[0] == 0x8B && eip[1] == 0x46 && eip[2] == 0x04) {	// mov eax,dword ptr [esi+4]
				// bypass scanning of 'sgdt' descriptors table
				context->Eax = 0;
				context->Eip += 3;
			} else {
				break;
			}
		}
		return EXCEPTION_CONTINUE_EXECUTION;
#undef	IS_CALL_F
#undef	IS_INT_20
#undef	IS_RETF

	case STATUS_PRIVILEGED_INSTRUCTION:
#define	IS_CLI(eip)			(eip[0] == 0xFA)
#define	IS_STI(eip)			(eip[0] == 0xFB)
#define	IS_MOV_REG_DRn(eip)	(eip[0] == 0x0F && eip[1] == 0x21 && (eip[2] & 0xC0) == 0xC0)
#define	IS_MOV_DRn_REG(eip)	(eip[0] == 0x0F && eip[1] == 0x23 && (eip[2] & 0xC0) == 0xC0)
#define	IS_LGDT(eip)		(eip[0] == 0x0F && eip[1] == 0x01 && (eip[2] & 0x38) == 0x10)
#define	IS_LIDT(eip)		(eip[0] == 0x0F && eip[1] == 0x01 && (eip[2] & 0x38) == 0x18)
		if (IS_CLI(eip) ||					// cli
			IS_STI(eip)) {					// sti
			context->Eip++;
		} else if (IS_MOV_REG_DRn(eip) ||	// mov reg,drN
				   IS_MOV_DRn_REG(eip)) {	// mov drN,reg
			TrackX86Opcode(context);
		} else if (IS_LGDT(eip) ||			// lgdt
				   IS_LIDT(eip)) {			// lidt
			while (IS_LGDT(eip) || IS_LIDT(eip))
				TrackX86Opcode(context);
			while (!IS_LGDT(eip) && !IS_LIDT(eip))
				if (!TrackX86Opcode(context))
					__asm int 3
			while (IS_LGDT(eip) || IS_LIDT(eip))
				TrackX86Opcode(context);
		} else {
			break;
		}
		return EXCEPTION_CONTINUE_EXECUTION;
#undef	IS_CLI
#undef	IS_STI
#undef	IS_MOV_REG_DRn
#undef	IS_MOV_DRn_REG
#undef	IS_LGDT
#undef	IS_LIDT

	default:
		break;
	}
#undef	eip
	return EXCEPTION_CONTINUE_SEARCH;
}

static LONG WINAPI my_except_filter(LPEXCEPTION_POINTERS exc)
{
	static BOOL		is_in_handler = FALSE;
	LONG	res;

	if (is_in_handler)
		return EXCEPTION_CONTINUE_SEARCH;
	is_in_handler = TRUE;
	res = manage_exception(exc->ExceptionRecord->ExceptionCode, exc->ContextRecord);
	is_in_handler = FALSE;
	return res;
}

#ifdef	_DEBUG
BOOL WINAPI my_GetVersionExA_SEH(LPOSVERSIONINFOA lpVersionInformation)
{
	static BOOL	SEHFilterInstalled = FALSE;
	if (SEHFilterInstalled)
		return my_GetVersionExA(lpVersionInformation);
	SEHFilterInstalled = TRUE;
	__try {
	__asm push	lpVersionInformation
	__asm lea	eax,[lpVersionInformation]
	__asm push	dword ptr [eax-4]	// original return address
	__asm jmp	my_GetVersionExA
	} __except(my_except_filter(GetExceptionInformation())) {}
	return TRUE;	// (code never reach here)
}

static DWORD WINAPI my_ThreadFunc_SEH(LPVOID lpParameter)
{
	DWORD	res = 0;
	LPVOID	*args = (LPVOID *)lpParameter;
	LPTHREAD_START_ROUTINE lpStartAddress = (LPTHREAD_START_ROUTINE)args[0];
	lpParameter = args[1];
	free(args);
	__try {
		res = lpStartAddress(lpParameter);
	} __except(my_except_filter(GetExceptionInformation())) {}
	return res;
}

HANDLE WINAPI my_CreateThread_SEH(LPSECURITY_ATTRIBUTES lpThreadAttributes, DWORD dwStackSize, LPTHREAD_START_ROUTINE lpStartAddress, LPVOID lpParameter, DWORD dwCreationFlags, LPDWORD lpThreadId)
{
	LPVOID	*args = (LPVOID *)malloc(2 * sizeof(LPVOID));
	args[0] = lpStartAddress;
	args[1] = lpParameter;
	HANDLE	res = CreateThread(lpThreadAttributes, dwStackSize, my_ThreadFunc_SEH, args, dwCreationFlags, lpThreadId);
	if (res == NULL) free(args);
	return res;
}
#endif//_DEBUG

//******************************************************************************

static LPVOID GetDllExportByOrdinal(HMODULE image_base_addr, DWORD ordinal)
{
	IMAGE_DOS_HEADER	*dos_header;
	IMAGE_NT_HEADERS	*nt_header;
	IMAGE_EXPORT_DIRECTORY	*export_dir;
	DWORD				*exports_by_ordinal;

#define	BASE_ADDRESS(offset)	((DWORD)image_base_addr + (DWORD)(offset))
	dos_header = (IMAGE_DOS_HEADER *)BASE_ADDRESS(0);
	if (IsBadReadPtr(dos_header, sizeof(IMAGE_DOS_HEADER)) ||
		dos_header->e_magic != IMAGE_DOS_SIGNATURE ||
		dos_header->e_lfarlc < sizeof(IMAGE_DOS_HEADER))
		return NULL;
	nt_header = (IMAGE_NT_HEADERS *)BASE_ADDRESS(dos_header->e_lfanew);
	if (IsBadReadPtr(nt_header, sizeof(IMAGE_NT_HEADERS)) ||
		nt_header->Signature != IMAGE_NT_SIGNATURE ||
		nt_header->FileHeader.SizeOfOptionalHeader != sizeof(IMAGE_OPTIONAL_HEADER) ||
		nt_header->OptionalHeader.NumberOfRvaAndSizes != IMAGE_NUMBEROF_DIRECTORY_ENTRIES)
		return NULL;
	export_dir = (IMAGE_EXPORT_DIRECTORY *)BASE_ADDRESS(nt_header->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress);
	if (IsBadReadPtr(export_dir, sizeof(IMAGE_EXPORT_DIRECTORY)))
		return NULL;
	exports_by_ordinal = (DWORD *)BASE_ADDRESS((DWORD)export_dir->AddressOfFunctions);
	if (IsBadReadPtr(exports_by_ordinal, export_dir->NumberOfFunctions * sizeof(DWORD)) ||
		ordinal == 0 || ordinal > export_dir->NumberOfFunctions)
		return NULL;
	return (LPVOID)BASE_ADDRESS(exports_by_ordinal[ordinal - 1]);
#undef	BASE_ADDRESS
}

/*static */LPVOID HookDllImport(HMODULE image_base_addr, LPSTR dll_name, LPSTR import_name, LPVOID new_import_vector)
{
	IMAGE_DOS_HEADER	*dos_header;
	IMAGE_NT_HEADERS	*nt_header;
	IMAGE_IMPORT_DESCRIPTOR	*import_dir;
	IMAGE_THUNK_DATA	*import_entry, *import_thunk;
	LPSTR				import_dllname;
	IMAGE_IMPORT_BY_NAME	*entry_name;
	DWORD				import_size;
	LPVOID				old_import_vector;
	DWORD				oldprot;

#define	BASE_ADDRESS(offset)	((DWORD)image_base_addr + (DWORD)(offset))
	dos_header = (IMAGE_DOS_HEADER *)BASE_ADDRESS(0);
	if (IsBadReadPtr(dos_header, sizeof(IMAGE_DOS_HEADER)) ||
		dos_header->e_magic != IMAGE_DOS_SIGNATURE ||
		dos_header->e_lfarlc < sizeof(IMAGE_DOS_HEADER))
		return NULL;
	nt_header = (IMAGE_NT_HEADERS *)BASE_ADDRESS(dos_header->e_lfanew);
	if (IsBadReadPtr(nt_header, sizeof(IMAGE_NT_HEADERS)) ||
		nt_header->Signature != IMAGE_NT_SIGNATURE ||
		nt_header->FileHeader.SizeOfOptionalHeader != sizeof(IMAGE_OPTIONAL_HEADER) ||
		nt_header->OptionalHeader.NumberOfRvaAndSizes != IMAGE_NUMBEROF_DIRECTORY_ENTRIES)
		return NULL;
	import_dir = (IMAGE_IMPORT_DESCRIPTOR *)BASE_ADDRESS(nt_header->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress);
	import_size = nt_header->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].Size;
	if (IsBadReadPtr(import_dir, import_size))
		return NULL;
	for (; import_dir->Name != NULL && import_size >= sizeof(IMAGE_IMPORT_DESCRIPTOR); import_dir++, import_size -= sizeof(IMAGE_IMPORT_DESCRIPTOR)) {
		import_dllname = (LPSTR)BASE_ADDRESS(import_dir->Name);
		if (IsBadStringPtr(import_dllname, 256))
			break;
		if (stricmp(import_dllname, dll_name))
			continue;
		import_entry = (IMAGE_THUNK_DATA *)BASE_ADDRESS(import_dir->OriginalFirstThunk);
		import_thunk = (IMAGE_THUNK_DATA *)BASE_ADDRESS(import_dir->FirstThunk);
		for (; ; import_entry++, import_thunk++) {
			if (IsBadReadPtr(import_entry, sizeof(IMAGE_THUNK_DATA)) || 
				import_entry->u1.Ordinal == 0)
				break;
			if (!IMAGE_SNAP_BY_ORDINAL(import_entry->u1.Ordinal)) {
				entry_name = (IMAGE_IMPORT_BY_NAME *)BASE_ADDRESS(import_entry->u1.AddressOfData);
				if (IsBadStringPtr((LPSTR)entry_name->Name, 256))
					break;
				if ((DWORD)import_name <= 0xFFFF || strcmp((LPSTR)entry_name->Name, import_name))
					continue;
			} else if (IMAGE_ORDINAL(import_entry->u1.Ordinal) != (DWORD)import_name)
				continue;
			if (IsBadReadPtr(import_thunk, sizeof(IMAGE_THUNK_DATA)))
				return NULL;
			old_import_vector = import_thunk->u1.Function;
			if (new_import_vector != NULL) {
				VirtualProtect(import_thunk, sizeof(IMAGE_THUNK_DATA), PAGE_EXECUTE_READWRITE, &oldprot);
				import_thunk->u1.Function = (LPDWORD)new_import_vector;
				VirtualProtect(import_thunk, sizeof(IMAGE_THUNK_DATA), oldprot, &oldprot);
			}
			return old_import_vector;
		}
	}
	return NULL;
#undef	BASE_ADDRESS
}

static void MimicKernel32DllImport(LPSTR import_name)
{
	LPVOID	oldv, newv;
	HANDLE	hmap;

	if ((oldv = HookDllImport(bleem_exe, bleem_nt_dll_name, import_name, NULL)) != NULL &&
		(hmap = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, 10, NULL)) != NULL &&
		(newv = MapViewOfFile(hmap, FILE_MAP_WRITE, 0, 0, 10)) != NULL) {
		HookDllImport(bleem_exe, bleem_nt_dll_name, import_name, newv);
		CloseHandle(hmap);	// no more needed
		BYTE	*p = (BYTE *)newv;
		p[0] = 0xB8;		// mov eax,value_gt_2GB
		*(DWORD *)(p + 1) = 0x87654321;
		p[5] = 0xE9;		// jmp oldv
		*(DWORD *)(p + 6) = (DWORD)oldv - (DWORD)(p + 10);
	}
}

//******************************************************************************

#ifdef	USE_DUMP_BLI_FILE
static void open_dump_bli_file(void)
{
	const char *version = NULL;
	const char *cputype = NULL;

	// detect bleem! version (by file size):
	char	buff[MAX_PATH], *p;
	HANDLE	hfile;
	DWORD	dwFileSize = 0;
	GetModuleFileName(NULL, buff, sizeof(buff));
	if ((hfile = CreateFile(buff, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
		dwFileSize = GetFileSize(hfile, NULL);
		CloseHandle(hfile);
	}
	switch (dwFileSize) {
	case 443648: version = "10"; break;		// 1.0
	case 451676: version = "11b2"; break;	// 1.1b2
	case 450552: version = "12b1"; break;	// 1.2b1
	case 449404: version = "12b2"; break;	// 1.2b2
	case 516288: version = "13"; break;		// 1.3
	case 647608: version = "14"; break;		// 1.4
	case 658796: version = "14a"; break;	// 1.4a
	case 693000: version = "15"; break;		// 1.5
	case 692732: version = "15a"; break;	// 1.5a
	case 693240: version = "15b"; break;	// 1.5b
	case 693068: version = "16a"; break;	// 1.6a
	case 693576: version = "16b"; break;	// 1.6b
	case 351732: return;					// 1.4demo
	default: version = NULL; break;
	}

	// detect cpu model:
	DWORD	is_CPUID_supported_flg;
	BOOL	is_MMX_supported_flg = FALSE;
	BOOL	is_AMD_processor_flg = FALSE;
	BOOL	is_3DNow_supported_flg = FALSE;
	static const char	amd_vendor_str[] = "AuthenticAMD";
	__asm pushfd
	__asm pop	eax
	__asm mov	dword ptr [is_CPUID_supported_flg],eax
	__asm xor	eax,0x00200000	// toggle ID bit
	__asm push	eax
	__asm popfd
	__asm pushfd
	__asm pop	eax
	__asm xor	dword ptr [is_CPUID_supported_flg],eax
	__asm je	no_cpuid_support
	__asm mov	eax,0x00000000	// get maximum supported standard level & vendor ID string
	__asm __emit 0x0F __asm __emit 0xA2	// cpuid
	__asm cmp	eax,0x00000001
	__asm jl	no_mmx_support
	__asm mov	eax,0x00000001	// get processor type/family/model/stepping & feature flags
	__asm __emit 0x0F __asm __emit 0xA2	// cpuid
	__asm test	edx,0x00800000	// MMX feature flag
	__asm je	no_mmx_support
	__asm inc	[is_MMX_supported_flg]
	__asm no_mmx_support:
	__asm mov	eax,0x00000000	// get maximum supported standard level & vendor ID string
	__asm __emit 0x0F __asm __emit 0xA2	// cpuid
	__asm cmp	ebx, dword ptr [amd_vendor_str + 0]
	__asm jne	no_amd_vendor
	__asm cmp	edx, dword ptr [amd_vendor_str + 4]
	__asm jne	no_amd_vendor
	__asm cmp	ecx, dword ptr [amd_vendor_str + 8]
	__asm jne	no_amd_vendor
	__asm mov	eax,0x80000000	// get maximum supported extended level & vendor ID string
	__asm __emit 0x0F __asm __emit 0xA2	// cpuid
	__asm cmp	eax,0x80000001
	__asm jl	no_amd_vendor
	__asm mov	eax,0x80000001	// get processor family/model/stepping & features flags
	__asm __emit 0x0F __asm __emit 0xA2	// cpuid
	__asm cmp	ah,6			// skip AMD K5 version
	__asm jl	no_amd_vendor
	__asm inc	[is_AMD_processor_flg]
	__asm test	edx,0x80000000	// 3DNow! feature flag
	__asm je	no_3dnow_support
	__asm inc	[is_3DNow_supported_flg]
	__asm no_3dnow_support:
	__asm no_amd_vendor:
	__asm no_cpuid_support:
	cputype = (!is_MMX_supported_flg)	? "non" :
			  (!is_AMD_processor_flg)	? "mmx" :
			  (!is_3DNow_supported_flg)	? "k62" : "amd";

	// open version/cputype-dependent 'dump.bli' file:
	p = ((p = strrchr(buff, '\\')) != NULL) ? p + 1 : buff;
	for (int idx = 0; idx < 2; idx++) {
		if (idx == 0) {
			if (version == NULL || cputype == NULL)
				continue;
			sprintf(p, "%s-%s.bli", version, cputype);
		} else {
			strcpy(p, "dump.bli");
		}
		if ((dump_bli_file = CreateFile(buff, GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
#ifdef	_DEBUG
			Log("Using \"%s\" as 'dump.bli' file", buff);
#endif//_DEBUG
			break;
		}
	}
}
#endif//USE_DUMP_BLI_FILE

static BOOL init_hooks(void)
{
	char		buff[MAX_PATH], *p;

	GetModuleFileName((HMODULE)hInstance, buff, sizeof(buff));
	p = strrchr(buff, '\\');
	strcpy(bleem_nt_dll_name, (p != NULL) ? p + 1 : buff);
	kernel32_dll = GetModuleHandle(kernel32_dll_name);
	dinput_dll = GetModuleHandle(dinput_dll_name);
	bleem_exe = GetModuleHandle(NULL);

	memset(&os_version, 0, sizeof(os_version));
	os_version.dwOSVersionInfoSize = sizeof(os_version);
	GetVersionEx(&os_version);

	switch (os_version.dwPlatformId) {
	case VER_PLATFORM_WIN32_WINDOWS:
		// get the 'original' address from kernel32.dll
		VxDCall = GetDllExportByOrdinal(kernel32_dll, 0x0001);
		LoadLibrary16 = GetDllExportByOrdinal(kernel32_dll, 0x0023);
		FreeLibrary16 = GetDllExportByOrdinal(kernel32_dll, 0x0024);
		GetProcAddress16 = GetDllExportByOrdinal(kernel32_dll, 0x0025);
		QT_Thunk = GetProcAddress(kernel32_dll, "QT_Thunk");
		MapLS = GetProcAddress(kernel32_dll, "MapLS");
		SMapLS = GetProcAddress(kernel32_dll, "SMapLS");
		UnMapLS = GetProcAddress(kernel32_dll, "UnMapLS");
		// replace Win9x specific imports with the original address in bleem.exe
		HookDllImport(bleem_exe, bleem_nt_dll_name, (LPSTR)0x0001, W9xIMPORT(VxDCall));
		HookDllImport(bleem_exe, bleem_nt_dll_name, (LPSTR)0x0023, W9xIMPORT(LoadLibrary16));
		HookDllImport(bleem_exe, bleem_nt_dll_name, (LPSTR)0x0024, W9xIMPORT(FreeLibrary16));
		HookDllImport(bleem_exe, bleem_nt_dll_name, (LPSTR)0x0025, W9xIMPORT(GetProcAddress16));
		HookDllImport(bleem_exe, bleem_nt_dll_name, "QT_Thunk", W9xIMPORT(QT_Thunk));
		HookDllImport(bleem_exe, bleem_nt_dll_name, "MapLS", W9xIMPORT(MapLS));
		HookDllImport(bleem_exe, bleem_nt_dll_name, "SMapLS", W9xIMPORT(SMapLS));
		HookDllImport(bleem_exe, bleem_nt_dll_name, "UnMapLS", W9xIMPORT(UnMapLS));
#if defined(_DEBUG) && defined(ENABLE_DIRECTX_LOG)
		// for DirectX calls logging on Win9x:
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetProcAddress", my_GetProcAddress);
#endif//_DEBUG && ENABLE_DIRECTX_LOG
		HookDllImport(dinput_dll, user32_dll_name, "LoadStringA", myDirectInput_LoadStringA);
#ifdef	USE_DUMP_BLI_FILE
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetDiskFreeSpaceA", my_GetDiskFreeSpaceA);
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetTickCount", my_GetTickCount);
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetVolumeInformationA", my_GetVolumeInformationA);
#endif//USE_DUMP_BLI_FILE
		// Warning: the program want next import coming from kernel area (> 2GB)
		MimicKernel32DllImport("GetVolumeInformationA");
		break;
	case VER_PLATFORM_WIN32_NT:
		// Note: on WinNT, next functions doesn't work the same manner as Win9x ones:
		//CloseHandle
		//CreateFileA
		//CreateFileMappingA
		//DeviceIoControl
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetVolumeInformationA", my_GetVolumeInformationA);
		//MapViewOfFile
		HookDllImport(bleem_exe, bleem_nt_dll_name, "SetEvent", my_SetEvent);
		//UnmapViewOfFile
		// Note: on WinNT, DirectX require some 'multithread patching' in order to work (see 'dxwrap_GetProcAddressHook()'):
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetProcAddress", my_GetProcAddress);
		// Translate DirectInput strings for non-English DirectX versions
		HookDllImport(dinput_dll, user32_dll_name, "LoadStringW", myDirectInput_LoadStringW);
		// Install the SEH (exception handling) filter:
#ifdef	_DEBUG
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetVersionExA", my_GetVersionExA_SEH);
		HookDllImport(bleem_exe, bleem_nt_dll_name, "CreateThread", my_CreateThread_SEH);
#else //_DEBUG
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetVersionExA", my_GetVersionExA);
		SetUnhandledExceptionFilter(my_except_filter);
#endif//_DEBUG
#ifdef	USE_DUMP_BLI_FILE
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetDiskFreeSpaceA", my_GetDiskFreeSpaceA);
		HookDllImport(bleem_exe, bleem_nt_dll_name, "GetTickCount", my_GetTickCount);
#endif//USE_DUMP_BLI_FILE
		break;
	case VER_PLATFORM_WIN32s:
	default:
		return FALSE;
	}

#ifdef	USE_DUMP_BLI_FILE
	open_dump_bli_file();
#endif//USE_DUMP_BLI_FILE

	return TRUE;
}

//******************************************************************************

BOOL WINAPI DllMain(HANDLE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	switch (fdwReason) {
	case DLL_PROCESS_ATTACH:	// called on DLL load
		hInstance = hinstDLL;
		hProcessHeap = GetProcessHeap();
		DisableThreadLibraryCalls(hinstDLL);
		InitializeCriticalSection(&vxdcall_crtsec);
		cdrom_init();
		return init_hooks();
	case DLL_PROCESS_DETACH:	// called on DLL unload
		cdrom_free();
		DeleteCriticalSection(&vxdcall_crtsec);
		return TRUE;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
		return TRUE;
	}
	return FALSE;
}

//******************************************************************************
