#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3D::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3D_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3D::AddRef(THIS)
{
	ULONG res;
	res = IDirect3D_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3D::Release(THIS)
{
	ULONG res;
	res = IDirect3D_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3D::Initialize(THIS_ REFCLSID lpREFIID)
{
	HRESULT res;
	res = IDirect3D_Initialize(p, lpREFIID);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_Initialize(this=%08x, lpREFIID=%s) = %s",
		p, GUIDtoStr(&lpREFIID), D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3D::EnumDevices(THIS_ LPD3DENUMDEVICESCALLBACK lpEnumDevicesCallback, LPVOID lpUserArg)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumDevicesCallback, lpUserArg);
	res = IDirect3D_EnumDevices(p, myCallbackClass::myD3DEnumDevicesCallback, ctx);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_EnumDevices(this=%08x, lpEnumDevicesCallback=%08x, lpUserArg=%08x) = %s",
		p, lpEnumDevicesCallback, lpUserArg, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3D::CreateLight(THIS_ LPDIRECT3DLIGHT *lplpDirect3DLight, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirect3D_CreateLight(p, lplpDirect3DLight, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_CreateLight(this=%08x, *lplpDirect3DLight=%08x, pUnkOuter=%08x) = %s",
		p, *lplpDirect3DLight, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DLight, (LPVOID *)lplpDirect3DLight);
	return res;
}
HRESULT WINAPI myIDirect3D::CreateMaterial(THIS_ LPDIRECT3DMATERIAL *lplpDirect3DMaterial, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirect3D_CreateMaterial(p, lplpDirect3DMaterial, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_CreateMaterial(this=%08x, *lplpDirect3DMaterial=%08x, pUnkOuter=%08x) = %s",
		p, *lplpDirect3DMaterial, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DMaterial, (LPVOID *)lplpDirect3DMaterial);
	return res;
}
HRESULT WINAPI myIDirect3D::CreateViewport(THIS_ LPDIRECT3DVIEWPORT *lplpD3DViewport, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirect3D_CreateViewport(p, lplpD3DViewport, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_CreateViewport(this=%08x, *lplpD3DViewport=%08x, pUnkOuter=%08x) = %s",
		p, *lplpD3DViewport, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DViewport, (LPVOID *)lplpD3DViewport);
	return res;
}
HRESULT WINAPI myIDirect3D::FindDevice(THIS_ LPD3DFINDDEVICESEARCH lpD3DFDS, LPD3DFINDDEVICERESULT lpD3DFDR)
{
	HRESULT res;
	res = IDirect3D_FindDevice(p, lpD3DFDS, lpD3DFDR);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D_FindDevice(this=%08x, lpD3DFDS=%08x, lpD3DFDR=%08x) = %s",
		p, lpD3DFDS, lpD3DFDR, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
