#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DDevice2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DDevice2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DDevice2::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DDevice2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DDevice2::Release(THIS)
{
	ULONG res;
	res = IDirect3DDevice2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetCaps(THIS_ LPD3DDEVICEDESC lpD3DHWDevDesc, LPD3DDEVICEDESC lpD3DHELDevDesc)
{
	HRESULT res;
	res = IDirect3DDevice2_GetCaps(p, lpD3DHWDevDesc, lpD3DHELDevDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetCaps(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::SwapTextureHandles(THIS_ LPDIRECT3DTEXTURE2 lpD3DTex1, LPDIRECT3DTEXTURE2 lpD3DTex2)
{
	HRESULT res;
	lpD3DTex1 = myIDirect3DTexture2::getBaseInterface(lpD3DTex1);
	lpD3DTex2 = myIDirect3DTexture2::getBaseInterface(lpD3DTex2);
	res = IDirect3DDevice2_SwapTextureHandles(p, lpD3DTex1, lpD3DTex2);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_SwapTextureHandles(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetStats(THIS_ LPD3DSTATS lpD3DStats)
{
	HRESULT res;
	res = IDirect3DDevice2_GetStats(p, lpD3DStats);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetStats(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::AddViewport(THIS_ LPDIRECT3DVIEWPORT2 lpDirect3DViewport)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport2::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice2_AddViewport(p, lpDirect3DViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_AddViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::DeleteViewport(THIS_ LPDIRECT3DVIEWPORT2 lpDirect3DViewport)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport2::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice2_DeleteViewport(p, lpDirect3DViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_DeleteViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::NextViewport(THIS_ LPDIRECT3DVIEWPORT2 lpDirect3DViewport, LPDIRECT3DVIEWPORT2 *lplpAnotherViewport, DWORD dwFlags)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport2::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice2_NextViewport(p, lpDirect3DViewport, lplpAnotherViewport, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_NextViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DViewport2, (LPVOID *)lplpAnotherViewport);
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::EnumTextureFormats(THIS_ LPD3DENUMTEXTUREFORMATSCALLBACK lpd3dEnumTextureProc, LPVOID lpArg)
{
	HRESULT res;
	res = IDirect3DDevice2_EnumTextureFormats(p, lpd3dEnumTextureProc, lpArg);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_EnumTextureFormats(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::BeginScene(THIS)
{
	HRESULT res;
	res = IDirect3DDevice2_BeginScene(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_BeginScene(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::EndScene(THIS)
{
	HRESULT res;
	res = IDirect3DDevice2_EndScene(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_EndScene(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetDirect3D(THIS_ LPDIRECT3D2 *lplpD3D)
{
	HRESULT res;
	res = IDirect3DDevice2_GetDirect3D(p, lplpD3D);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetDirect3D(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3D2, (LPVOID *)lplpD3D);
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::SetCurrentViewport(THIS_ LPDIRECT3DVIEWPORT2 lpd3dViewport)
{
	HRESULT res;
	lpd3dViewport = myIDirect3DViewport2::getBaseInterface(lpd3dViewport);
	res = IDirect3DDevice2_SetCurrentViewport(p, lpd3dViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_SetCurrentViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetCurrentViewport(THIS_ LPDIRECT3DVIEWPORT2 *lplpd3dViewport)
{
	HRESULT res;
	res = IDirect3DDevice2_GetCurrentViewport(p, lplpd3dViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetCurrentViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DViewport2, (LPVOID *)lplpd3dViewport);
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::SetRenderTarget(THIS_ LPDIRECTDRAWSURFACE lpNewRenderTarget, DWORD dwFlags)
{
	HRESULT res;
	lpNewRenderTarget = myIDirectDrawSurface::getBaseInterface(lpNewRenderTarget);
	res = IDirect3DDevice2_SetRenderTarget(p, lpNewRenderTarget, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_SetRenderTarget(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetRenderTarget(THIS_ LPDIRECTDRAWSURFACE *lplpRenderTarget)
{
	HRESULT res;
	res = IDirect3DDevice2_GetRenderTarget(p, lplpRenderTarget);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetRenderTarget(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpRenderTarget);
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::Begin(THIS_ D3DPRIMITIVETYPE d3dpt, D3DVERTEXTYPE dwVertexTypeDesc, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice2_Begin(p, d3dpt, dwVertexTypeDesc, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_Begin(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::BeginIndexed(THIS_ D3DPRIMITIVETYPE dptPrimitiveType, D3DVERTEXTYPE dwVertexTypeDesc, LPVOID lpvVertices, DWORD dwNumVertices, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice2_BeginIndexed(p, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwNumVertices, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_BeginIndexed(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::Vertex(THIS_ LPVOID lpVertex)
{
	HRESULT res;
	res = IDirect3DDevice2_Vertex(p, lpVertex);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_Vertex(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::Index(THIS_ WORD wVertexIndex)
{
	HRESULT res;
	res = IDirect3DDevice2_Index(p, wVertexIndex);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_Index(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::End(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice2_End(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_End(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetRenderState(THIS_ D3DRENDERSTATETYPE dwRenderStateType, LPDWORD lpdwRenderState)
{
	HRESULT res;
	res = IDirect3DDevice2_GetRenderState(p, dwRenderStateType, lpdwRenderState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetRenderState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::SetRenderState(THIS_ D3DRENDERSTATETYPE dwRenderStateType, DWORD dwRenderState)
{
	HRESULT res;
	res = IDirect3DDevice2_SetRenderState(p, dwRenderStateType, dwRenderState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_SetRenderState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetLightState(THIS_ D3DLIGHTSTATETYPE dwLightStateType, LPDWORD lpdwLightState)
{
	HRESULT res;
	res = IDirect3DDevice2_GetLightState(p, dwLightStateType, lpdwLightState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetLightState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::SetLightState(THIS_ D3DLIGHTSTATETYPE dwLightStateType, DWORD dwLightState)
{
	HRESULT res;
	res = IDirect3DDevice2_SetLightState(p, dwLightStateType, dwLightState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_SetLightState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::SetTransform(THIS_ D3DTRANSFORMSTATETYPE dtstTransformStateType, LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice2_SetTransform(p, dtstTransformStateType, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_SetTransform(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetTransform(THIS_ D3DTRANSFORMSTATETYPE dtstTransformStateType, LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice2_GetTransform(p, dtstTransformStateType, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetTransform(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::MultiplyTransform(THIS_ D3DTRANSFORMSTATETYPE dtstTransformStateType, LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice2_MultiplyTransform(p, dtstTransformStateType, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_MultiplyTransform(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::DrawPrimitive(THIS_ D3DPRIMITIVETYPE dptPrimitiveType, D3DVERTEXTYPE dwVertexTypeDesc, LPVOID lpvVertices, DWORD dwVertexCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice2_DrawPrimitive(p, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_DrawPrimitive(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::DrawIndexedPrimitive(THIS_ D3DPRIMITIVETYPE d3dptPrimitiveType, D3DVERTEXTYPE dwVertexTypeDesc, LPVOID lpvVertices, DWORD dwVertexCount, LPWORD lpwIndices, DWORD dwIndexCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice2_DrawIndexedPrimitive(p, d3dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_DrawIndexedPrimitive(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::SetClipStatus(THIS_ LPD3DCLIPSTATUS lpD3DClipStatus)
{
	HRESULT res;
	res = IDirect3DDevice2_SetClipStatus(p, lpD3DClipStatus);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_SetClipStatus(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice2::GetClipStatus(THIS_ LPD3DCLIPSTATUS lpD3DClipStatus)
{
	HRESULT res;
	res = IDirect3DDevice2_GetClipStatus(p, lpD3DClipStatus);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice2_GetClipStatus(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
