#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DMaterial2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DMaterial2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DMaterial2::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DMaterial2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DMaterial2::Release(THIS)
{
	ULONG res;
	res = IDirect3DMaterial2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DMaterial2::SetMaterial(THIS_ LPD3DMATERIAL lpMat)
{
	HRESULT res;
	res = IDirect3DMaterial2_SetMaterial(p, lpMat);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial2_SetMaterial(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DMaterial2::GetMaterial(THIS_ LPD3DMATERIAL lpMat)
{
	HRESULT res;
	res = IDirect3DMaterial2_GetMaterial(p, lpMat);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial2_GetMaterial(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DMaterial2::GetHandle(THIS_ LPDIRECT3DDEVICE2 lpD3DDevice, LPD3DMATERIALHANDLE lpHandle)
{
	HRESULT res;
	lpD3DDevice = myIDirect3DDevice2::getBaseInterface(lpD3DDevice);
	res = IDirect3DMaterial2_GetHandle(p, lpD3DDevice, lpHandle);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DMaterial2_GetHandle(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
