#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDrawClipper::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDrawClipper_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDrawClipper::AddRef(THIS)
{
	ULONG res;
	res = IDirectDrawClipper_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDrawClipper::Release(THIS)
{
	ULONG res;
	res = IDirectDrawClipper_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}

HRESULT WINAPI myIDirectDrawClipper::GetClipList(THIS_ LPRECT lpRect, LPRGNDATA lpClipList, LPDWORD lpdwSize)
{
	ULONG res;
	res = IDirectDrawClipper_GetClipList(p, lpRect, lpClipList, lpdwSize);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_GetClipList(this=%08x, lpRect=%08x, lpClipList=%08x, lpdwSize=%08x) = %s",
		p, lpRect, lpClipList, lpdwSize, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawClipper::GetHWnd(THIS_ HWND FAR *lphWnd)
{
	ULONG res;
	res = IDirectDrawClipper_GetHWnd(p, lphWnd);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_GetHWnd(this=%08x, *lphWnd=%08x) = %s",
		p, *lphWnd, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawClipper::Initialize(THIS_ LPDIRECTDRAW lpDD, DWORD dwFlags)
{
	ULONG res;
	lpDD = myIDirectDraw::getBaseInterface(lpDD);
	res = IDirectDrawClipper_Initialize(p, lpDD, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_Initialize(this=%08x, lpDD=%08x, dwFlags=%08x) = %s",
		p, lpDD, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawClipper::IsClipListChanged(THIS_ BOOL FAR *lpbChanged)
{
	ULONG res;
	res = IDirectDrawClipper_IsClipListChanged(p, lpbChanged);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_IsClipListChanged(this=%08x, *lpbChanged=%08x) = %s",
		p, *lpbChanged, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawClipper::SetClipList(THIS_ LPRGNDATA lpClipList, DWORD dwFlags)
{
	ULONG res;
	res = IDirectDrawClipper_SetClipList(p, lpClipList, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_SetClipList(this=%08x, lpClipList=%08x, dwFlags=%08x) = %s",
		p, lpClipList, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawClipper::SetHWnd(THIS_ DWORD dwFlags, HWND hWnd)
{
	ULONG res;
	res = IDirectDrawClipper_SetHWnd(p, dwFlags, hWnd);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawClipper_SetHWnd(this=%08x, dwFlags=%08x, hWnd=%08x) = %s",
		p, dwFlags, hWnd, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
