#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDrawColorControl::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDrawColorControl_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawColorControl_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDrawColorControl::AddRef(THIS)
{
	ULONG res;
	res = IDirectDrawColorControl_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawColorControl_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDrawColorControl::Release(THIS)
{
	ULONG res;
	res = IDirectDrawColorControl_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawColorControl_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDrawColorControl::GetColorControls(THIS_ LPDDCOLORCONTROL lpColorControl)
{
	ULONG res;
	res = IDirectDrawColorControl_GetColorControls(p, lpColorControl);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawColorControl_GetColorControls(this=%08x, lpColorControl=%08x) = %s",
		p, lpColorControl, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawColorControl::SetColorControls(THIS_ LPDDCOLORCONTROL lpColorControl)
{
	ULONG res;
	res = IDirectDrawColorControl_SetColorControls(p, lpColorControl);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawColorControl_SetColorControls(this=%08x, lpColorControl=%08x) = %s",
		p, lpColorControl, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
