#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDrawGammaControl::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDrawGammaControl_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawGammaControl_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDrawGammaControl::AddRef(THIS)
{
	ULONG res;
	res = IDirectDrawGammaControl_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawGammaControl_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDrawGammaControl::Release(THIS)
{
	ULONG res;
	res = IDirectDrawGammaControl_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawGammaControl_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDrawGammaControl::GetGammaRamp(THIS_ DWORD dwFlags, LPDDGAMMARAMP lpRampData)
{
	HRESULT res;
	res = IDirectDrawGammaControl_GetGammaRamp(p, dwFlags, lpRampData);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawGammaControl_GetGammaRamp(this=%08x, dwFlags=%08x, lpRampData=%08x) = %s",
		p, dwFlags, lpRampData, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawGammaControl::SetGammaRamp(THIS_ DWORD dwFlags, LPDDGAMMARAMP lpRampData)
{
	HRESULT res;
	res = IDirectDrawGammaControl_SetGammaRamp(p, dwFlags, lpRampData);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawGammaControl_SetGammaRamp(this=%08x, dwFlags=%08x, lpRampData=%08x) = %s",
		p, dwFlags, lpRampData, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
