#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDrawSurface2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDrawSurface2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDrawSurface2::AddRef(THIS)
{
	ULONG res;
	res = IDirectDrawSurface2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDrawSurface2::Release(THIS)
{
	ULONG res;
	res = IDirectDrawSurface2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::AddAttachedSurface(THIS_ LPDIRECTDRAWSURFACE2 lpDDSAttachedSurface)
{
	HRESULT res;
	lpDDSAttachedSurface = myIDirectDrawSurface2::getBaseInterface(lpDDSAttachedSurface);
	res = IDirectDrawSurface2_AddAttachedSurface(p, lpDDSAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_AddAttachedSurface(this=%08x, lpDDSAttachedSurface=%08x) = %s",
		p, lpDDSAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::AddOverlayDirtyRect(THIS_ LPRECT lpRect)
{
	HRESULT res;
	res = IDirectDrawSurface2_AddOverlayDirtyRect(p, lpRect);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_AddOverlayDirtyRect(this=%08x, lpRect=%08x) = %s",
		p, lpRect, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::Blt(THIS_ LPRECT lpDestRect, LPDIRECTDRAWSURFACE2 lpDDSrcSurface, LPRECT lpSrcRect, DWORD dwFlags, LPDDBLTFX lpDDBltFx)
{
	HRESULT res;
	lpDDSrcSurface = myIDirectDrawSurface2::getBaseInterface(lpDDSrcSurface);
	res = IDirectDrawSurface2_Blt(p, lpDestRect, lpDDSrcSurface, lpSrcRect, dwFlags, lpDDBltFx);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_Blt(this=%08x, lpDestRect=%08x, lpDDSrcSurface=%08x, lpSrcRect=%08x, dwFlags=%08x, lpDDBltFx=%08x) = %s",
		p, lpDestRect, lpDDSrcSurface, lpSrcRect, dwFlags, lpDDBltFx, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::BltBatch(THIS_ LPDDBLTBATCH lpDDBltBatch, DWORD dwCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface2_BltBatch(p, lpDDBltBatch, dwCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_BltBatch(this=%08x, lpDDBltBatch=%08x, dwCount=%08x, dwFlags=%08x) = %s",
		p, lpDDBltBatch, dwCount, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::BltFast(THIS_ DWORD dwX, DWORD dwY, LPDIRECTDRAWSURFACE2 lpDDSrcSurface, LPRECT lpSrcRect, DWORD dwTrans)
{
	HRESULT res;
	lpDDSrcSurface = myIDirectDrawSurface2::getBaseInterface(lpDDSrcSurface);
	res = IDirectDrawSurface2_BltFast(p, dwX, dwY, lpDDSrcSurface, lpSrcRect, dwTrans);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_BltFast(this=%08x, dwX=%08x, dwY=%08x, lpDDSrcSurface=%08x, lpSrcRect=%08x, dwTrans=%08x) = %s",
		p, dwX, dwY, lpDDSrcSurface, lpSrcRect, dwTrans, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::DeleteAttachedSurface(THIS_ DWORD dwFlags, LPDIRECTDRAWSURFACE2 lpDDSAttachedSurface)
{
	HRESULT res;
	lpDDSAttachedSurface = myIDirectDrawSurface2::getBaseInterface(lpDDSAttachedSurface);
	res = IDirectDrawSurface2_DeleteAttachedSurface(p, dwFlags, lpDDSAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_DeleteAttachedSurface(this=%08x, dwFlags=%08x, lpDDSAttachedSurface=%08x) = %s",
		p, dwFlags, lpDDSAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::EnumAttachedSurfaces(THIS_ LPVOID lpContext, LPDDENUMSURFACESCALLBACK lpEnumSurfacesCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumSurfacesCallback, lpContext);
	res = IDirectDrawSurface2_EnumAttachedSurfaces(p, ctx, myCallbackClass::myEnumSurfacesCallback);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_EnumAttachedSurfaces(this=%08x, lpContext=%08x, lpEnumSurfacesCallback=%08x) = %s",
		p, lpContext, lpEnumSurfacesCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::EnumOverlayZOrders(THIS_ DWORD dwFlags, LPVOID lpContext, LPDDENUMSURFACESCALLBACK lpfnCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpfnCallback, lpContext);
	res = IDirectDrawSurface2_EnumOverlayZOrders(p, dwFlags, ctx, myCallbackClass::myEnumSurfacesCallback);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_EnumOverlayZOrders(this=%08x, dwFlags=%08x, lpContext=%08x, lpfnCallback=%08x) = %s",
		p, dwFlags, lpContext, lpfnCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::Flip(THIS_ LPDIRECTDRAWSURFACE2 lpDDSurfaceTargetOverride, DWORD dwFlags)
{
	HRESULT res;
	lpDDSurfaceTargetOverride = myIDirectDrawSurface2::getBaseInterface(lpDDSurfaceTargetOverride);
	res = IDirectDrawSurface2_Flip(p, lpDDSurfaceTargetOverride, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_Flip(this=%08x, lpDDSurfaceTargetOverride=%08x, dwFlags=%08x) = %s",
		p, lpDDSurfaceTargetOverride, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetAttachedSurface(THIS_ LPDDSCAPS lpDDSCaps, LPDIRECTDRAWSURFACE2 FAR *lplpDDAttachedSurface)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetAttachedSurface(p, lpDDSCaps, lplpDDAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetAttachedSurface(this=%08x, lpDDSCaps=%08x, *lplpDDAttachedSurface=%08x) = %s",
		p, lpDDSCaps, *lplpDDAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface2, (LPVOID *)lplpDDAttachedSurface);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetBltStatus(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetBltStatus(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetBltStatus(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetCaps(THIS_ LPDDSCAPS lpDDSCaps)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetCaps(p, lpDDSCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetCaps(this=%08x, lpDDSCaps=%08x) = %s",
		p, lpDDSCaps, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetClipper(THIS_ LPDIRECTDRAWCLIPPER FAR *lplpDDClipper)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetClipper(p, lplpDDClipper);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetClipper(this=%08x, *lplpDDClipper=%08x) = %s",
		p, *lplpDDClipper, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawClipper, (LPVOID *)lplpDDClipper);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetColorKey(THIS_ DWORD dwFlags, LPDDCOLORKEY lpDDColorKey)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetColorKey(p, dwFlags, lpDDColorKey);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetColorKey(this=%08x, dwFlags=%08x, lpDDColorKey=%08x) = %s",
		p, dwFlags, lpDDColorKey, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetDC(THIS_ HDC FAR *lphDC)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetDC(p, lphDC);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetDC(this=%08x, *lphDC=%08x) = %s",
		p, *lphDC, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetFlipStatus(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetFlipStatus(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetFlipStatus(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetOverlayPosition(THIS_ LPLONG lplX, LPLONG lplY)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetOverlayPosition(p, lplX, lplY);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetOverlayPosition(this=%08x, *lplX=%s, lplY=%s) = %s",
		p, LpDwtoStr((LPDWORD)lplX), LpDwtoStr((LPDWORD)lplY), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetPalette(THIS_ LPDIRECTDRAWPALETTE FAR *lplpDDPalette)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetPalette(p, lplpDDPalette);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetPalette(this=%08x, *lplpDDPalette=%08x) = %s",
		p, *lplpDDPalette, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawPalette, (LPVOID *)lplpDDPalette);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetPixelFormat(THIS_ LPDDPIXELFORMAT lpDDPixelFormat)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetPixelFormat(p, lpDDPixelFormat);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetPixelFormat(this=%08x, lpDDPixelFormat=%08x) = %s",
		p, lpDDPixelFormat, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetSurfaceDesc(THIS_ LPDDSURFACEDESC lpDDSurfaceDesc)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetSurfaceDesc(p, lpDDSurfaceDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetSurfaceDesc(this=%08x, lpDDSurfaceDesc=%08x) = %s",
		p, lpDDSurfaceDesc, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::Initialize(THIS_ LPDIRECTDRAW lpDD, LPDDSURFACEDESC lpDDSurfaceDesc)
{
	HRESULT res;
	lpDD = myIDirectDraw::getBaseInterface(lpDD);
	res = IDirectDrawSurface2_Initialize(p, lpDD, lpDDSurfaceDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_Initialize(this=%08x, lpDD=%08x, lpDDSurfaceDesc=%08x) = %s",
		p, lpDD, lpDDSurfaceDesc, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::IsLost(THIS)
{
	HRESULT res;
	res = IDirectDrawSurface2_IsLost(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_IsLost(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::Lock(THIS_ LPRECT lpDestRect, LPDDSURFACEDESC lpDDSurfaceDesc, DWORD dwFlags, HANDLE hEvent)
{
	HRESULT res;
	res = IDirectDrawSurface2_Lock(p, lpDestRect, lpDDSurfaceDesc, dwFlags, hEvent);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_Lock(this=%08x, lpDestRect=%08x, lpDDSurfaceDesc=%08x, dwFlags=%08x, hEvent=%08x) = %s",
		p, lpDestRect, lpDDSurfaceDesc, dwFlags, hEvent, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::ReleaseDC(THIS_ HDC hDC)
{
	HRESULT res;
	res = IDirectDrawSurface2_ReleaseDC(p, hDC);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_ReleaseDC(this=%08x, hDC=%08x) = %s",
		p, hDC, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::Restore(THIS)
{
	HRESULT res;
	res = IDirectDrawSurface2_Restore(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_Restore(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::SetClipper(THIS_ LPDIRECTDRAWCLIPPER lpDDClipper)
{
	HRESULT res;
	lpDDClipper = myIDirectDrawClipper::getBaseInterface(lpDDClipper);
	res = IDirectDrawSurface2_SetClipper(p, lpDDClipper);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_SetClipper(this=%08x, lpDDClipper=%08x) = %s",
		p, lpDDClipper, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::SetColorKey(THIS_ DWORD dwFlags, LPDDCOLORKEY lpDDColorKey)
{
	HRESULT res;
	res = IDirectDrawSurface2_SetColorKey(p, dwFlags, lpDDColorKey);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_SetColorKey(this=%08x, dwFlags=%08x, lpDDColorKey=%08x) = %s",
		p, dwFlags, lpDDColorKey, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::SetOverlayPosition(THIS_ LONG lX, LONG lY)
{
	HRESULT res;
	res = IDirectDrawSurface2_SetOverlayPosition(p, lX, lY);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_SetOverlayPosition(this=%08x, lX=%08x, lY=%08x) = %s",
		p, lX, lY, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::SetPalette(THIS_ LPDIRECTDRAWPALETTE lpDDPalette)
{
	HRESULT res;
	lpDDPalette = myIDirectDrawPalette::getBaseInterface(lpDDPalette);
	res = IDirectDrawSurface2_SetPalette(p, lpDDPalette);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_SetPalette(this=%08x, lpDDPalette=%08x) = %s",
		p, lpDDPalette, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::Unlock(THIS_ LPVOID lpSurfaceData)
{
	HRESULT res;
	res = IDirectDrawSurface2_Unlock(p, lpSurfaceData);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_Unlock(this=%08x, lpSurfaceData=%08x) = %s",
		p, lpSurfaceData, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::UpdateOverlay(THIS_ LPRECT lpSrcRect, LPDIRECTDRAWSURFACE2 lpDDDestSurface, LPRECT lpDestRect, DWORD dwFlags, LPDDOVERLAYFX lpDDOverlayFx)
{
	HRESULT res;
	lpDDDestSurface = myIDirectDrawSurface2::getBaseInterface(lpDDDestSurface);
	res = IDirectDrawSurface2_UpdateOverlay(p, lpSrcRect, lpDDDestSurface, lpDestRect, dwFlags, lpDDOverlayFx);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_UpdateOverlay(this=%08x, lpSrcRect=%08x, lpDDDestSurface=%08x, lpDestRect=%08x, dwFlags=%08x, lpDDOverlayFx=%08x) = %s",
		p, lpSrcRect, lpDDDestSurface, lpDestRect, dwFlags, lpDDOverlayFx, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::UpdateOverlayDisplay(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface2_UpdateOverlayDisplay(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_UpdateOverlayDisplay(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::UpdateOverlayZOrder(THIS_ DWORD dwFlags, LPDIRECTDRAWSURFACE2 lpDDSReference)
{
	HRESULT res;
	lpDDSReference = myIDirectDrawSurface2::getBaseInterface(lpDDSReference);
	res = IDirectDrawSurface2_UpdateOverlayZOrder(p, dwFlags, lpDDSReference);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_UpdateOverlayZOrder(this=%08x, dwFlags=%08x, lpDDSReference=%08x) = %s",
		p, dwFlags, lpDDSReference, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::GetDDInterface(THIS_ LPVOID FAR *lplpDD)
{
	HRESULT res;
	res = IDirectDrawSurface2_GetDDInterface(p, lplpDD);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_GetDDInterface(this=%08x, *lplpDD=%08x) = %s",
		p, *lplpDD, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDraw, (LPVOID *)lplpDD);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::PageLock(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface2_PageLock(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_PageLock(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface2::PageUnlock(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface2_PageUnlock(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface2_PageUnlock(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
