#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectSoundCapture::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectSoundCapture_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCapture_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectSoundCapture::AddRef(THIS)
{
	ULONG res;
	res = IDirectSoundCapture_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCapture_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectSoundCapture::Release(THIS)
{
	ULONG res;
	res = IDirectSoundCapture_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCapture_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectSoundCapture::CreateCaptureBuffer(THIS_ LPCDSCBUFFERDESC lpDSCBufferDesc, LPDIRECTSOUNDCAPTUREBUFFER *lplpDirectSoundCaptureBuffer, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirectSoundCapture_CreateCaptureBuffer(p, lpDSCBufferDesc, lplpDirectSoundCaptureBuffer, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCapture_CreateCaptureBuffer(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(IID_IDirectSoundCaptureBuffer, (LPVOID *)lplpDirectSoundCaptureBuffer);
	return res;
}
HRESULT WINAPI myIDirectSoundCapture::GetCaps(THIS_ LPDSCCAPS lpDSCCaps)
{
	HRESULT res;
	res = IDirectSoundCapture_GetCaps(p,lpDSCCaps );
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCapture_GetCaps(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSoundCapture::Initialize(THIS_ LPCGUID lpGuid)
{
	HRESULT res;
	res = IDirectSoundCapture_Initialize(p, lpGuid);
#ifdef	DXWRAP_LOG
	::Log("IDirectSoundCapture_Initialize(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
