#include "dxwrap.h"

//******************************************************************************

void myRedirectNewInterface(REFIID riid, LPVOID FAR *ppvObj)
{
	// Direct3D interfaces:
	if (IsEqualGUID(riid, IID_IDirect3D)) {
		*ppvObj = new myIDirect3D((LPDIRECT3D)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3D2)) {
		*ppvObj = new myIDirect3D2((LPDIRECT3D2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3D3)) {
		*ppvObj = new myIDirect3D3((LPDIRECT3D3)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DDevice)) {
		*ppvObj = new myIDirect3DDevice((LPDIRECT3DDEVICE)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DDevice2)) {
		*ppvObj = new myIDirect3DDevice2((LPDIRECT3DDEVICE2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DDevice3)) {
		*ppvObj = new myIDirect3DDevice3((LPDIRECT3DDEVICE3)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DExecuteBuffer)) {
		*ppvObj = new myIDirect3DExecuteBuffer((LPDIRECT3DEXECUTEBUFFER)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DLight)) {
		*ppvObj = new myIDirect3DLight((LPDIRECT3DLIGHT)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DMaterial)) {
		*ppvObj = new myIDirect3DMaterial((LPDIRECT3DMATERIAL)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DMaterial2)) {
		*ppvObj = new myIDirect3DMaterial2((LPDIRECT3DMATERIAL2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DMaterial3)) {
		*ppvObj = new myIDirect3DMaterial3((LPDIRECT3DMATERIAL3)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DTexture)) {
		*ppvObj = new myIDirect3DTexture((LPDIRECT3DTEXTURE)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DTexture2)) {
		*ppvObj = new myIDirect3DTexture2((LPDIRECT3DTEXTURE2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DVertexBuffer)) {
		*ppvObj = new myIDirect3DVertexBuffer((LPDIRECT3DVERTEXBUFFER)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DViewport)) {
		*ppvObj = new myIDirect3DViewport((LPDIRECT3DVIEWPORT)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DViewport2)) {
		*ppvObj = new myIDirect3DViewport2((LPDIRECT3DVIEWPORT2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirect3DViewport3)) {
		*ppvObj = new myIDirect3DViewport3((LPDIRECT3DVIEWPORT3)*ppvObj);
	// DirectDraw interfaces:
	} else if (IsEqualGUID(riid, IID_IDirectDraw)) {
		*ppvObj = new myIDirectDraw((LPDIRECTDRAW)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDraw2)) {
		*ppvObj = new myIDirectDraw2((LPDIRECTDRAW2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDraw4)) {
		*ppvObj = new myIDirectDraw4((LPDIRECTDRAW4)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDrawClipper)) {
		*ppvObj = new myIDirectDrawClipper((LPDIRECTDRAWCLIPPER)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDrawColorControl)) {
		*ppvObj = new myIDirectDrawColorControl((LPDIRECTDRAWCOLORCONTROL)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDrawGammaControl)) {
		*ppvObj = new myIDirectDrawGammaControl((LPDIRECTDRAWGAMMACONTROL)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDrawPalette)) {
		*ppvObj = new myIDirectDrawPalette((LPDIRECTDRAWPALETTE)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDrawSurface)) {
		*ppvObj = new myIDirectDrawSurface((LPDIRECTDRAWSURFACE)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDrawSurface2)) {
		*ppvObj = new myIDirectDrawSurface2((LPDIRECTDRAWSURFACE2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectDrawSurface4)) {
		*ppvObj = new myIDirectDrawSurface4((LPDIRECTDRAWSURFACE4)*ppvObj);
	// DirectInput interfaces:
	} else if (IsEqualGUID(riid, IID_IDirectInput)) {
		*ppvObj = new myIDirectInput((LPDIRECTINPUT)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectInput2)) {
		*ppvObj = new myIDirectInput2((LPDIRECTINPUT2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectInputDevice)) {
		*ppvObj = new myIDirectInputDevice((LPDIRECTINPUTDEVICE)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectInputDevice2)) {
		*ppvObj = new myIDirectInputDevice2((LPDIRECTINPUTDEVICE2)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectInputEffect)) {
		*ppvObj = new myIDirectInputEffect((LPDIRECTINPUTEFFECT)*ppvObj);
	// DirectSound interfaces:
	} else if (IsEqualGUID(riid, IID_IDirectSound)) {
		*ppvObj = new myIDirectSound((LPDIRECTSOUND)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectSound3DBuffer)) {
		*ppvObj = new myIDirectSound3DBuffer((LPDIRECTSOUND3DBUFFER)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectSound3DListener)) {
		*ppvObj = new myIDirectSound3DListener((LPDIRECTSOUND3DLISTENER)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectSoundBuffer)) {
		*ppvObj = new myIDirectSoundBuffer((LPDIRECTSOUNDBUFFER)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectSoundCapture)) {
		*ppvObj = new myIDirectSoundCapture((LPDIRECTSOUNDCAPTURE)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectSoundCaptureBuffer)) {
		*ppvObj = new myIDirectSoundCaptureBuffer((LPDIRECTSOUNDCAPTUREBUFFER)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IDirectSoundNotify)) {
		*ppvObj = new myIDirectSoundNotify((LPDIRECTSOUNDNOTIFY)*ppvObj);
	} else if (IsEqualGUID(riid, IID_IKsPropertySet)) {
		*ppvObj = new myIKsPropertySet((LPKSPROPERTYSET)*ppvObj);
	} else {
#ifdef	DXWRAP_LOG
		::Log("Unknown Interface: %s", GUIDtoStr(&riid));
		//__asm int 3;
#endif//DXWRAP_LOG
	}
}

//******************************************************************************

HRESULT CALLBACK myCallbackClass::myD3DEnumDevicesCallback(GUID FAR* lpGuid, LPSTR lpDeviceDescription, LPSTR lpDeviceName, LPD3DDEVICEDESC lpD3DHWDeviceDesc, LPD3DDEVICEDESC lpD3DHELDeviceDesc, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPD3DENUMDEVICESCALLBACK)(p->lpCallback))(lpGuid, lpDeviceDescription, lpDeviceName, lpD3DHWDeviceDesc, lpD3DHELDeviceDesc, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("D3DEnumDevicesCallback(lpGuid=%s, lpDeviceDescription=%s, lpDeviceName=%s, lpD3DHWDeviceDesc=%08x, lpD3DHELDeviceDesc=%08x, lpContext=%08x) = %s",
		GUIDtoStr(lpGuid), lpDeviceDescription, lpDeviceName, lpD3DHWDeviceDesc, lpD3DHELDeviceDesc, p->lpContext, D3D_HRESCallbacktoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT CALLBACK myCallbackClass::myD3DEnumPixelFormatsCallback(LPDDPIXELFORMAT lpDDPixFmt, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPD3DENUMPIXELFORMATSCALLBACK)(p->lpCallback))(lpDDPixFmt, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("D3DEnumPixelFormatsCallback(lpDDPixFmt=%08x, lpContext=%08x) = %s",
		lpDDPixFmt, p->lpContext, D3D_HRESCallbacktoStr(res));
#endif//DXWRAP_LOG
	return res;
}
BOOL CALLBACK myCallbackClass::myDDEnumCallback(GUID FAR *lpGUID, LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext)
{
	BOOL	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDDENUMCALLBACK)(p->lpCallback))(lpGUID, lpDriverDescription, lpDriverName, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("DDEnumCallback(lpGUID=%s, lpDriverDescription=%s, lpDriverName=%s, lpContext=%08x) = %s",
		GUIDtoStr(lpGUID), Str(lpDriverDescription), Str(lpDriverName), p->lpContext, BOOLtoStr(res));
#endif//DXWRAP_LOG
	return res;
}
BOOL CALLBACK myCallbackClass::myDDEnumCallbackEx(GUID FAR *lpGUID, LPSTR lpDriverDescription, LPSTR lpDriverName, LPVOID lpContext, HMONITOR hm)
{
	BOOL	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDDENUMCALLBACKEXA)(p->lpCallback))(lpGUID, lpDriverDescription, lpDriverName, p->lpContext, hm);
#ifdef	DXWRAP_LOG
	::Log("DDEnumCallbackEx(lpGUID=%s, lpDriverDescription=%s, lpDriverName=%s, lpContext=%08x, hm=%08x) = %s",
		GUIDtoStr(lpGUID), Str(lpDriverDescription), Str(lpDriverName), p->lpContext, hm, BOOLtoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT CALLBACK myCallbackClass::myEnumModesCallback(LPDDSURFACEDESC lpDDSurfaceDesc, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDDENUMMODESCALLBACK)(p->lpCallback))(lpDDSurfaceDesc, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("EnumModesCallback(lpDDSurfaceDesc=%08x, lpContext=%08x) = %s",
		lpDDSurfaceDesc, p->lpContext, DD_HRESCallbacktoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT CALLBACK myCallbackClass::myEnumModesCallback2(LPDDSURFACEDESC2 lpDDSurfaceDesc, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDDENUMMODESCALLBACK2)(p->lpCallback))(lpDDSurfaceDesc, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("EnumModesCallback2(lpDDSurfaceDesc=%08x, lpContext=%08x) = %s",
		lpDDSurfaceDesc, p->lpContext, DD_HRESCallbacktoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT CALLBACK myCallbackClass::myEnumSurfacesCallback(LPDIRECTDRAWSURFACE lpDDSurface, LPDDSURFACEDESC lpDDSurfaceDesc, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
//@@@ Warning: This probably doesn't work, lpDDSurface is a Base IDirectDrawSurface interface !!!
	res = ((LPDDENUMSURFACESCALLBACK)(p->lpCallback))(lpDDSurface, lpDDSurfaceDesc, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("EnumSurfacesCallback(lpDDSurface=%08x, lpDDSurfaceDesc=%08x, lpContext=%08x) = %s",
		lpDDSurface, lpDDSurfaceDesc, p->lpContext, DD_HRESCallbacktoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT CALLBACK myCallbackClass::myEnumSurfacesCallback2(LPDIRECTDRAWSURFACE4 lpDDSurface, LPDDSURFACEDESC2 lpDDSurfaceDesc, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
//@@@ Warning: This probably doesn't work, lpDDSurface is a Base IDirectDrawSurface4 interface !!!
	res = ((LPDDENUMSURFACESCALLBACK2)(p->lpCallback))(lpDDSurface, lpDDSurfaceDesc, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("EnumSurfacesCallback2(lpDDSurface=%08x, lpDDSurfaceDesc=%08x, lpContext=%08x) = %s",
		lpDDSurface, lpDDSurfaceDesc, p->lpContext, DD_HRESCallbacktoStr(res));
#endif//DXWRAP_LOG
	return res;
}
BOOL CALLBACK myCallbackClass::myDIEnumCreatedEffectObjectsCallback(LPDIRECTINPUTEFFECT peff, LPVOID lpContext)
{
	BOOL	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDIENUMCREATEDEFFECTOBJECTSCALLBACK)(p->lpCallback))(peff, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("DIEnumCreatedEffectObjectsCallback(peff=%08x, lpContext=%08x) = %s",
		peff, p->lpContext, BOOLtoStr(res));
#endif//DXWRAP_LOG
	return res;
}
BOOL CALLBACK myCallbackClass::myDIEnumDeviceObjectsCallback(LPCDIDEVICEOBJECTINSTANCE lpddoi, LPVOID lpContext)
{
	BOOL	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDIENUMDEVICEOBJECTSCALLBACK)(p->lpCallback))(lpddoi, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("DIEnumDeviceObjectsCallback(lpddoi=%08x, lpContext=%08x) = %s",
		lpddoi, p->lpContext, BOOLtoStr(res));
#endif//DXWRAP_LOG
	return res;
}
BOOL CALLBACK myCallbackClass::myDIEnumDevicesCallback(LPCDIDEVICEINSTANCE lpddi, LPVOID lpContext)
{
	BOOL	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDIENUMDEVICESCALLBACK)(p->lpCallback))(lpddi, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("DIEnumDevicesCallback(lpddi=%08x, lpContext=%08x) = %s",
		lpddi, p->lpContext, BOOLtoStr(res));
#endif//DXWRAP_LOG
	return res;
}
BOOL CALLBACK myCallbackClass::myDIEnumEffectsCallback(LPCDIEFFECTINFO pdei, LPVOID lpContext)
{
	BOOL	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDIENUMEFFECTSCALLBACK)(p->lpCallback))(pdei, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("DIEnumEffectsCallback(pdei=%08x, lpContext=%08x) = %s",
		pdei, p->lpContext, BOOLtoStr(res));
#endif//DXWRAP_LOG
	return res;
}
BOOL CALLBACK myCallbackClass::myDSEnumCallback(GUID FAR *lpGUID, LPCSTR lpDriverDescription, LPCSTR lpDriverName, LPVOID lpContext)
{
	BOOL	res;
	myCallbackClass	*p = (myCallbackClass *)lpContext;
	res = ((LPDSENUMCALLBACKA)(p->lpCallback))(lpGUID, lpDriverDescription, lpDriverName, p->lpContext);
#ifdef	DXWRAP_LOG
	::Log("DSEnumCallback(lpGUID=%s, lpDriverDescription=%s, lpDriverName=%s, lpContext=%08x) = %s",
		GUIDtoStr(lpGUID), Str(lpDriverDescription), Str(lpDriverName), p->lpContext, BOOLtoStr(res));
#endif//DXWRAP_LOG
	return res;
}

//******************************************************************************

HRESULT WINAPI myDirectDrawCreate(GUID FAR *lpGUID, LPDIRECTDRAW FAR *lplpDD, IUnknown FAR *pUnkOuter)
{
	HRESULT	res;
	res = DirectDrawCreate(lpGUID, lplpDD, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("DirectDrawCreate(lpGUID=%s, *lplpDD=%08x, pUnkOuter=%08x) = %s",
		GUIDtoStr(lpGUID), *lplpDD, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDraw, (LPVOID *)lplpDD);
	return res;
}

HRESULT WINAPI myDirectDrawCreateClipper(DWORD dwFlags, LPDIRECTDRAWCLIPPER FAR *lplpDDClipper, IUnknown FAR *pUnkOuter)
{
	HRESULT	res;
	res = DirectDrawCreateClipper(dwFlags, lplpDDClipper, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("DirectDrawCreateClipper(dwFlags=%08x, *lplpDDClipper=%08x, pUnkOuter=%08x) = %s",
		dwFlags, *lplpDDClipper, pUnkOuter, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawClipper, (LPVOID *)lplpDDClipper);
	return res;
}

HRESULT WINAPI myDirectDrawEnumerateA(LPDDENUMCALLBACK lpCallback, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = DirectDrawEnumerateA(myCallbackClass::myDDEnumCallback, ctx);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("DirectDrawEnumerateA(lpCallback=%08x, lpContext=%08x) = %s",
		lpCallback, lpContext, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}

HRESULT WINAPI myDirectDrawEnumerateExA(LPDDENUMCALLBACKEXA lpCallback, LPVOID lpContext, DWORD dwFlags)
{
	HRESULT	res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = DirectDrawEnumerateExA(myCallbackClass::myDDEnumCallbackEx, ctx, dwFlags);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("DirectDrawEnumerateExA(lpCallback=%08x, lpContext=%08x, dwFlags=%08x) = %s",
		lpCallback, lpContext, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}

//******************************************************************************

HRESULT WINAPI myDirectInputCreateA(HINSTANCE hinst, DWORD dwVersion, LPDIRECTINPUTA *ppDI, LPUNKNOWN pUnkOuter)
{
	HRESULT	res;
	res = DirectInputCreateA(hinst, dwVersion, ppDI, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("DirectInputCreateA(hinst=%08x, dwVersion=%08x, *ppDI=%08x, pUnkOuter=%08x) = %s",
		hinst, dwVersion, *ppDI, pUnkOuter, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectInput, (LPVOID *)ppDI);
	return res;
}

HRESULT WINAPI myDirectInputCreateEx(HINSTANCE hinst, DWORD dwVersion, REFIID riidltf, LPVOID *ppvOut, LPUNKNOWN pUnkOuter)
{
	HRESULT	res;
	res = DirectInputCreateEx(hinst, dwVersion, riidltf, ppvOut, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("DirectInputCreateEx(hinst=%08x, dwVersion=%08x, riidltf=%s, *ppvOut=%08x, pUnkOuter=%08x) = %s",
		hinst, dwVersion, GUIDtoStr(&riidltf), *ppvOut, pUnkOuter, DI_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riidltf, (LPVOID *)ppvOut);
	return res;
}

//******************************************************************************

HRESULT WINAPI myDirectSoundCreate(GUID FAR *lpGUID, LPDIRECTSOUND *ppDS, IUnknown FAR *pUnkOuter)
{
	HRESULT	res;
	res = DirectSoundCreate(lpGUID, ppDS, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("DirectSoundCreate(lpGUID=%s, *ppDS=%08x, pUnkOuter=%08x) = %s",
		GUIDtoStr(lpGUID), *ppDS, pUnkOuter, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectSound, (LPVOID *)ppDS);
	return res;
}

HRESULT WINAPI myDirectSoundEnumerateA(LPDSENUMCALLBACKA lpCallback, LPVOID lpContext)
{
	HRESULT	res;
	myCallbackClass *ctx = new myCallbackClass(lpCallback, lpContext);
	res = DirectSoundEnumerateA(myCallbackClass::myDSEnumCallback, ctx);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("DirectSoundEnumerateA(lpCallback=%08x, lpContext=%08x) = %s",
		lpCallback, lpContext, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}

//******************************************************************************

void dxwrap_GetProcAddressHook(LPCSTR lpProcName, FARPROC *lpProcAddr)
{
	if (!strcmp(lpProcName, "DirectDrawCreate"))
		*lpProcAddr = (FARPROC)myDirectDrawCreate;
	else if (!strcmp(lpProcName, "DirectDrawCreateClipper"))
		*lpProcAddr = (FARPROC)myDirectDrawCreateClipper;
	else if (!strcmp(lpProcName, "DirectDrawEnumerateA"))
		*lpProcAddr = (FARPROC)myDirectDrawEnumerateA;
	else if (!strcmp(lpProcName, "DirectDrawEnumerateExA"))
		*lpProcAddr = (FARPROC)myDirectDrawEnumerateExA;
	else if (!strcmp(lpProcName, "DirectInputCreateA"))
		*lpProcAddr = (FARPROC)myDirectInputCreateA;
	else if (!strcmp(lpProcName, "DirectInputCreateEx"))
		*lpProcAddr = (FARPROC)myDirectInputCreateEx;
	else if (!strcmp(lpProcName, "DirectSoundCreate"))
		*lpProcAddr = (FARPROC)myDirectSoundCreate;
	else if (!strcmp(lpProcName, "DirectSoundEnumerateA"))
		*lpProcAddr = (FARPROC)myDirectSoundEnumerateA;
}
