
#include	"bleem_nt.h"
// MSCDEX interface
#include	"mscdex.h"

#ifdef	_DEBUG

//******************************************************************************

// [0] = unpacked program, [1] = working area, [...] = other data areas
static DWORD	vmm_alloc_adr[/*3*/16];

//******************************************************************************

void Log(const char *fmt, ...)
{
	HANDLE	hLogFile;
	va_list	args;
	SYSTEMTIME	cur_time;
	char	log_buffer[500], *p = log_buffer;
	DWORD	dwOutByteCount;
	static BOOL	first_open = TRUE;
	static CRITICAL_SECTION	log_crtsec;

	if (first_open)
		InitializeCriticalSection(&log_crtsec);
	EnterCriticalSection(&log_crtsec);
	if ((hLogFile = CreateFile("bleem_log.txt", GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
		(first_open) ? CREATE_ALWAYS : OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
		SetFilePointer(hLogFile, 0, NULL, FILE_END);
		GetLocalTime(&cur_time);
		p += sprintf(p, "%02d:%02d:%02d.%03d [%08x] ", cur_time.wHour, cur_time.wMinute, cur_time.wSecond, cur_time.wMilliseconds, GetCurrentThreadId());
		va_start(args, fmt);
		p += vsprintf(p, fmt, args);
		va_end(args);
		p += sprintf(p, "\r\n");
		WriteFile(hLogFile, log_buffer, (DWORD)(p - log_buffer), &dwOutByteCount, NULL);
		CloseHandle(hLogFile);
	}
	first_open = FALSE;
	LeaveCriticalSection(&log_crtsec);
}

//******************************************************************************

static void dump_adr(DWORD adr, LPSTR file_name)
{
	MEMORY_BASIC_INFORMATION	memory_info;
	HANDLE	hDmpFile;
	DWORD	dwOutByteCount;

	VirtualQuery((LPVOID)adr, &memory_info, sizeof(memory_info));
	Log("dump_adr: adr=%x, AllocationBase=%x, RegionSize=%x",
		adr, memory_info.AllocationBase, memory_info.RegionSize);
	if (memory_info.AllocationBase == NULL ||
		(hDmpFile = CreateFile(file_name, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL)) == INVALID_HANDLE_VALUE)
		return;
	WriteFile(hDmpFile, memory_info.AllocationBase, memory_info.RegionSize, &dwOutByteCount, NULL);
	CloseHandle(hDmpFile);
}

static void dump_imports(LPSTR file_name)
{
	int __TODO__dump_imports__;
/*
	IMAGE_DOS_HEADER	*dos_header;
	IMAGE_NT_HEADERS	*nt_header;
	IMAGE_IMPORT_DESCRIPTOR	*import_dir;
	IMAGE_THUNK_DATA	*import_entry, *import_thunk;
	LPSTR				import_dllname;
	IMAGE_IMPORT_BY_NAME	*entry_name;
	DWORD				import_size;
	LPVOID				import_vector;

	HMODULE	image_base_addr = GetModuleHandle(NULL);
#define	BASE_ADDRESS(offset)	((DWORD)image_base_addr + (DWORD)(offset))
	dos_header = (IMAGE_DOS_HEADER *)BASE_ADDRESS(0);
	if (IsBadReadPtr(dos_header, sizeof(IMAGE_DOS_HEADER)) ||
		dos_header->e_magic != IMAGE_DOS_SIGNATURE ||
		dos_header->e_lfarlc < sizeof(IMAGE_DOS_HEADER))
		return;
	nt_header = (IMAGE_NT_HEADERS *)BASE_ADDRESS(dos_header->e_lfanew);
	if (IsBadReadPtr(nt_header, sizeof(IMAGE_NT_HEADERS)) ||
		nt_header->Signature != IMAGE_NT_SIGNATURE ||
		nt_header->FileHeader.SizeOfOptionalHeader != sizeof(IMAGE_OPTIONAL_HEADER) ||
		nt_header->OptionalHeader.NumberOfRvaAndSizes != IMAGE_NUMBEROF_DIRECTORY_ENTRIES)
		return;
	import_dir = (IMAGE_IMPORT_DESCRIPTOR *)BASE_ADDRESS(nt_header->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress);
	import_size = nt_header->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].Size;
	if (IsBadReadPtr(import_dir, import_size))
		return;
	for (; import_dir->Name != NULL && import_size >= sizeof(IMAGE_IMPORT_DESCRIPTOR); import_dir++, import_size -= sizeof(IMAGE_IMPORT_DESCRIPTOR)) {
		import_dllname = (LPSTR)BASE_ADDRESS(import_dir->Name);
		if (IsBadStringPtr(import_dllname, 256))
			break;
		import_entry = (IMAGE_THUNK_DATA *)BASE_ADDRESS(import_dir->OriginalFirstThunk);
		import_thunk = (IMAGE_THUNK_DATA *)BASE_ADDRESS(import_dir->FirstThunk);
		for (; ; import_entry++, import_thunk++) {
			if (IsBadReadPtr(import_entry, sizeof(IMAGE_THUNK_DATA)) ||
				IsBadReadPtr(import_thunk, sizeof(IMAGE_THUNK_DATA)) ||
				import_entry->u1.Ordinal == 0)
				break;
			import_vector = import_thunk->u1.Function;
			if (!IMAGE_SNAP_BY_ORDINAL(import_entry->u1.Ordinal)) {
				entry_name = (IMAGE_IMPORT_BY_NAME *)BASE_ADDRESS(import_entry->u1.AddressOfData);
				if (IsBadStringPtr((LPSTR)entry_name->Name, 256))
					break;
				......
			} else {
				entry_ordinal = IMAGE_ORDINAL(import_entry->u1.Ordinal);
				......
			}
		}
	}
	return NULL;
#undef	BASE_ADDRESS
*/
}


//******************************************************************************

#ifdef	ENABLE_MSCDEX_LOG
static void WINAPI Log_MSCDEXRequest(REAL_MODE_CALL_REGS *in_regs, REAL_MODE_CALL_REGS *out_regs)
{
	DEVICE_REQUEST	*device_request;
	CONTROL_BLOCK	*control_block;
	BYTE	drive_unit = (BYTE)in_regs->RealMode_ECX;

	switch (in_regs->RealMode_EAX & 0x00FF) {	// AX = 15xx
	case API_READ_VTOC:					// READ VTOC
		Log("READ_VTOC: drive=%d DX=%04x AX=%04x",
			drive_unit, in_regs->RealMode_EDX, out_regs->RealMode_EAX);
		break;
	case API_DRIVE_CHECK:				// DRIVE CHECK
		Log("DRIVE_CHECK: drive=%d BX=%04x AX=%04x",
			drive_unit, out_regs->RealMode_EBX, out_regs->RealMode_EAX);
		break;
	case API_GET_MSCDEX_VERSION:		// GET MSCDEX.EXE VERSION
		Log("MSCDEX_VERSION: BX=%04x", out_regs->RealMode_EBX);
		break;
	case API_SEND_DEVICE_REQUEST:		// SEND DEVICE DRIVER REQUEST
		device_request = (DEVICE_REQUEST *)((nt_dos_translate_adr) ?
			(in_regs->RealMode_ES << 16) + in_regs->RealMode_EBX :
			(in_regs->RealMode_ES << 4) + in_regs->RealMode_EBX);
		Log("DEVICE_REQUEST: drive=%d cmd=%02x status=%04x",
			drive_unit, device_request->header.cmd, *(WORD *)&device_request->header.status);
		switch (device_request->header.cmd) {
		case DEV_IOCTL_INPUT:			// IOCTL INPUT
			control_block = (CONTROL_BLOCK *)((nt_dos_translate_adr) ?
				(in_regs->RealMode_ES << 16) + ((device_request->ioctl_input.addr >> 12) & 0xFFF0) + (device_request->ioctl_input.addr & 0x0F) :
				((device_request->ioctl_input.addr >> 12) & 0x000FFFF0) + (device_request->ioctl_input.addr & 0x0F));
			Log(" DEV_IOCTL_INPUT: cmd=%02x", control_block->header.cmd);
			switch (control_block->header.cmd) {
			case DEVICE_STATUS:
				Log("  DEVICE_STATUS: parms=%04x", *(WORD *)&control_block->device_status.parms);
				break;
			case AUDIO_DISK_INFO:
				Log("  AUDIO_DISK_INFO: first=%02x last=%02x leadout={%02x,%02x,%02x}",
					control_block->audio_disk_info.first,
					control_block->audio_disk_info.last,
					control_block->audio_disk_info.leadout.minute,
					control_block->audio_disk_info.leadout.second,
					control_block->audio_disk_info.leadout.frame);
				break;
			case AUDIO_TRACK_INFO:
				Log("  AUDIO_DISK_INFO: track=%02x loc={%02x,%02x,%02x} ctrlinfo=%02x",
					control_block->audio_track_info.track,
					control_block->audio_track_info.loc.minute,
					control_block->audio_track_info.loc.second,
					control_block->audio_track_info.loc.frame,
					control_block->audio_track_info.ctrlinfo);
				break;
			case AUDIO_STATUS_INFO:
				Log("  AUDIO_STATUS_INFO: status=%d start=%06x end=%06x",
					*(WORD *)&control_block->audio_status_info.status,
					*(DWORD *)&control_block->audio_status_info.start,
					*(DWORD *)&control_block->audio_status_info.end);
				break;
			default:
				Log("  cmd=#%02x", control_block->header.cmd);
				break;
			}
			break;
		case DEV_INPUT_FLUSH:			// INPUT FLUSH (character devices)
			Log(" DEV_INPUT_FLUSH");
			break;
		case DEV_OUTPUT_FLUSH:			// OUTPUT FLUSH (character devices)
			Log(" DEV_OUTPUT_FLUSH");
			break;
		case DEV_IOCTL_OUTPUT:			// IOCTL OUTPUT
			control_block = (CONTROL_BLOCK *)((nt_dos_translate_adr) ?
				(in_regs->RealMode_ES << 16) + ((device_request->ioctl_input.addr >> 12) & 0xFFF0) + (device_request->ioctl_input.addr & 0x0F) :
				((device_request->ioctl_input.addr >> 12) & 0x000FFFF0) + (device_request->ioctl_input.addr & 0x0F));
			Log(" DEV_IOCTL_OUTPUT: cmd=%02x", control_block->header.cmd);
			switch (control_block->header.cmd) {
			case EJECT_DISK:
				Log("  EJECT_DISK");
				break;
			case CLOSE_TRAY:
				Log("  CLOSE_TRAY");
				break;
			default:
				Log("  cmd=#%02x", control_block->header.cmd);
				break;
			}
			break;
		case DEV_OPEN:					// DEVICE OPEN
			Log(" DEV_OPEN");
			break;
		case DEV_CLOSE:					// DEVICE CLOSE
			Log(" DEV_CLOSE");
			break;
		case DEV_READ_LONG:				// (CD-ROM) READ LONG
			Log(" DEV_READ_LONG: addr_mode=%02x loc=%06x nsec=%02x rd_mode=%02x",
				device_request->read_long.addr_mode,
				device_request->read_long.loc,
				device_request->read_long.nsec,
				device_request->read_long.rd_mode);
			break;
		case DEV_READ_LONG_PREFETCH:	// (CD-ROM) READ LONG PREFETCH
			Log(" DEV_READ_LONG_PREFETCH: addr_mode=%02x loc=%06x nsec=%02x rd_mode=%02x",
				device_request->read_long_prefetch.addr_mode,
				device_request->read_long_prefetch.loc,
				device_request->read_long_prefetch.nsec,
				device_request->read_long_prefetch.rd_mode);
			break;
		case DEV_PLAY_AUDIO:			// (CD-ROM) PLAY AUDIO
			Log(" DEV_PLAY_AUDIO: addr_mode=%02x loc=%06x nsec=%02x",
				device_request->play_audio.addr_mode,
				device_request->play_audio.loc,
				device_request->play_audio.nsec);
			break;
		case DEV_STOP_AUDIO:			// (CD-ROM) STOP AUDIO
			Log(" DEV_STOP_AUDIO");
			break;
		case DEV_RESUME_AUDIO:			// (CD-ROM) RESUME AUDIO
			Log(" DEV_RESUME_AUDIO");
			break;
		default:
			Log(" cmd=#%02x", device_request->header.cmd);
			break;
		}
		break;
	default:
		Log("cmd=#%04x", in_regs->RealMode_EAX);
		break;
	}
}
#endif//ENABLE_MSCDEX_LOG

//******************************************************************************

static void WINAPI Log_VMM_PageReserve(DWORD res, ULONG page, ULONG npages, ULONG flags)
{
	if (res == (DWORD)-1)
		return;
	Log("VMM_PageReserve: res=%08x page=%05x npages=%05x flags=%x",
		res, page, npages, flags);
	// save first alloc ptrs (unpacked program, working area, ...)
	for (int idx = 0; idx < (sizeof(vmm_alloc_adr) / sizeof(vmm_alloc_adr[0])); idx++) {
		if (vmm_alloc_adr[idx] == NULL) {
			vmm_alloc_adr[idx] = res;
			break;
		}
	}
}

static void WINAPI Log_VMM_PageCommit(DWORD res, ULONG page, ULONG npages, ULONG hpd, ULONG pagerdata, ULONG flags)
{
	Log("VMM_PageCommit : res=%08x page=%05x npages=%05x hpd=%x pagerdata=%x flags=%x",
		res, page, npages, hpd, pagerdata, flags);
}

static void WINAPI Log_VMM_PageFree(DWORD res, ULONG hMem, DWORD flags)
{
	Log("VMM_PageFree   : res=%08x hMem=%08x flags=%x",
		res, hMem, flags);
	// when freeing working area, dump unpacked program
	if (hMem == vmm_alloc_adr[1] && hMem != (DWORD)-1) {
		vmm_alloc_adr[1] = (DWORD)-1;	// avoid any further call
		dump_adr(vmm_alloc_adr[0], "prog_dmp1.bin");
		dump_imports("prog_imports.log");
	}
	// same as before for next data area (when the program exit)
	if (hMem == vmm_alloc_adr[2] && hMem != (DWORD)-1) {
		vmm_alloc_adr[2] = (DWORD)-1;	// avoid any further call
		dump_adr(vmm_alloc_adr[0], "prog_dmp2.bin");
	}
}

static void WINAPI Log_VMM_PageModifyPermissions(DWORD res, ULONG page, ULONG npages, ULONG permand, ULONG permor)
{
	Log("VMM_PageModifyPermissions: page=%05x npages=%05x permand=%x permor=%x",
		page, npages, permand, permor);
}

static void WINAPI Log_VMM_GetDemandPageInfo(DWORD res, DEMANDINFOSTRUC *DemandInfo, DWORD flags)
{
	Log("VMM_GetDemandPageInfo: demandinfo=%x flags=%x",
		DemandInfo, flags);
//	__asm int 3
}

static void WINAPI Log_VWin32_Get_Version(DWORD res)
{
	Log("VWin32_Get_Version: res=%04x", res);
}

static void WINAPI Log_VWin32_Int21Dispatch(VXDCALL_REGS *regs, DWORD _eax, DWORD _ecx)
{
	switch (_eax) {
	case DOS_ResetDrive:
		Log("DOS_ResetDrive");
		break;
	default:
		Log("VWin32_Int21Dispatch(%x)", _eax);
		break;
	}
}

static void WINAPI Log_VWin32_Int31Dispatch(VXDCALL_REGS *regs, DWORD _eax, DWORD _ecx, REAL_MODE_CALL_REGS *dpmi_regs)
{
	switch (_eax) {
	case DPMI_SimulateRealModeInterrupt:
		switch (regs->reg_EBX & 0xFF) {	// BL=int-no, BH=flags(0)
		case 0x2F:				// INT 2F (MSCDEX)
#ifdef	ENABLE_MSCDEX_LOG
			Log_MSCDEXRequest(dpmi_regs, (REAL_MODE_CALL_REGS *)regs->reg_EDI);
#endif//ENABLE_MSCDEX_LOG
			break;
		default:
			Log("DPMI_SimulateRealModeInterrupt: int=%02x", regs->reg_EBX);
			break;
		}
		break;
	case DPMI_AllocateLDTDescriptors:
		Log("DPMI_AllocateLDTDescriptors");
		break;
	case DPMI_FreeLDTDescriptors:
		Log("DPMI_FreeLDTDescriptors");
		break;
	default:
		Log("VWin32_Int31Dispatch(%x)", _eax);
		break;
	}
}

static void WINAPI Log_VWin32_Int41Dispatch(VXDCALL_REGS *regs, DWORD _eax)
{
	switch (_eax) {
	case D386_DebuggerInstallationCheck:
		Log("D386_DebuggerInstallationCheck: res=%x", regs->reg_EAX);
		break;
	default:
		Log("VWin32_Int41Dispatch(%x)", _eax);
		break;
	}
}

//******************************************************************************

void WINAPI Log_VxDCall(VXDCALL_REGS *regs, DWORD args[], REAL_MODE_CALL_REGS *dpmi_regs)
{
	switch (regs->vxd_service)
	{
	case VMM_PageReserve:
		Log_VMM_PageReserve(regs->reg_EAX, args[0], args[1], args[2]);
		break;
	case VMM_PageCommit:
		Log_VMM_PageCommit(regs->reg_EAX, args[0], args[1], args[2], args[3], args[4]);
		break;
	case VMM_PageFree:
		Log_VMM_PageFree(regs->reg_EAX, args[0], args[1]);
		break;
	case VMM_PageModifyPermissions:
		Log_VMM_PageModifyPermissions(regs->reg_EAX, args[0], args[1], args[2], args[3]);
		break;
	case VMM_GetDemandPageInfo:
		Log_VMM_GetDemandPageInfo(regs->reg_EAX, (DEMANDINFOSTRUC *)args[0], args[1]);
		break;
	case VWin32_Get_Version:
		Log_VWin32_Get_Version(regs->reg_EAX);
		break;
	case VWin32_Int21Dispatch:
		Log_VWin32_Int21Dispatch(regs, args[0], args[1]);
		break;
	case VWin32_Int31Dispatch:
		Log_VWin32_Int31Dispatch(regs, args[0], args[1], dpmi_regs);
		break;
	case VWin32_Int41Dispatch:
		Log_VWin32_Int41Dispatch(regs, args[0]);
		break;
	default:
		Log("VxDCall: request=%08x, retaddr=%08x", regs->vxd_service, regs->ret_address);
		break;
	}
}

//******************************************************************************

#endif//_DEBUG
