#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3D3::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3D3_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3D3::AddRef(THIS)
{
	ULONG res;
	res = IDirect3D3_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3D3::Release(THIS)
{
	ULONG res;
	res = IDirect3D3_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3D3::EnumDevices(THIS_ LPD3DENUMDEVICESCALLBACK lpEnumDevicesCallback, LPVOID lpUserArg)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumDevicesCallback, lpUserArg);
	res = IDirect3D3_EnumDevices(p, myCallbackClass::myD3DEnumDevicesCallback, ctx);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_EnumDevices(this=%08x, lpEnumDevicesCallback=%08x, lpUserArg=%08x) = %s",
		p, lpEnumDevicesCallback, lpUserArg, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3D3::CreateLight(THIS_ LPDIRECT3DLIGHT *lplpDirect3DLight, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirect3D3_CreateLight(p, lplpDirect3DLight, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_CreateLight(this=%08x, *lplpDirect3DLight=%08x, pUnkOuter=%08x) = %s",
		p, *lplpDirect3DLight, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DLight, (LPVOID *)lplpDirect3DLight);
	return res;
}
HRESULT WINAPI myIDirect3D3::CreateMaterial(THIS_ LPDIRECT3DMATERIAL3 *lplpDirect3DMaterial, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirect3D3_CreateMaterial(p, lplpDirect3DMaterial, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_CreateMaterial(this=%08x, *lplpDirect3DMaterial=%08x, pUnkOuter=%08x) = %s",
		p, *lplpDirect3DMaterial, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DMaterial3, (LPVOID *)lplpDirect3DMaterial);
	return res;
}
HRESULT WINAPI myIDirect3D3::CreateViewport(THIS_ LPDIRECT3DVIEWPORT3 *lplpD3DViewport, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirect3D3_CreateViewport(p, lplpD3DViewport, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_CreateViewport(this=%08x, *lplpD3DViewport=%08x, pUnkOuter=%08x) = %s",
		p, *lplpD3DViewport, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DViewport3, (LPVOID *)lplpD3DViewport);
	return res;
}
HRESULT WINAPI myIDirect3D3::FindDevice(THIS_ LPD3DFINDDEVICESEARCH lpD3DFDS, LPD3DFINDDEVICERESULT lpD3DFDR)
{
	HRESULT res;
	res = IDirect3D3_FindDevice(p, lpD3DFDS, lpD3DFDR);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_FindDevice(this=%08x, lpD3DFDS=%08x, lpD3DFDR=%08x) = %s",
		p, lpD3DFDS, lpD3DFDR, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3D3::CreateDevice(THIS_ REFCLSID rclsid, LPDIRECTDRAWSURFACE4 lpDDS, LPDIRECT3DDEVICE3 *lplpD3DDevice, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	lpDDS = myIDirectDrawSurface4::getBaseInterface(lpDDS);
	res = IDirect3D3_CreateDevice(p, rclsid, lpDDS, lplpD3DDevice, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_CreateDevice(this=%08x, rclsid=%s, lpDDS=%08x, *lplpD3DDevice=%08x, pUnkOuter=%08x) = %s",
		p, GUIDtoStr(&rclsid), lpDDS, *lplpD3DDevice, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DDevice3, (LPVOID *)lplpD3DDevice);
	return res;
}
HRESULT WINAPI myIDirect3D3::CreateVertexBuffer(THIS_ LPD3DVERTEXBUFFERDESC lpVBDesc, LPDIRECT3DVERTEXBUFFER *lpD3DVertexBuffer, DWORD dwFlags, LPUNKNOWN pUnkOuter)
{
	HRESULT res;
	res = IDirect3D3_CreateVertexBuffer(p, lpVBDesc, lpD3DVertexBuffer, dwFlags, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_CreateVertexBuffer(this=%08x, lpVBDesc=%08x, *lpD3DVertexBuffer=%08x, dwFlags=%08x, pUnkOuter=%08x) = %s",
		p, lpVBDesc, *lpD3DVertexBuffer, dwFlags, pUnkOuter, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DVertexBuffer, (LPVOID *)lpD3DVertexBuffer);
	return res;
}
HRESULT WINAPI myIDirect3D3::EnumZBufferFormats(THIS_ REFCLSID riidDevice, LPD3DENUMPIXELFORMATSCALLBACK lpEnumCallback, LPVOID lpContext)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumCallback, lpContext);
	res = IDirect3D3_EnumZBufferFormats(p, riidDevice, myCallbackClass::myD3DEnumPixelFormatsCallback, ctx);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_EnumZBufferFormats(this=%08x, riidDevice=%s, lpEnumCallback=%08x, lpContext=%08x) = %s",
		p, GUIDtoStr(&riidDevice), lpEnumCallback, lpContext, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3D3::EvictManagedTextures(THIS)
{
	HRESULT res;
	res = IDirect3D3_EvictManagedTextures(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3D3_EvictManagedTextures(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
