#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DDevice3::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DDevice3_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DDevice3::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DDevice3_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DDevice3::Release(THIS)
{
	ULONG res;
	res = IDirect3DDevice3_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetCaps(THIS_ LPD3DDEVICEDESC lpD3DHWDevDesc, LPD3DDEVICEDESC lpD3DHELDevDesc)
{
	HRESULT res;
	res = IDirect3DDevice3_GetCaps(p, lpD3DHWDevDesc, lpD3DHELDevDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetCaps(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetStats(THIS_ LPD3DSTATS lpD3DStats)
{
	HRESULT res;
	res = IDirect3DDevice3_GetStats(p, lpD3DStats);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetStats(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::AddViewport(THIS_ LPDIRECT3DVIEWPORT3 lpDirect3DViewport)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport3::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice3_AddViewport(p, lpDirect3DViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_AddViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::DeleteViewport(THIS_ LPDIRECT3DVIEWPORT3 lpDirect3DViewport)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport3::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice3_DeleteViewport(p, lpDirect3DViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_DeleteViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::NextViewport(THIS_ LPDIRECT3DVIEWPORT3 lpDirect3DViewport, LPDIRECT3DVIEWPORT3 *lplpAnotherViewport, DWORD dwFlags)
{
	HRESULT res;
	lpDirect3DViewport = myIDirect3DViewport3::getBaseInterface(lpDirect3DViewport);
	res = IDirect3DDevice3_NextViewport(p, lpDirect3DViewport, lplpAnotherViewport, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_NextViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DViewport3, (LPVOID *)lplpAnotherViewport);
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::EnumTextureFormats(THIS_ LPD3DENUMPIXELFORMATSCALLBACK lpd3dEnumTextureProc, LPVOID lpArg)
{
	HRESULT res;
	res = IDirect3DDevice3_EnumTextureFormats(p, lpd3dEnumTextureProc, lpArg);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_EnumTextureFormats(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::BeginScene(THIS)
{
	HRESULT res;
	res = IDirect3DDevice3_BeginScene(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_BeginScene(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::EndScene(THIS)
{
	HRESULT res;
	res = IDirect3DDevice3_EndScene(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_EndScene(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetDirect3D(THIS_ LPDIRECT3D3 *lplpD3D)
{
	HRESULT res;
	res = IDirect3DDevice3_GetDirect3D(p, lplpD3D);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetDirect3D(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3D3, (LPVOID *)lplpD3D);
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetCurrentViewport(THIS_ LPDIRECT3DVIEWPORT3 lpd3dViewport)
{
	HRESULT res;
	lpd3dViewport = myIDirect3DViewport3::getBaseInterface(lpd3dViewport);
	res = IDirect3DDevice3_SetCurrentViewport(p, lpd3dViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetCurrentViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetCurrentViewport(THIS_ LPDIRECT3DVIEWPORT3 *lplpd3dViewport)
{
	HRESULT res;
	res = IDirect3DDevice3_GetCurrentViewport(p, lplpd3dViewport);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetCurrentViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DViewport3, (LPVOID *)lplpd3dViewport);
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetRenderTarget(THIS_ LPDIRECTDRAWSURFACE4 lpNewRenderTarget, DWORD dwFlags)
{
	HRESULT res;
	lpNewRenderTarget = myIDirectDrawSurface4::getBaseInterface(lpNewRenderTarget);
	res = IDirect3DDevice3_SetRenderTarget(p, lpNewRenderTarget, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetRenderTarget(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetRenderTarget(THIS_ LPDIRECTDRAWSURFACE4 *lplpRenderTarget)
{
	HRESULT res;
	res = IDirect3DDevice3_GetRenderTarget(p, lplpRenderTarget);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetRenderTarget(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface4, (LPVOID *)lplpRenderTarget);
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::Begin(THIS_ D3DPRIMITIVETYPE d3dpt, DWORD dwVertexTypeDesc, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice3_Begin(p, d3dpt, dwVertexTypeDesc, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_Begin(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::BeginIndexed(THIS_ D3DPRIMITIVETYPE dptPrimitiveType, DWORD dwVertexTypeDesc, LPVOID lpvVertices, DWORD dwNumVertices, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice3_BeginIndexed(p, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwNumVertices, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_BeginIndexed(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::Vertex(THIS_ LPVOID lpVertex)
{
	HRESULT res;
	res = IDirect3DDevice3_Vertex(p, lpVertex);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_Vertex(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::Index(THIS_ WORD wVertexIndex)
{
	HRESULT res;
	res = IDirect3DDevice3_Index(p, wVertexIndex);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_Index(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::End(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice3_End(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_End(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetRenderState(THIS_ D3DRENDERSTATETYPE dwRenderStateType, LPDWORD lpdwRenderState)
{
	HRESULT res;
	res = IDirect3DDevice3_GetRenderState(p, dwRenderStateType, lpdwRenderState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetRenderState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetRenderState(THIS_ D3DRENDERSTATETYPE dwRenderStateType, DWORD dwRenderState)
{
	HRESULT res;
	res = IDirect3DDevice3_SetRenderState(p, dwRenderStateType, dwRenderState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetRenderState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetLightState(THIS_ D3DLIGHTSTATETYPE dwLightStateType, LPDWORD lpdwLightState)
{
	HRESULT res;
	res = IDirect3DDevice3_GetLightState(p, dwLightStateType, lpdwLightState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetLightState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetLightState(THIS_ D3DLIGHTSTATETYPE dwLightStateType, DWORD dwLightState)
{
	HRESULT res;
	res = IDirect3DDevice3_SetLightState(p, dwLightStateType, dwLightState);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetLightState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetTransform(THIS_ D3DTRANSFORMSTATETYPE dtstTransformStateType, LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice3_SetTransform(p, dtstTransformStateType, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetTransform(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetTransform(THIS_ D3DTRANSFORMSTATETYPE dtstTransformStateType, LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice3_GetTransform(p, dtstTransformStateType, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetTransform(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::MultiplyTransform(THIS_ D3DTRANSFORMSTATETYPE dtstTransformStateType, LPD3DMATRIX lpD3DMatrix)
{
	HRESULT res;
	res = IDirect3DDevice3_MultiplyTransform(p, dtstTransformStateType, lpD3DMatrix);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_MultiplyTransform(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::DrawPrimitive(THIS_ D3DPRIMITIVETYPE dptPrimitiveType, DWORD dwVertexTypeDesc, LPVOID lpvVertices, DWORD dwVertexCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice3_DrawPrimitive(p, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_DrawPrimitive(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::DrawIndexedPrimitive(THIS_ D3DPRIMITIVETYPE d3dptPrimitiveType, DWORD dwVertexTypeDesc, LPVOID lpvVertices, DWORD dwVertexCount, LPWORD lpwIndices, DWORD dwIndexCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice3_DrawIndexedPrimitive(p, d3dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_DrawIndexedPrimitive(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetClipStatus(THIS_ LPD3DCLIPSTATUS lpD3DClipStatus)
{
	HRESULT res;
	res = IDirect3DDevice3_SetClipStatus(p, lpD3DClipStatus);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetClipStatus(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetClipStatus(THIS_ LPD3DCLIPSTATUS lpD3DClipStatus)
{
	HRESULT res;
	res = IDirect3DDevice3_GetClipStatus(p, lpD3DClipStatus);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetClipStatus(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::DrawPrimitiveStrided(THIS_ D3DPRIMITIVETYPE dptPrimitiveType, DWORD dwVertexTypeDesc, LPD3DDRAWPRIMITIVESTRIDEDDATA lpVertexArray, DWORD dwVertexCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice3_DrawPrimitiveStrided(p, dptPrimitiveType, dwVertexTypeDesc, lpVertexArray, dwVertexCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_DrawPrimitiveStrided(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::DrawIndexedPrimitiveStrided(THIS_ D3DPRIMITIVETYPE d3dptPrimitiveType, DWORD dwVertexTypeDesc, LPD3DDRAWPRIMITIVESTRIDEDDATA lpVertexArray, DWORD dwVertexCount, LPWORD lpwIndices, DWORD dwIndexCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DDevice3_DrawIndexedPrimitiveStrided(p, d3dptPrimitiveType, dwVertexTypeDesc, lpVertexArray, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_DrawIndexedPrimitiveStrided(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::DrawPrimitiveVB(THIS_ D3DPRIMITIVETYPE d3dptPrimitiveType, LPDIRECT3DVERTEXBUFFER lpd3dVertexBuffer, DWORD dwStartVertex, DWORD dwNumVertices, DWORD dwFlags)
{
	HRESULT res;
	lpd3dVertexBuffer = myIDirect3DVertexBuffer::getBaseInterface(lpd3dVertexBuffer);
	res = IDirect3DDevice3_DrawPrimitiveVB(p, d3dptPrimitiveType, lpd3dVertexBuffer, dwStartVertex, dwNumVertices, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_DrawPrimitiveVB(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::DrawIndexedPrimitiveVB(THIS_ D3DPRIMITIVETYPE d3dptPrimitiveType, LPDIRECT3DVERTEXBUFFER lpd3dVertexBuffer, LPWORD lpwIndices, DWORD dwIndexCount, DWORD dwFlags)
{
	HRESULT res;
	lpd3dVertexBuffer = myIDirect3DVertexBuffer::getBaseInterface(lpd3dVertexBuffer);
	res = IDirect3DDevice3_DrawIndexedPrimitiveVB(p, d3dptPrimitiveType, lpd3dVertexBuffer, lpwIndices, dwIndexCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_DrawIndexedPrimitiveVB(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::ComputeSphereVisibility(THIS_ LPD3DVECTOR lpCenters, LPD3DVALUE lpRadii, DWORD dwNumSpheres, DWORD dwFlags, LPDWORD lpdwReturnValues)
{
	HRESULT res;
	res = IDirect3DDevice3_ComputeSphereVisibility(p, lpCenters, lpRadii, dwNumSpheres, dwFlags, lpdwReturnValues);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_ComputeSphereVisibility(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetTexture(THIS_ DWORD dwStage, LPDIRECT3DTEXTURE2 *lplpD3DTexture)
{
	HRESULT res;
	res = IDirect3DDevice3_GetTexture(p, dwStage, lplpD3DTexture);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetTexture(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DTexture2, (LPVOID *)lplpD3DTexture);
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetTexture(THIS_ DWORD dwStage, LPDIRECT3DTEXTURE2 lpD3DTexture)
{
	HRESULT res;
	lpD3DTexture = myIDirect3DTexture2::getBaseInterface(lpD3DTexture);
	res = IDirect3DDevice3_SetTexture(p, dwStage, lpD3DTexture);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetTexture(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::GetTextureStageState(THIS_ DWORD dwStage, D3DTEXTURESTAGESTATETYPE dwState, LPDWORD lpdwValue)
{
	HRESULT res;
	res = IDirect3DDevice3_GetTextureStageState(p, dwStage, dwState, lpdwValue);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_GetTextureStageState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::SetTextureStageState(THIS_ DWORD dwStage, D3DTEXTURESTAGESTATETYPE dwState, DWORD dwValue)
{
	HRESULT res;
	res = IDirect3DDevice3_SetTextureStageState(p, dwStage, dwState, dwValue);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_SetTextureStageState(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DDevice3::ValidateDevice(THIS_ LPDWORD lpdwPasses)
{
	HRESULT res;
	res = IDirect3DDevice3_ValidateDevice(p, lpdwPasses);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DDevice3_ValidateDevice(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
