#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DExecuteBuffer::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DExecuteBuffer_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DExecuteBuffer::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DExecuteBuffer_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DExecuteBuffer::Release(THIS)
{
	ULONG res;
	res = IDirect3DExecuteBuffer_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DExecuteBuffer::Initialize(THIS_ LPDIRECT3DDEVICE lpD3DDevice, LPD3DEXECUTEBUFFERDESC lpDesc)
{
	HRESULT res;
	lpD3DDevice = myIDirect3DDevice::getBaseInterface(lpD3DDevice);
	res = IDirect3DExecuteBuffer_Initialize(p, lpD3DDevice, lpDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DExecuteBuffer::Lock(THIS_ LPD3DEXECUTEBUFFERDESC lpDesc)
{
	HRESULT res;
	res = IDirect3DExecuteBuffer_Lock(p, lpDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_Lock(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DExecuteBuffer::Unlock(THIS)
{
	HRESULT res;
	res = IDirect3DExecuteBuffer_Unlock(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_Unlock(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DExecuteBuffer::SetExecuteData(THIS_ LPD3DEXECUTEDATA lpData)
{
	HRESULT res;
	res = IDirect3DExecuteBuffer_SetExecuteData(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_SetExecuteData(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DExecuteBuffer::GetExecuteData(THIS_ LPD3DEXECUTEDATA lpData)
{
	HRESULT res;
	res = IDirect3DExecuteBuffer_GetExecuteData(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_GetExecuteData(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DExecuteBuffer::Validate(THIS_ LPDWORD lpdwOffset, LPD3DVALIDATECALLBACK lpFunc, LPVOID lpUserArg, DWORD dwReserved)
{
	HRESULT res;
	res = IDirect3DExecuteBuffer_Validate(p, lpdwOffset, lpFunc, lpUserArg, dwReserved);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_Validate(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DExecuteBuffer::Optimize(THIS_ DWORD dwReserved)
{
	HRESULT res;
	res = IDirect3DExecuteBuffer_Optimize(p, dwReserved);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DExecuteBuffer_Optimize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
