#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DLight::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DLight_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DLight_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DLight::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DLight_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DLight_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DLight::Release(THIS)
{
	ULONG res;
	res = IDirect3DLight_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DLight_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DLight::Initialize(THIS_ LPDIRECT3D lpDirect3D)
{
	HRESULT res;
	lpDirect3D = myIDirect3D::getBaseInterface(lpDirect3D);
	res = IDirect3DLight_Initialize(p, lpDirect3D);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DLight_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DLight::SetLight(THIS_ LPD3DLIGHT lpLight)
{
	HRESULT res;
	res = IDirect3DLight_SetLight(p, lpLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DLight_SetLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DLight::GetLight(THIS_ LPD3DLIGHT lpLight)
{
	HRESULT res;
	res = IDirect3DLight_GetLight(p, lpLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DLight_GetLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
