#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DTexture2::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DTexture2_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture2_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DTexture2::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DTexture2_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture2_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DTexture2::Release(THIS)
{
	ULONG res;
	res = IDirect3DTexture2_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture2_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DTexture2::GetHandle(THIS_ LPDIRECT3DDEVICE2 lpD3DDevice, LPD3DTEXTUREHANDLE lpHandle)
{
	HRESULT res;
	lpD3DDevice = myIDirect3DDevice2::getBaseInterface(lpD3DDevice);
	res = IDirect3DTexture2_GetHandle(p, lpD3DDevice, lpHandle);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture2_GetHandle(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DTexture2::PaletteChanged(THIS_ DWORD dwStart, DWORD dwCount)
{
	HRESULT res;
	res = IDirect3DTexture2_PaletteChanged(p, dwStart, dwCount);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture2_PaletteChanged(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DTexture2::Load(THIS_ LPDIRECT3DTEXTURE2 lpD3DTexture)
{
	HRESULT res;
	lpD3DTexture = myIDirect3DTexture2::getBaseInterface(lpD3DTexture);
	res = IDirect3DTexture2_Load(p, lpD3DTexture);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DTexture2_Load(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
