#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirect3DViewport3::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirect3DViewport3_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirect3DViewport3::AddRef(THIS)
{
	ULONG res;
	res = IDirect3DViewport3_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirect3DViewport3::Release(THIS)
{
	ULONG res;
	res = IDirect3DViewport3_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::Initialize(THIS_ LPDIRECT3D lpDirect3D)
{
	HRESULT res;
	lpDirect3D = myIDirect3D::getBaseInterface(lpDirect3D);
	res = IDirect3DViewport3_Initialize(p, lpDirect3D);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_Initialize(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::GetViewport(THIS_ LPD3DVIEWPORT lpData)
{
	HRESULT res;
	res = IDirect3DViewport3_GetViewport(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_GetViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::SetViewport(THIS_ LPD3DVIEWPORT lpData)
{
	HRESULT res;
	res = IDirect3DViewport3_SetViewport(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_SetViewport(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::TransformVertices(THIS_ DWORD dwVertexCount, LPD3DTRANSFORMDATA lpData, DWORD dwFlags, LPDWORD lpOffscreen)
{
	HRESULT res;
	res = IDirect3DViewport3_TransformVertices(p, dwVertexCount, lpData, dwFlags, lpOffscreen);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_TransformVertices(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::LightElements(THIS_ DWORD dwElementCount, LPD3DLIGHTDATA lpData)
{
	HRESULT res;
	res = IDirect3DViewport3_LightElements(p, dwElementCount, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_LightElements(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::SetBackground(THIS_ D3DMATERIALHANDLE hMat)
{
	HRESULT res;
	res = IDirect3DViewport3_SetBackground(p, hMat);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_SetBackground(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::GetBackground(THIS_ LPD3DMATERIALHANDLE lphMat, LPBOOL lpValid)
{
	HRESULT res;
	res = IDirect3DViewport3_GetBackground(p, lphMat, lpValid);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_GetBackground(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::SetBackgroundDepth(THIS_ LPDIRECTDRAWSURFACE lpDDSurface)
{
	HRESULT res;
	lpDDSurface = myIDirectDrawSurface::getBaseInterface(lpDDSurface);
	res = IDirect3DViewport3_SetBackgroundDepth(p, lpDDSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_SetBackgroundDepth(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::GetBackgroundDepth(THIS_ LPDIRECTDRAWSURFACE *lplpDDSurface, LPBOOL lpValid)
{
	HRESULT res;
	res = IDirect3DViewport3_GetBackgroundDepth(p, lplpDDSurface, lpValid);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_GetBackgroundDepth(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface, (LPVOID *)lplpDDSurface);
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::Clear(THIS_ DWORD dwCount, LPD3DRECT lpRects, DWORD dwFlags)
{
	HRESULT res;
	res = IDirect3DViewport3_Clear(p, dwCount, lpRects, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_Clear(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::AddLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport3_AddLight(p, lpDirect3DLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_AddLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::DeleteLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport3_DeleteLight(p, lpDirect3DLight);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_DeleteLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::NextLight(THIS_ LPDIRECT3DLIGHT lpDirect3DLight, LPDIRECT3DLIGHT *lplpDirect3DLight, DWORD dwFlags)
{
	HRESULT res;
	lpDirect3DLight = myIDirect3DLight::getBaseInterface(lpDirect3DLight);
	res = IDirect3DViewport3_NextLight(p, lpDirect3DLight, lplpDirect3DLight, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_NextLight(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirect3DLight, (LPVOID *)lplpDirect3DLight);
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::GetViewport2(THIS_ LPD3DVIEWPORT2 lpData)
{
	HRESULT res;
	res = IDirect3DViewport3_GetViewport2(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_GetViewport2(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::SetViewport2(THIS_ LPD3DVIEWPORT2 lpData)
{
	HRESULT res;
	res = IDirect3DViewport3_SetViewport2(p, lpData);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_SetViewport2(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::SetBackgroundDepth2(THIS_ LPDIRECTDRAWSURFACE4 lpDDS)
{
	HRESULT res;
	lpDDS = myIDirectDrawSurface4::getBaseInterface(lpDDS);
	res = IDirect3DViewport3_SetBackgroundDepth2(p, lpDDS);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_SetBackgroundDepth2(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::GetBackgroundDepth2(THIS_ LPDIRECTDRAWSURFACE4 *lplpDDS, LPBOOL lpValid)
{
	HRESULT res;
	res = IDirect3DViewport3_GetBackgroundDepth2(p, lplpDDS, lpValid);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_GetBackgroundDepth2(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == D3D_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface4, (LPVOID *)lplpDDS);
	return res;
}
HRESULT WINAPI myIDirect3DViewport3::Clear2(THIS_ DWORD dwCount, LPD3DRECT lpRects, DWORD dwFlags, D3DCOLOR dwColor, D3DVALUE dvZ, DWORD dwStencil)
{
	HRESULT res;
	res = IDirect3DViewport3_Clear2(p, dwCount, lpRects, dwFlags, dwColor, dvZ, dwStencil);
#ifdef	DXWRAP_LOG
	::Log("IDirect3DViewport3_Clear2(this=%08x) = %s",
		p, D3D_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
