#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectDrawSurface4::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectDrawSurface4_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectDrawSurface4::AddRef(THIS)
{
	ULONG res;
	res = IDirectDrawSurface4_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectDrawSurface4::Release(THIS)
{
	ULONG res;
	res = IDirectDrawSurface4_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::AddAttachedSurface(THIS_ LPDIRECTDRAWSURFACE4 lpDDSAttachedSurface)
{
	HRESULT res;
	lpDDSAttachedSurface = myIDirectDrawSurface4::getBaseInterface(lpDDSAttachedSurface);
	res = IDirectDrawSurface4_AddAttachedSurface(p, lpDDSAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_AddAttachedSurface(this=%08x, lpDDSAttachedSurface=%08x) = %s",
		p, lpDDSAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::AddOverlayDirtyRect(THIS_ LPRECT lpRect)
{
	HRESULT res;
	res = IDirectDrawSurface4_AddOverlayDirtyRect(p, lpRect);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_AddOverlayDirtyRect(this=%08x, lpRect=%08x) = %s",
		p, lpRect, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::Blt(THIS_ LPRECT lpDestRect, LPDIRECTDRAWSURFACE4 lpDDSrcSurface, LPRECT lpSrcRect, DWORD dwFlags, LPDDBLTFX lpDDBltFx)
{
	HRESULT res;
	lpDDSrcSurface = myIDirectDrawSurface4::getBaseInterface(lpDDSrcSurface);
	res = IDirectDrawSurface4_Blt(p, lpDestRect, lpDDSrcSurface, lpSrcRect, dwFlags, lpDDBltFx);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_Blt(this=%08x, lpDestRect=%08x, lpDDSrcSurface=%08x, lpSrcRect=%08x, dwFlags=%08x, lpDDBltFx=%08x) = %s",
		p, lpDestRect, lpDDSrcSurface, lpSrcRect, dwFlags, lpDDBltFx, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::BltBatch(THIS_ LPDDBLTBATCH lpDDBltBatch, DWORD dwCount, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_BltBatch(p, lpDDBltBatch, dwCount, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_BltBatch(this=%08x, lpDDBltBatch=%08x, dwCount=%08x, dwFlags=%08x) = %s",
		p, lpDDBltBatch, dwCount, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::BltFast(THIS_ DWORD dwX, DWORD dwY, LPDIRECTDRAWSURFACE4 lpDDSrcSurface, LPRECT lpSrcRect, DWORD dwTrans)
{
	HRESULT res;
	lpDDSrcSurface = myIDirectDrawSurface4::getBaseInterface(lpDDSrcSurface);
	res = IDirectDrawSurface4_BltFast(p, dwX, dwY, lpDDSrcSurface, lpSrcRect, dwTrans);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_BltFast(this=%08x, dwX=%08x, dwY=%08x, lpDDSrcSurface=%08x, lpSrcRect=%08x, dwTrans=%08x) = %s",
		p, dwX, dwY, lpDDSrcSurface, lpSrcRect, dwTrans, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::DeleteAttachedSurface(THIS_ DWORD dwFlags, LPDIRECTDRAWSURFACE4 lpDDSAttachedSurface)
{
	HRESULT res;
	lpDDSAttachedSurface = myIDirectDrawSurface4::getBaseInterface(lpDDSAttachedSurface);
	res = IDirectDrawSurface4_DeleteAttachedSurface(p, dwFlags, lpDDSAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_DeleteAttachedSurface(this=%08x, dwFlags=%08x, lpDDSAttachedSurface=%08x) = %s",
		p, dwFlags, lpDDSAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::EnumAttachedSurfaces(THIS_ LPVOID lpContext, LPDDENUMSURFACESCALLBACK2 lpEnumSurfacesCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpEnumSurfacesCallback, lpContext);
	res = IDirectDrawSurface4_EnumAttachedSurfaces(p, ctx, myCallbackClass::myEnumSurfacesCallback2);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_EnumAttachedSurfaces(this=%08x, lpContext=%08x, lpEnumSurfacesCallback=%08x) = %s",
		p, lpContext, lpEnumSurfacesCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::EnumOverlayZOrders(THIS_ DWORD dwFlags, LPVOID lpContext, LPDDENUMSURFACESCALLBACK2 lpfnCallback)
{
	HRESULT res;
	myCallbackClass *ctx = new myCallbackClass(lpfnCallback, lpContext);
	res = IDirectDrawSurface4_EnumOverlayZOrders(p, dwFlags, ctx, myCallbackClass::myEnumSurfacesCallback2);
	delete ctx;
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_EnumOverlayZOrders(this=%08x, dwFlags=%08x, lpContext=%08x, lpfnCallback=%08x) = %s",
		p, dwFlags, lpContext, lpfnCallback, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::Flip(THIS_ LPDIRECTDRAWSURFACE4 lpDDSurfaceTargetOverride, DWORD dwFlags)
{
	HRESULT res;
	lpDDSurfaceTargetOverride = myIDirectDrawSurface4::getBaseInterface(lpDDSurfaceTargetOverride);
	res = IDirectDrawSurface4_Flip(p, lpDDSurfaceTargetOverride, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_Flip(this=%08x, lpDDSurfaceTargetOverride=%08x, dwFlags=%08x) = %s",
		p, lpDDSurfaceTargetOverride, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetAttachedSurface(THIS_ LPDDSCAPS2 lpDDSCaps, LPDIRECTDRAWSURFACE4 FAR *lplpDDAttachedSurface)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetAttachedSurface(p, lpDDSCaps, lplpDDAttachedSurface);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetAttachedSurface(this=%08x, lpDDSCaps=%08x, *lplpDDAttachedSurface=%08x) = %s",
		p, lpDDSCaps, *lplpDDAttachedSurface, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawSurface4, (LPVOID *)lplpDDAttachedSurface);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetBltStatus(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetBltStatus(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetBltStatus(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetCaps(THIS_ LPDDSCAPS2 lpDDSCaps)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetCaps(p, lpDDSCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetCaps(this=%08x, lpDDSCaps=%08x) = %s",
		p, lpDDSCaps, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetClipper(THIS_ LPDIRECTDRAWCLIPPER FAR *lplpDDClipper)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetClipper(p, lplpDDClipper);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetClipper(this=%08x, *lplpDDClipper=%08x) = %s",
		p, *lplpDDClipper, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawClipper, (LPVOID *)lplpDDClipper);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetColorKey(THIS_ DWORD dwFlags, LPDDCOLORKEY lpDDColorKey)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetColorKey(p, dwFlags, lpDDColorKey);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetColorKey(this=%08x, dwFlags=%08x, lpDDColorKey=%08x) = %s",
		p, dwFlags, lpDDColorKey, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetDC(THIS_ HDC FAR *lphDC)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetDC(p, lphDC);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetDC(this=%08x, *lphDC=%08x) = %s",
		p, *lphDC, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetFlipStatus(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetFlipStatus(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetFlipStatus(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetOverlayPosition(THIS_ LPLONG lplX, LPLONG lplY)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetOverlayPosition(p, lplX, lplY);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetOverlayPosition(this=%08x, *lplX=%s, lplY=%s) = %s",
		p, LpDwtoStr((LPDWORD)lplX), LpDwtoStr((LPDWORD)lplY), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetPalette(THIS_ LPDIRECTDRAWPALETTE FAR *lplpDDPalette)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetPalette(p, lplpDDPalette);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetPalette(this=%08x, *lplpDDPalette=%08x) = %s",
		p, *lplpDDPalette, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDrawPalette, (LPVOID *)lplpDDPalette);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetPixelFormat(THIS_ LPDDPIXELFORMAT lpDDPixelFormat)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetPixelFormat(p, lpDDPixelFormat);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetPixelFormat(this=%08x, lpDDPixelFormat=%08x) = %s",
		p, lpDDPixelFormat, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetSurfaceDesc(THIS_ LPDDSURFACEDESC2 lpDDSurfaceDesc)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetSurfaceDesc(p, lpDDSurfaceDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetSurfaceDesc(this=%08x, lpDDSurfaceDesc=%08x) = %s",
		p, lpDDSurfaceDesc, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::Initialize(THIS_ LPDIRECTDRAW lpDD, LPDDSURFACEDESC2 lpDDSurfaceDesc)
{
	HRESULT res;
	lpDD = myIDirectDraw::getBaseInterface(lpDD);
	res = IDirectDrawSurface4_Initialize(p, lpDD, lpDDSurfaceDesc);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_Initialize(this=%08x, lpDD=%08x, lpDDSurfaceDesc=%08x) = %s",
		p, lpDD, lpDDSurfaceDesc, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::IsLost(THIS)
{
	HRESULT res;
	res = IDirectDrawSurface4_IsLost(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_IsLost(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::Lock(THIS_ LPRECT lpDestRect, LPDDSURFACEDESC2 lpDDSurfaceDesc, DWORD dwFlags, HANDLE hEvent)
{
	HRESULT res;
	res = IDirectDrawSurface4_Lock(p, lpDestRect, lpDDSurfaceDesc, dwFlags, hEvent);
#ifdef	BLEEM_NT
	if (res == DD_OK) {
		// save last return values for 'Lock()' function patch:
		memcpy(&locked_DDSurfaceDesc, lpDDSurfaceDesc, sizeof(*lpDDSurfaceDesc));
	} else if (res == DDERR_SURFACEBUSY && ownerThread != GetCurrentThreadId()) {
		// reuse saved values from last successful 'Lock()' call:
		memcpy(lpDDSurfaceDesc, &locked_DDSurfaceDesc, sizeof(*lpDDSurfaceDesc));
		res = DD_OK;
	}
#endif//BLEEM_NT
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_Lock(this=%08x, lpDestRect=%08x, lpDDSurfaceDesc=%08x, dwFlags=%08x, hEvent=%08x) = %s",
		p, lpDestRect, lpDDSurfaceDesc, dwFlags, hEvent, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::ReleaseDC(THIS_ HDC hDC)
{
	HRESULT res;
	res = IDirectDrawSurface4_ReleaseDC(p, hDC);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_ReleaseDC(this=%08x, hDC=%08x) = %s",
		p, hDC, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::Restore(THIS)
{
	HRESULT res;
	res = IDirectDrawSurface4_Restore(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_Restore(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::SetClipper(THIS_ LPDIRECTDRAWCLIPPER lpDDClipper)
{
	HRESULT res;
	lpDDClipper = myIDirectDrawClipper::getBaseInterface(lpDDClipper);
	res = IDirectDrawSurface4_SetClipper(p, lpDDClipper);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_SetClipper(this=%08x, lpDDClipper=%08x) = %s",
		p, lpDDClipper, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::SetColorKey(THIS_ DWORD dwFlags, LPDDCOLORKEY lpDDColorKey)
{
	HRESULT res;
	res = IDirectDrawSurface4_SetColorKey(p, dwFlags, lpDDColorKey);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_SetColorKey(this=%08x, dwFlags=%08x, lpDDColorKey=%08x) = %s",
		p, dwFlags, lpDDColorKey, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::SetOverlayPosition(THIS_ LONG lX, LONG lY)
{
	HRESULT res;
	res = IDirectDrawSurface4_SetOverlayPosition(p, lX, lY);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_SetOverlayPosition(this=%08x, lX=%08x, lY=%08x) = %s",
		p, lX, lY, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::SetPalette(THIS_ LPDIRECTDRAWPALETTE lpDDPalette)
{
	HRESULT res;
	lpDDPalette = myIDirectDrawPalette::getBaseInterface(lpDDPalette);
	res = IDirectDrawSurface4_SetPalette(p, lpDDPalette);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_SetPalette(this=%08x, lpDDPalette=%08x) = %s",
		p, lpDDPalette, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::Unlock(THIS_ LPRECT lpRect)
{
	HRESULT res;
	res = IDirectDrawSurface4_Unlock(p, lpRect);
#ifdef	BLEEM_NT
	if (res == DDERR_NOTLOCKED && ownerThread != GetCurrentThreadId()) {
		// last 'Lock()' call was emulated: force 'no error' return code.
		res = DD_OK;
	}
#endif//BLEEM_NT
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_Unlock(this=%08x, lpRect=%08x) = %s",
		p, lpRect, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::UpdateOverlay(THIS_ LPRECT lpSrcRect, LPDIRECTDRAWSURFACE4 lpDDDestSurface, LPRECT lpDestRect, DWORD dwFlags, LPDDOVERLAYFX lpDDOverlayFx)
{
	HRESULT res;
	lpDDDestSurface = myIDirectDrawSurface4::getBaseInterface(lpDDDestSurface);
	res = IDirectDrawSurface4_UpdateOverlay(p, lpSrcRect, lpDDDestSurface, lpDestRect, dwFlags, lpDDOverlayFx);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_UpdateOverlay(this=%08x, lpSrcRect=%08x, lpDDDestSurface=%08x, lpDestRect=%08x, dwFlags=%08x, lpDDOverlayFx=%08x) = %s",
		p, lpSrcRect, lpDDDestSurface, lpDestRect, dwFlags, lpDDOverlayFx, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::UpdateOverlayDisplay(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_UpdateOverlayDisplay(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_UpdateOverlayDisplay(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::UpdateOverlayZOrder(THIS_ DWORD dwFlags, LPDIRECTDRAWSURFACE4 lpDDSReference)
{
	HRESULT res;
	lpDDSReference = myIDirectDrawSurface4::getBaseInterface(lpDDSReference);
	res = IDirectDrawSurface4_UpdateOverlayZOrder(p, dwFlags, lpDDSReference);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_UpdateOverlayZOrder(this=%08x, dwFlags=%08x, lpDDSReference=%08x) = %s",
		p, dwFlags, lpDDSReference, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetDDInterface(THIS_ LPVOID FAR *lplpDD)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetDDInterface(p, lplpDD);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetDDInterface(this=%08x, *lplpDD=%08x) = %s",
		p, *lplpDD, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DD_OK) ::myRedirectNewInterface(IID_IDirectDraw, (LPVOID *)lplpDD);
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::PageLock(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_PageLock(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_PageLock(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::PageUnlock(THIS_ DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_PageUnlock(p, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_PageUnlock(this=%08x, dwFlags=%08x) = %s",
		p, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::SetSurfaceDesc(THIS_ LPDDSURFACEDESC2 lpddsd2, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_SetSurfaceDesc(p, lpddsd2, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_SetSurfaceDesc(this=%08x, lpddsd2=%08x, dwFlags=%08x) = %s",
		p, lpddsd2, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::SetPrivateData(THIS_ REFGUID guidTag, LPVOID lpData, DWORD cbSize, DWORD dwFlags)
{
	HRESULT res;
	res = IDirectDrawSurface4_SetPrivateData(p, guidTag, lpData, cbSize, dwFlags);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_SetPrivateData(this=%08x, guidTag=%s, lpData=%08x, cbSize=%08x, dwFlags=%08x) = %s",
		p, GUIDtoStr(&guidTag), lpData, cbSize, dwFlags, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetPrivateData(THIS_ REFGUID guidTag, LPVOID lpBuffer, LPDWORD lpcbBufferSize)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetPrivateData(p, guidTag, lpBuffer, lpcbBufferSize);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetPrivateData(this=%08x, guidTag=%s, lpBufferthis=%08x, *lpcbBufferSize=%s) = %s",
		p, GUIDtoStr(&guidTag), lpBuffer, LpDwtoStr(lpcbBufferSize), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::FreePrivateData(THIS_ REFGUID guidTag)
{
	HRESULT res;
	res = IDirectDrawSurface4_FreePrivateData(p, guidTag);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_FreePrivateData(this=%08x, guidTag=%s) = %s",
		p, GUIDtoStr(&guidTag), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::GetUniquenessValue(THIS_ LPDWORD lpValue)
{
	HRESULT res;
	res = IDirectDrawSurface4_GetUniquenessValue(p, lpValue);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_GetUniquenessValue(this=%08x, *lpValue=%s) = %s",
		p, LpDwtoStr(lpValue), DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectDrawSurface4::ChangeUniquenessValue(THIS)
{
	HRESULT res;
	res = IDirectDrawSurface4_ChangeUniquenessValue(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectDrawSurface4_ChangeUniquenessValue(this=%08x) = %s",
		p, DD_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
