#include "dxwrap.h"

//******************************************************************************

HRESULT WINAPI myIDirectSound::QueryInterface(THIS_ REFIID riid, LPVOID FAR *ppvObj)
{
	HRESULT res;
	res = IDirectSound_QueryInterface(p, riid, ppvObj);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_QueryInterface(this=%08x, riid=%s, *ppvObj=%08x) = %s",
		p, GUIDtoStr(&riid), *ppvObj, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(riid, ppvObj);
	return res;
}
ULONG WINAPI myIDirectSound::AddRef(THIS)
{
	ULONG res;
	res = IDirectSound_AddRef(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_AddRef(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	return res;
}
ULONG WINAPI myIDirectSound::Release(THIS)
{
	ULONG res;
	res = IDirectSound_Release(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_Release(this=%08x) = %u",
		p, res);
#endif//DXWRAP_LOG
	if (res == 0) delete this;
	return res;
}
HRESULT WINAPI myIDirectSound::CreateSoundBuffer(THIS_ LPCDSBUFFERDESC lpcDSBufferDesc, LPLPDIRECTSOUNDBUFFER lplpDirectSoundBuffer, IUnknown FAR *pUnkOuter)
{
	HRESULT res;
	res = IDirectSound_CreateSoundBuffer(p, lpcDSBufferDesc, lplpDirectSoundBuffer, pUnkOuter);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_CreateSoundBuffer(this=%08x, lpcDSBufferDesc=%08x, *lplpDirectSoundBuffer=%08x, pUnkOuter=%08x) = %s",
		p, lpcDSBufferDesc, *lplpDirectSoundBuffer, pUnkOuter, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(IID_IDirectSoundBuffer, (LPVOID *)lplpDirectSoundBuffer);
	return res;
}
HRESULT WINAPI myIDirectSound::GetCaps(THIS_ LPDSCAPS lpDSCaps)
{
	HRESULT res;
	res = IDirectSound_GetCaps(p, lpDSCaps);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_GetCaps(this=%08x, lpDSCaps=%08x) = %s",
		p, lpDSCaps, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound::DuplicateSoundBuffer(THIS_ LPDIRECTSOUNDBUFFER lpDsbOriginal, LPLPDIRECTSOUNDBUFFER lplpDsbDuplicate)
{
	HRESULT res;
	lpDsbOriginal = myIDirectSoundBuffer::getBaseInterface(lpDsbOriginal);
	res = IDirectSound_DuplicateSoundBuffer(p, lpDsbOriginal, lplpDsbDuplicate);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_DuplicateSoundBuffer(this=%08x, lpDsbOriginal=%08x, *lplpDsbDuplicate=%08x) = %s",
		p, lpDsbOriginal, *lplpDsbDuplicate, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	if (res == DS_OK) ::myRedirectNewInterface(IID_IDirectSoundBuffer, (LPVOID *)lplpDsbDuplicate);
	return res;
}
HRESULT WINAPI myIDirectSound::SetCooperativeLevel(THIS_ HWND hWnd, DWORD dwLevel)
{
	HRESULT res;
	res = IDirectSound_SetCooperativeLevel(p, hWnd, dwLevel);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_SetCooperativeLevel(this=%08x, hWnd=%08x, dwLevel=%08x) = %s",
		p, hWnd, dwLevel, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound::Compact(THIS)
{
	HRESULT res;
	res = IDirectSound_Compact(p);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_Compact(this=%08x) = %s",
		p, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound::GetSpeakerConfig(THIS_ LPDWORD lpdwSpeakerConfig)
{
	HRESULT res;
	res = IDirectSound_GetSpeakerConfig(p, lpdwSpeakerConfig);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_GetSpeakerConfig(this=%08x, *lpdwSpeakerConfig=%s) = %s",
		p, LpDwtoStr(lpdwSpeakerConfig), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound::SetSpeakerConfig(THIS_ DWORD dwSpeakerConfig)
{
	HRESULT res;
	res = IDirectSound_SetSpeakerConfig(p, dwSpeakerConfig);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_SetSpeakerConfig(this=%08x, dwSpeakerConfig=%08x) = %s",
		p, dwSpeakerConfig, DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
HRESULT WINAPI myIDirectSound::Initialize(THIS_ LPCGUID lpGUID)
{
	HRESULT res;
	res = IDirectSound_Initialize(p, lpGUID);
#ifdef	DXWRAP_LOG
	::Log("IDirectSound_Initialize(this=%08x, lpGUID=%s) = %s",
		p, GUIDtoStr(lpGUID), DS_HREStoStr(res));
#endif//DXWRAP_LOG
	return res;
}
