#include <stdio.h>
#include "dxwrap.h"

//******************************************************************************

#ifdef	DXWRAP_LOG
LPCSTR Str(LPCSTR lpStr)
{
	return (lpStr == NULL) ? "NULL" : lpStr;
}

LPCSTR DwtoStr(DWORD dw)
{
	static char	dw_buf[8][8+1];
	static int	dw_buf_idx = 0;
	int idx = dw_buf_idx++ % 8;
	sprintf(dw_buf[idx], "%08x", dw);
	return dw_buf[idx];
}

LPCSTR LpDwtoStr(LPDWORD lpDw)
{
	return (lpDw == NULL) ? "NULL" : DwtoStr(*lpDw);
}

LPCSTR BOOLtoStr(BOOL b)
{
	return (b == FALSE) ? "FALSE" : (b == TRUE) ? "TRUE" : DwtoStr(b);
}

LPCSTR LPDDSURFACEDESC2toStr(LPDDSURFACEDESC2 lpSD2)
{
	return DwtoStr((DWORD)lpSD2);
/*
	static char	ddsd2_buf[1000];
	char	*p = ddsd2_buf;

	if (lpSD2 == NULL) return "NULL";
	p += sprintf(p, "{ ");
	p += sprintf(p, "dwSize=%x ", lpSD2->dwSize);
	p += sprintf(p, "dwFlags=%x ", lpSD2->dwFlags);
	p += sprintf(p, "dwHeight=%x ", lpSD2->dwHeight);
	p += sprintf(p, "dwWidth=%x ", lpSD2->dwWidth);
	p += sprintf(p, "dwLinearSize=%x ", lpSD2->dwLinearSize);
	p += sprintf(p, "dwBackBufferCount=%x ", lpSD2->dwBackBufferCount);
	p += sprintf(p, "dwRefreshRate=%x ", lpSD2->dwRefreshRate);
	p += sprintf(p, "dwAlphaBitDepth=%x ", lpSD2->dwAlphaBitDepth);
	p += sprintf(p, "dwReserved=%x ", lpSD2->dwReserved);
	p += sprintf(p, "lpSurface=%08x ", lpSD2->lpSurface);
	p += sprintf(p, "ddckCKDestOverlay=%x,%x ", lpSD2->ddckCKDestOverlay.dwColorSpaceLowValue, lpSD2->ddckCKDestOverlay.dwColorSpaceHighValue);
	p += sprintf(p, "ddckCKDestBlt=%x,%x ", lpSD2->ddckCKDestBlt.dwColorSpaceLowValue, lpSD2->ddckCKDestBlt.dwColorSpaceHighValue);
	p += sprintf(p, "ddckCKSrcOverlay=%x,%x ", lpSD2->ddckCKSrcOverlay.dwColorSpaceLowValue, lpSD2->ddckCKSrcOverlay.dwColorSpaceHighValue);
	p += sprintf(p, "ddckCKSrcBlt=%x,%x ", lpSD2->ddckCKSrcBlt.dwColorSpaceLowValue, lpSD2->ddckCKSrcBlt.dwColorSpaceHighValue);
	p += sprintf(p, "ddpfPixelFormat=%x,%x,%x,%x,%x,%x,%x,%x ", lpSD2->ddpfPixelFormat.dwSize, lpSD2->ddpfPixelFormat.dwFlags, lpSD2->ddpfPixelFormat.dwFourCC, lpSD2->ddpfPixelFormat.dwRGBBitCount, lpSD2->ddpfPixelFormat.dwRBitMask, lpSD2->ddpfPixelFormat.dwGBitMask, lpSD2->ddpfPixelFormat.dwBBitMask, lpSD2->ddpfPixelFormat.dwRGBAlphaBitMask);
	p += sprintf(p, "ddsCaps=%x,%x,%x,%x ", lpSD2->ddsCaps.dwCaps, lpSD2->ddsCaps.dwCaps2, lpSD2->ddsCaps.dwCaps3, lpSD2->ddsCaps.dwCaps4);
	p += sprintf(p, "dwTextureStage=%x ", lpSD2->dwTextureStage);
	p += sprintf(p, "}");
	return ddsd2_buf;
*/
}

LPCSTR GUIDtoStr(const GUID *lpGUID)
{
	static char	guid_buf[50];

	if (lpGUID == NULL) return "NULL";
#define	CASE(s)	if (IsEqualGUID(*lpGUID, s)) return #s;
	// DirectDraw interfaces:
	CASE(IID_IDirectDraw)
	CASE(IID_IDirectDraw2)
	CASE(IID_IDirectDraw4)
	//CASE(IID_IDirectDraw7)
	CASE(IID_IDirectDrawClipper)
	CASE(IID_IDirectDrawColorControl)
	CASE(IID_IDirectDrawGammaControl)
	CASE(IID_IDirectDrawPalette)
	CASE(IID_IDirectDrawSurface)
	CASE(IID_IDirectDrawSurface2)
	//CASE(IID_IDirectDrawSurface3)
	CASE(IID_IDirectDrawSurface4)
	//CASE(IID_IDirectDrawSurface7)
	CASE(CLSID_DirectDraw)
	//CASE(CLSID_DirectDraw7)
	CASE(CLSID_DirectDrawClipper)
	// Direct3D interfaces:
	CASE(IID_IDirect3D)
	CASE(IID_IDirect3D2)
	CASE(IID_IDirect3D3)
	//CASE(IID_IDirect3D7)
	CASE(IID_IDirect3DRampDevice)
	CASE(IID_IDirect3DRGBDevice)
	CASE(IID_IDirect3DHALDevice)
	CASE(IID_IDirect3DMMXDevice)
	CASE(IID_IDirect3DRefDevice)
	CASE(IID_IDirect3DNullDevice)
	CASE(IID_IDirect3DTnLHalDevice)
	CASE(IID_IDirect3DDevice)
	CASE(IID_IDirect3DDevice2)
	CASE(IID_IDirect3DDevice3)
	//CASE(IID_IDirect3DDevice7)
	CASE(IID_IDirect3DExecuteBuffer)
	CASE(IID_IDirect3DLight)
	CASE(IID_IDirect3DMaterial)
	CASE(IID_IDirect3DMaterial2)
	CASE(IID_IDirect3DMaterial3)
	CASE(IID_IDirect3DTexture)
	CASE(IID_IDirect3DTexture2)
	CASE(IID_IDirect3DVertexBuffer)
	//CASE(IID_IDirect3DVertexBuffer7)
	CASE(IID_IDirect3DViewport)
	CASE(IID_IDirect3DViewport2)
	CASE(IID_IDirect3DViewport3)
	// DirectSound interfaces:
	CASE(IID_IDirectSound)
	CASE(IID_IDirectSound3DBuffer)
	CASE(IID_IDirectSound3DListener)
	CASE(IID_IDirectSoundBuffer)
	CASE(IID_IDirectSoundCapture)
	CASE(IID_IDirectSoundCaptureBuffer)
	CASE(IID_IDirectSoundNotify)
	CASE(IID_IKsPropertySet)
	CASE(CLSID_DirectSound)
	CASE(CLSID_DirectSoundCapture)
	CASE(DS3DALG_NO_VIRTUALIZATION)
	CASE(DS3DALG_HRTF_FULL)
	CASE(DS3DALG_HRTF_LIGHT)
	// DirectInput interfaces:
	CASE(IID_IDirectInputA)
	CASE(IID_IDirectInputA)
	CASE(IID_IDirectInputW)
	CASE(IID_IDirectInput2A)
	CASE(IID_IDirectInput2W)
	CASE(IID_IDirectInput7A)
	CASE(IID_IDirectInput7W)
	CASE(IID_IDirectInputDeviceA)
	CASE(IID_IDirectInputDeviceW)
	CASE(IID_IDirectInputDevice2A)
	CASE(IID_IDirectInputDevice2W)
	CASE(IID_IDirectInputEffect)
	CASE(IID_IDirectInputDevice7A)
	CASE(IID_IDirectInputDevice7W)
	CASE(CLSID_DirectInput)
	CASE(CLSID_DirectInputDevice)
	CASE(GUID_XAxis)
	CASE(GUID_YAxis)
	CASE(GUID_ZAxis)
	CASE(GUID_RxAxis)
	CASE(GUID_RyAxis)
	CASE(GUID_RzAxis)
	CASE(GUID_Slider)
	CASE(GUID_Button)
	CASE(GUID_Key)
	CASE(GUID_POV)
	CASE(GUID_Unknown)
	CASE(GUID_SysMouse)
	CASE(GUID_SysKeyboard)
	CASE(GUID_Joystick)
	CASE(GUID_SysMouseEm)
	CASE(GUID_SysMouseEm2)
	CASE(GUID_SysKeyboardEm)
	CASE(GUID_SysKeyboardEm2)
	CASE(GUID_ConstantForce)
	CASE(GUID_RampForce)
	CASE(GUID_Square)
	CASE(GUID_Sine)
	CASE(GUID_Triangle)
	CASE(GUID_SawtoothUp)
	CASE(GUID_SawtoothDown)
	CASE(GUID_Spring)
	CASE(GUID_Damper)
	CASE(GUID_Inertia)
	CASE(GUID_Friction)
	CASE(GUID_CustomForce)
#undef CASE
	sprintf(guid_buf, "{%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x}",
		lpGUID->Data1, lpGUID->Data2, lpGUID->Data3,
		lpGUID->Data4[0], lpGUID->Data4[1], lpGUID->Data4[2], lpGUID->Data4[3],
		lpGUID->Data4[4], lpGUID->Data4[5], lpGUID->Data4[6], lpGUID->Data4[7]);
	return guid_buf;
}

LPCSTR D3D_HREStoStr(HRESULT res)
{
	switch (res) {
#define	CASE(s)		case s: return #s;
	CASE(D3D_OK)								CASE(D3DERR_BADMAJORVERSION)
	CASE(D3DERR_BADMINORVERSION)				CASE(D3DERR_INVALID_DEVICE)
	CASE(D3DERR_INITFAILED)						CASE(D3DERR_DEVICEAGGREGATED)
	CASE(D3DERR_EXECUTE_CREATE_FAILED)			CASE(D3DERR_EXECUTE_DESTROY_FAILED)
	CASE(D3DERR_EXECUTE_LOCK_FAILED)			CASE(D3DERR_EXECUTE_UNLOCK_FAILED)
	CASE(D3DERR_EXECUTE_LOCKED)					CASE(D3DERR_EXECUTE_NOT_LOCKED)
	CASE(D3DERR_EXECUTE_FAILED)					CASE(D3DERR_EXECUTE_CLIPPED_FAILED)
	CASE(D3DERR_TEXTURE_NO_SUPPORT)				CASE(D3DERR_TEXTURE_CREATE_FAILED)
	CASE(D3DERR_TEXTURE_DESTROY_FAILED)			CASE(D3DERR_TEXTURE_LOCK_FAILED)
	CASE(D3DERR_TEXTURE_UNLOCK_FAILED)			CASE(D3DERR_TEXTURE_LOAD_FAILED)
	CASE(D3DERR_TEXTURE_SWAP_FAILED)			CASE(D3DERR_TEXTURE_LOCKED)
	CASE(D3DERR_TEXTURE_NOT_LOCKED)				CASE(D3DERR_TEXTURE_GETSURF_FAILED)
	CASE(D3DERR_MATRIX_CREATE_FAILED)			CASE(D3DERR_MATRIX_DESTROY_FAILED)
	CASE(D3DERR_MATRIX_SETDATA_FAILED)			CASE(D3DERR_MATRIX_GETDATA_FAILED)
	CASE(D3DERR_SETVIEWPORTDATA_FAILED)			CASE(D3DERR_INVALIDCURRENTVIEWPORT)
	CASE(D3DERR_INVALIDPRIMITIVETYPE)			CASE(D3DERR_INVALIDVERTEXTYPE)
	CASE(D3DERR_TEXTURE_BADSIZE)				CASE(D3DERR_INVALIDRAMPTEXTURE)
	CASE(D3DERR_MATERIAL_CREATE_FAILED)			CASE(D3DERR_MATERIAL_DESTROY_FAILED)
	CASE(D3DERR_MATERIAL_SETDATA_FAILED)		CASE(D3DERR_MATERIAL_GETDATA_FAILED)
	CASE(D3DERR_INVALIDPALETTE)					CASE(D3DERR_ZBUFF_NEEDS_SYSTEMMEMORY)
	CASE(D3DERR_ZBUFF_NEEDS_VIDEOMEMORY)		CASE(D3DERR_SURFACENOTINVIDMEM)
	CASE(D3DERR_LIGHT_SET_FAILED)				CASE(D3DERR_LIGHTHASVIEWPORT)
	CASE(D3DERR_LIGHTNOTINTHISVIEWPORT)			CASE(D3DERR_SCENE_IN_SCENE)
	CASE(D3DERR_SCENE_NOT_IN_SCENE)				CASE(D3DERR_SCENE_BEGIN_FAILED)
	CASE(D3DERR_SCENE_END_FAILED)				CASE(D3DERR_INBEGIN)
	CASE(D3DERR_NOTINBEGIN)						CASE(D3DERR_NOVIEWPORTS)
	CASE(D3DERR_VIEWPORTDATANOTSET)				CASE(D3DERR_VIEWPORTHASNODEVICE)
	CASE(D3DERR_NOCURRENTVIEWPORT)				CASE(D3DERR_INVALIDVERTEXFORMAT)
	CASE(D3DERR_COLORKEYATTACHED)				CASE(D3DERR_VERTEXBUFFEROPTIMIZED)
	CASE(D3DERR_VBUF_CREATE_FAILED)				CASE(D3DERR_VERTEXBUFFERLOCKED)
	CASE(D3DERR_VERTEXBUFFERUNLOCKFAILED)		CASE(D3DERR_ZBUFFER_NOTPRESENT)
	CASE(D3DERR_STENCILBUFFER_NOTPRESENT)		CASE(D3DERR_WRONGTEXTUREFORMAT)
	CASE(D3DERR_UNSUPPORTEDCOLOROPERATION)		CASE(D3DERR_UNSUPPORTEDCOLORARG)
	CASE(D3DERR_UNSUPPORTEDALPHAOPERATION)		CASE(D3DERR_UNSUPPORTEDALPHAARG)
	CASE(D3DERR_TOOMANYOPERATIONS)				CASE(D3DERR_CONFLICTINGTEXTUREFILTER)
	CASE(D3DERR_UNSUPPORTEDFACTORVALUE)			CASE(D3DERR_CONFLICTINGRENDERSTATE)
	CASE(D3DERR_UNSUPPORTEDTEXTUREFILTER)		CASE(D3DERR_TOOMANYPRIMITIVES)
	CASE(D3DERR_INVALIDMATRIX)					CASE(D3DERR_TOOMANYVERTICES)
	CASE(D3DERR_CONFLICTINGTEXTUREPALETTE)		CASE(D3DERR_INVALIDSTATEBLOCK)
	CASE(D3DERR_INBEGINSTATEBLOCK)				CASE(D3DERR_NOTINBEGINSTATEBLOCK)
#undef CASE
	default: return DD_HREStoStr(res);
	}
}

LPCSTR D3D_HRESCallbacktoStr(HRESULT res)
{
	switch (res) {
#define	CASE(s)		case s: return #s;
	CASE(D3DENUMRET_CANCEL)						CASE(D3DENUMRET_OK)
#undef CASE
	default: return DwtoStr(res);
	}
}

LPCSTR DD_HREStoStr(HRESULT res)
{
	switch (res) {
#define	CASE(s)		case s: return #s;
	CASE(DD_OK)									CASE(DDERR_ALREADYINITIALIZED)
	CASE(DDERR_CANNOTATTACHSURFACE)				CASE(DDERR_CANNOTDETACHSURFACE)
	CASE(DDERR_CURRENTLYNOTAVAIL)				CASE(DDERR_EXCEPTION)
	CASE(DDERR_GENERIC)							CASE(DDERR_HEIGHTALIGN)
	CASE(DDERR_INCOMPATIBLEPRIMARY)				CASE(DDERR_INVALIDCAPS)
	CASE(DDERR_INVALIDCLIPLIST)					CASE(DDERR_INVALIDMODE)
	CASE(DDERR_INVALIDOBJECT)					CASE(DDERR_INVALIDPARAMS)
	CASE(DDERR_INVALIDPIXELFORMAT)				CASE(DDERR_INVALIDRECT)
	CASE(DDERR_LOCKEDSURFACES)					CASE(DDERR_NO3D)
	CASE(DDERR_NOALPHAHW)						CASE(DDERR_NOSTEREOHARDWARE)
	CASE(DDERR_NOSURFACELEFT)					CASE(DDERR_NOCLIPLIST)
	CASE(DDERR_NOCOLORCONVHW)					CASE(DDERR_NOCOOPERATIVELEVELSET)
	CASE(DDERR_NOCOLORKEY)						CASE(DDERR_NOCOLORKEYHW)
	CASE(DDERR_NODIRECTDRAWSUPPORT)				CASE(DDERR_NOEXCLUSIVEMODE)
	CASE(DDERR_NOFLIPHW)						CASE(DDERR_NOGDI)
	CASE(DDERR_NOMIRRORHW)						CASE(DDERR_NOTFOUND)
	CASE(DDERR_NOOVERLAYHW)						CASE(DDERR_OVERLAPPINGRECTS)
	CASE(DDERR_NORASTEROPHW)					CASE(DDERR_NOROTATIONHW)
	CASE(DDERR_NOSTRETCHHW)						CASE(DDERR_NOT4BITCOLOR)
	CASE(DDERR_NOT4BITCOLORINDEX)				CASE(DDERR_NOT8BITCOLOR)
	CASE(DDERR_NOTEXTUREHW)						CASE(DDERR_NOVSYNCHW)
	CASE(DDERR_NOZBUFFERHW)						CASE(DDERR_NOZOVERLAYHW)
	CASE(DDERR_OUTOFCAPS)						CASE(DDERR_OUTOFMEMORY)
	CASE(DDERR_OUTOFVIDEOMEMORY)				CASE(DDERR_OVERLAYCANTCLIP)
	CASE(DDERR_OVERLAYCOLORKEYONLYONEACTIVE)	CASE(DDERR_PALETTEBUSY)
	CASE(DDERR_COLORKEYNOTSET)					CASE(DDERR_SURFACEALREADYATTACHED)
	CASE(DDERR_SURFACEALREADYDEPENDENT)			CASE(DDERR_SURFACEBUSY)
	CASE(DDERR_CANTLOCKSURFACE)					CASE(DDERR_SURFACEISOBSCURED)
	CASE(DDERR_SURFACELOST)						CASE(DDERR_SURFACENOTATTACHED)
	CASE(DDERR_TOOBIGHEIGHT)					CASE(DDERR_TOOBIGSIZE)
	CASE(DDERR_TOOBIGWIDTH)						CASE(DDERR_UNSUPPORTED)
	CASE(DDERR_UNSUPPORTEDFORMAT)				CASE(DDERR_UNSUPPORTEDMASK)
	CASE(DDERR_INVALIDSTREAM)					CASE(DDERR_VERTICALBLANKINPROGRESS)
	CASE(DDERR_WASSTILLDRAWING)					CASE(DDERR_DDSCAPSCOMPLEXREQUIRED)
	CASE(DDERR_XALIGN)							CASE(DDERR_INVALIDDIRECTDRAWGUID)
	CASE(DDERR_DIRECTDRAWALREADYCREATED)		CASE(DDERR_NODIRECTDRAWHW)
	CASE(DDERR_PRIMARYSURFACEALREADYEXISTS)		CASE(DDERR_NOEMULATION)
	CASE(DDERR_REGIONTOOSMALL)					CASE(DDERR_CLIPPERISUSINGHWND)
	CASE(DDERR_NOCLIPPERATTACHED)				CASE(DDERR_NOHWND)
	CASE(DDERR_HWNDSUBCLASSED)					CASE(DDERR_HWNDALREADYSET)
	CASE(DDERR_NOPALETTEATTACHED)				CASE(DDERR_NOPALETTEHW)
	CASE(DDERR_BLTFASTCANTCLIP)					CASE(DDERR_NOBLTHW)
	CASE(DDERR_NODDROPSHW)						CASE(DDERR_OVERLAYNOTVISIBLE)
	CASE(DDERR_NOOVERLAYDEST)					CASE(DDERR_INVALIDPOSITION)
	CASE(DDERR_NOTAOVERLAYSURFACE)				CASE(DDERR_EXCLUSIVEMODEALREADYSET)
	CASE(DDERR_NOTFLIPPABLE)					CASE(DDERR_CANTDUPLICATE)
	CASE(DDERR_NOTLOCKED)						CASE(DDERR_CANTCREATEDC)
	CASE(DDERR_NODC)							CASE(DDERR_WRONGMODE)
	CASE(DDERR_IMPLICITLYCREATED)				CASE(DDERR_NOTPALETTIZED)
	CASE(DDERR_UNSUPPORTEDMODE)					CASE(DDERR_NOMIPMAPHW)
	CASE(DDERR_INVALIDSURFACETYPE)				CASE(DDERR_NOOPTIMIZEHW)
	CASE(DDERR_NOTLOADED)						CASE(DDERR_NOFOCUSWINDOW)
	CASE(DDERR_NOTONMIPMAPSUBLEVEL)				CASE(DDERR_DCALREADYCREATED)
	CASE(DDERR_NONONLOCALVIDMEM)				CASE(DDERR_CANTPAGELOCK)
	CASE(DDERR_CANTPAGEUNLOCK)					CASE(DDERR_NOTPAGELOCKED)
	CASE(DDERR_MOREDATA)						CASE(DDERR_EXPIRED)
	CASE(DDERR_TESTFINISHED)					CASE(DDERR_NEWMODE)
	CASE(DDERR_D3DNOTINITIALIZED)				CASE(DDERR_VIDEONOTACTIVE)
	CASE(DDERR_NOMONITORINFORMATION)			CASE(DDERR_NODRIVERSUPPORT)
	CASE(DDERR_DEVICEDOESNTOWNSURFACE)			CASE(DDERR_NOTINITIALIZED)
	CASE(E_NOINTERFACE)
#undef CASE
	default: return DwtoStr(res);
	}
}

LPCSTR DD_HRESCallbacktoStr(HRESULT res)
{
	switch (res) {
#define	CASE(s)		case s: return #s;
	CASE(DDENUMRET_CANCEL)						CASE(DDENUMRET_OK)
#undef CASE
	default: return DwtoStr(res);
	}
}

LPCSTR DI_HREStoStr(HRESULT res)
{
	switch (res) {
#define	CASE(s)		case s: return #s;
	CASE(DI_OK)									CASE(DI_NOTATTACHED)
	//DI_BUFFEROVERFLOW, DI_PROPNOEFFECT, DI_NOEFFECT == DI_NOTATTACHED
	CASE(DI_POLLEDDEVICE)						CASE(DI_DOWNLOADSKIPPED)
	CASE(DI_EFFECTRESTARTED)					CASE(DI_TRUNCATED)
	CASE(DI_TRUNCATEDANDRESTARTED)				CASE(DIERR_OLDDIRECTINPUTVERSION)
	CASE(DIERR_BETADIRECTINPUTVERSION)			CASE(DIERR_BADDRIVERVER)
	CASE(DIERR_DEVICENOTREG)					CASE(DIERR_NOTFOUND)
	//DIERR_OBJECTNOTFOUND == DIERR_NOTFOUND
	CASE(DIERR_INVALIDPARAM)					CASE(DIERR_NOINTERFACE)
	CASE(DIERR_GENERIC)							CASE(DIERR_OUTOFMEMORY)
	CASE(DIERR_UNSUPPORTED)						CASE(DIERR_NOTINITIALIZED)
	CASE(DIERR_ALREADYINITIALIZED)				CASE(DIERR_NOAGGREGATION)
	CASE(DIERR_OTHERAPPHASPRIO)					CASE(DIERR_INPUTLOST)
	CASE(DIERR_ACQUIRED)						CASE(DIERR_NOTACQUIRED)
	//DIERR_READONLY, DIERR_HANDLEEXISTS == DIERR_OTHERAPPHASPRIO
	CASE(DIERR_INSUFFICIENTPRIVS)				CASE(DIERR_DEVICEFULL)
	CASE(DIERR_MOREDATA)						CASE(DIERR_NOTDOWNLOADED)
	CASE(DIERR_HASEFFECTS)						CASE(DIERR_NOTEXCLUSIVEACQUIRED)
	CASE(DIERR_INCOMPLETEEFFECT)				CASE(DIERR_NOTBUFFERED)
	CASE(DIERR_EFFECTPLAYING)					CASE(DIERR_UNPLUGGED)
	CASE(DIERR_REPORTFULL)						CASE(E_PENDING)
#undef CASE
	default: return DwtoStr(res);
	}
}

LPCSTR DS_HREStoStr(HRESULT res)
{
	switch (res) {
#define	CASE(s)		case s: return #s;
	CASE(DS_OK)									CASE(DS_NO_VIRTUALIZATION)
	CASE(DSERR_ALLOCATED)						CASE(DSERR_CONTROLUNAVAIL)
	CASE(DSERR_INVALIDPARAM)					CASE(DSERR_INVALIDCALL)
	CASE(DSERR_GENERIC)							CASE(DSERR_PRIOLEVELNEEDED)
	CASE(DSERR_OUTOFMEMORY)						CASE(DSERR_BADFORMAT)
	CASE(DSERR_UNSUPPORTED)						CASE(DSERR_NODRIVER)
	CASE(DSERR_ALREADYINITIALIZED)				CASE(DSERR_NOAGGREGATION)
	CASE(DSERR_BUFFERLOST)						CASE(DSERR_OTHERAPPHASPRIO)
	CASE(DSERR_UNINITIALIZED)					CASE(DSERR_NOINTERFACE)
	CASE(DSERR_ACCESSDENIED)
#undef CASE
	default: return DwtoStr(res);
	}
}
#endif//DXWRAP_LOG
