///////////////////////////////////////////////////////////////////////////////
//
//  File:       control.h
//
//  Class:      Controller - Abstract
//  
//  Hierarchy:  Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Controller class is an abstract base class representing a
//      controller object such as a joystick, keyboard, mouse, etc.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _control_h_
#define _control_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Controller Class Definition
///////////////////////////////////////////////////////////////////////////////
class Controller : public RepBase
{
    public:

        //  Deletion.
        virtual ~Controller ( );

        //  General Interface.
        Byte         isEnabled ( ) const;
        virtual Byte update    ( ) = 0;

    protected:

        //  Creation is protected.  Clients should use a build method.
        Controller ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );

        //  Member Data.
        Byte m_bEnabled;

    private:

};


///////////////////////////////////////////////////////////////////////////////
//  Controller Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Byte
Controller::isEnabled(
) const
{
    return( m_bEnabled );
}

#endif
