///////////////////////////////////////////////////////////////////////////////
//
//  File:       joy.h
//
//  Class:      Joystick - Abstract
//  
//  Hierarchy:  Joystick - DigitalController - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Joystick class encapsulates joystick access.  This is an abstract
//      class that serves as a base for derived joystick classes for each
//      platform supported.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _joy_h_
#define _joy_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "dcontrol.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Joystick Class Definition
///////////////////////////////////////////////////////////////////////////////
class Joystick : public DigitalController
{
    public:

        //  The possible directions/buttons.
        typedef enum
        {
            JOY_NONE = SWITCH_NONE,

            JOY1_LEFT,  JOY1_RIGHT, JOY1_UP,    JOY1_DOWN,
            JOY1_B1,    JOY1_B2,    JOY1_B3,    JOY1_B4,

            JOY2_LEFT,  JOY2_RIGHT, JOY2_UP,    JOY2_DOWN,
            JOY2_B1,    JOY2_B2,    JOY2_B3,    JOY2_B4,

            JOY_COUNT
        }
        JoystickJoy;

        //  Deletion.
        virtual ~Joystick ( );

        //  Access.
        virtual DWord         getNumSwitches ( ) const;
        virtual const char*   switchName     ( DWord dwSwitch ) const;

    protected:

        //  Creation is protected.  Clients should use a build method.
        Joystick ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );
        
        //  Static Data Members.
        static const char* sm_pstrJoyNames[ JOY_COUNT ];

    private:

};

#endif
