///////////////////////////////////////////////////////////////////////////////
//
//  File:       keyb.h
//
//  Class:      Keyboard - Abstract
//  
//  Hierarchy:  Keyboard - DigitalController - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Keyboard class encapsulates keyboard access.  This is an abstract
//      class that serves as a base for derived keyboard classes for each
//      platform supported.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _keyb_h_
#define _keyb_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "dcontrol.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Keyboard Class Definition
///////////////////////////////////////////////////////////////////////////////
class Keyboard : public DigitalController
{
    public:

        //  The allowable keys.
        typedef enum
        {
            KEY__NONE = SWITCH_NONE,

            KEY__0,      KEY__1,      KEY__2,     KEY__3,      KEY__4, 
            KEY__5,      KEY__6,      KEY__7,     KEY__8,      KEY__9, 

            KEY__A,      KEY__B,      KEY__C,     KEY__D,      KEY__E,
            KEY__F,      KEY__G,      KEY__H,     KEY__I,      KEY__J,
            KEY__K,      KEY__L,      KEY__M,     KEY__N,      KEY__O,
            KEY__P,      KEY__Q,      KEY__R,     KEY__S,      KEY__T,
            KEY__U,      KEY__V,      KEY__W,     KEY__X,      KEY__Y,
            KEY__Z,

            KEY__SPACE,  KEY__QUOTE,  KEY__EQUAL, KEY__COMMA,  KEY__MINUS,
            KEY__PERIOD, KEY__SLASH,  KEY__COLON, KEY__LBRACE, KEY__RBRACE,
            KEY__BSLASH, KEY__BQUOTE,

            KEY__BS,     KEY__TAB,    KEY__ENTER, KEY__PAUSE,  KEY__SLOCK, 
            KEY__SYSREQ, KEY__INS,    KEY__DEL,   KEY__HOME,   KEY__END,
            KEY__PGUP,   KEY__PGDN,   KEY__LEFT,  KEY__RIGHT,  KEY__UP,
            KEY__DOWN,   KEY__ESC,    KEY__BREAK, KEY__NLOCK, 
            KEY__LSHIFT, KEY__RSHIFT, KEY__LCTRL, KEY__RCTRL,  KEY__CLOCK,
            KEY__LALT,   KEY__RALT, 

            KEY__ADD,    KEY__SUBT,   KEY__MULT,  KEY__DIV,   

            KEY__F1,     KEY__F2,     KEY__F3,    KEY__F4,     KEY__F5,
            KEY__F6,     KEY__F7,     KEY__F8,    KEY__F9,     KEY__F10,
            KEY__F11,    KEY__F12,

            KEY__COUNT
        }
        KeyboardKey;

        //  Deletion.
        virtual ~Keyboard ( );

        //  Access.
        virtual DWord         getNumSwitches ( ) const;
        virtual const char*   switchName     ( DWord dwSwitch ) const;

    protected:

        //  Creation is protected.  Clients should use a build method.
        Keyboard ( const KString& iName );


        //  Static Data Members.
        static const char* sm_pstrKeyNames[ KEY__COUNT ];

    private:

};


#endif
