/** M6502: portable 6502 emulator ****************************/
/**                                                         **/
/**                         M6502.h                         **/
/**                                                         **/
/** This file contains declarations relevant to emulation   **/
/** of 6502 CPU.                                            **/
/**                                                         **/
/** Copyright (C) Marat Fayzullin 1996                      **/
/**               Alex Krasivsky  1996                      **/
/**     You are not allowed to distribute this software     **/
/**     commercially. Please, notify me, if you make any    **/
/**     changes to this file.                               **/
/*************************************************************/
#ifndef M6502_H
#define M6502_H

/* KSB: Needed for CPU declaration. */
#include "cpu.h"

                               /* 6502 status flags:         */
#define	C_FLAG	  0x01         /* 1: Carry occured           */
#define	Z_FLAG	  0x02         /* 1: Result is zero          */
#define	I_FLAG	  0x04         /* 1: Interrupts disabled     */
#define	D_FLAG	  0x08         /* 1: Decimal mode            */
#define	B_FLAG	  0x10         /* Break [0 on stk after int] */
#define	R_FLAG	  0x20         /* Always 1                   */
#define	V_FLAG	  0x40         /* 1: Overflow occured        */
#define	N_FLAG	  0x80         /* 1: Result is negative      */

/** Simple Datatypes *****************************************/
/** NOTICE: sizeof(Byte)=1 and sizeof(Word)=2               **/
/*************************************************************/
/* KSB:  The replay types. */
#include "reptypes.h"

/** Structured Datatypes *************************************/
/** NOTICE: #define LSB_FIRST for machines where least      **/
/**         signifcant byte goes first.                     **/
/*************************************************************/
typedef union
{
#ifdef BYTE_LS_FIRST
  struct { Byte l,h; } B;
#else
  struct { Byte h,l; } B;
#endif
  Word W;
} 
pair;

typedef struct
{
  Byte  A,P,X,Y,S;
  pair  PC;
  pair  previousPC;
  int32 ICount;
  Byte  AfterCLI;
  Byte  PendingIRQ; 
  Byte  PendingNMI; 
} 
M6502;

/** Reset6502() **********************************************/
/** This function can be used to reset the registers before **/
/** starting execution with Run6502(). It sets registers to **/
/** their initial values.                                   **/
/*************************************************************/
void Reset6502(register M6502 *R);

/** Interrupt6502() ******************************************/
/** This function will create a pending interrupt of the    **/
/** specified type.                                         **/
/*************************************************************/
void Interrupt6502(register M6502 *R, int32 nType);

/** Run6502() ************************************************/
/** This function will run 6502 code until the specified    **/
/** cycles expire.                                          **/
/*************************************************************/
int32 Run6502(register M6502 *R, int32 nCycles);

/** Rd6502()/Wr6502/Op6502() *********************************/
/** These functions are called when access to RAM occurs.   **/
/** They allow to control memory access. Op6502 is the same **/
/** as Rd6502, but used to read *opcodes* only, when many   **/
/** checks can be skipped to make it fast. It is only       **/
/** required if there is a #define FAST_RDOP.               **/
/************************************ TO BE WRITTEN BY USER **/
#define Wr6502(A,V) (CPU::sm_pCPU->writeMem(A,V))
#define Rd6502(A) ((Byte)CPU::sm_pCPU->readMem(A))
#define FAST_RDOP
#define Op6502(A) ((CPU::sm_pSpace->getBuffer())[A])
#define Op6502_1(A) ((CPU::sm_pSpace->getDecryptBuffer())[A])

#endif /* M6502_H */
