///////////////////////////////////////////////////////////////////////////////
//
//  File:       cpu6502.h
//
//  Class:      CPU6502 - Abstract
//  
//  Hierarchy:  CPU6502 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class serves as a base class for any 6502 CPU emulation cores.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _cpu6502_h_
#define _cpu6502_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpu.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPU6502 Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPU6502 : public CPU
{
    public:

        //  All possible registers.
        enum
        {
            REG_A = REG_CPU_CUSTOM,
            REG_X,
            REG_Y,
            REG_SP,
            REG_SR,

            REG_6502_CUSTOM
        };
      
        //  Deletion.
        virtual ~CPU6502 ( );

        //  Identification.
        virtual const KString& getType     ( ) const;
        virtual DWord          getAddrSize ( ) const;

#ifdef DEBUGGER
        virtual const char* dbgDisassemble ( DWord& rdwAddress );
        virtual const char* dbgRegister    ( const DWord dwNum );
#endif

    protected:

#ifdef DEBUGGER
        //  The possible 6502 address modes.
        typedef enum
        {
            AC, IL, IM, AB, ZP, ZX, ZY, AX, AY, RL, IX, IY, IN, NO
        }
        AddressMode;
#endif
             
        //  Creation is protected since a build method should be used.
        CPU6502 ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );


    private:

        //  Static Member Data.
#ifdef DEBUGGER
        static Byte  sm_abMnAm[ 512 ];
        static char* sm_astrFormats[ 14 ];
        static char* sm_astrMnemonics[ 56 ];
#endif

};

#endif
