///////////////////////////////////////////////////////////////////////////////
//
//  File:       68000bsc.h
//
//  Class:      CPU68000BSC - Concrete
//  
//  Hierarchy:  CPU68000BSC - CPU68000 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class wraps Bernd's 68000 emulation core.  This is the general
//      68000 core that can be used for any platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _68000bsc_h_
#define _68000bsc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpu68000.h"
#include "cpudefs.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPU68000BSC Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPU68000BSC : public CPU68000
{
    public:

        //  Build method.
        static CPU68000BSC* s_build( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  Deletion.
        virtual ~CPU68000BSC ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        virtual void  reset       ( );
        virtual void  activate    ( );
        virtual void  deactivate  ( );
        virtual void  run         ( const int32 nCycles );
        virtual void  interrupt   ( const int32 nType );

        //  Core access.
        virtual int32 getReg             ( int32 nReg );
        virtual void  setReg             ( int32 nReg, int32 nValue );

    protected:

        //  Creation is protected since a build method should be used.
        CPU68000BSC ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  The initialization member function is called from the build method.
        virtual void init ( );

        //  Context functions.
        void getContext ( );
        void setContext ( );

        //  The 68000 context.
        M68000 m_context;

        //  The ICount.
        int32 m_nICount;

        //  The pending interrupts.
        int32 m_nPendingInts;

    private:

};

#endif
