///////////////////////////////////////////////////////////////////////////////
//
//  File:       cpu68000.h
//
//  Class:      CPU68000 - Abstract
//  
//  Hierarchy:  CPU68000 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class serves as a base class for any 68000 CPU emulation cores.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _cpu68000_h_
#define _cpu68000_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpu.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPU68000 Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPU68000 : public CPU
{
    public:

        //  All possible registers.
        //  IMPORTANT:  Since we draw the Ax/Dx registers in pairs for the
        //    integrated debugger, they *must* be at the end of the list.
        enum
        {
            REG_ASP = REG_CPU_CUSTOM,
            REG_SR,
            REG_A0,
            REG_A1,
            REG_A2,
            REG_A3,
            REG_A4,
            REG_A5,
            REG_A6,
            REG_A7,
            REG_D0,
            REG_D1,
            REG_D2,
            REG_D3,
            REG_D4,
            REG_D5,
            REG_D6,
            REG_D7,

            REG_68000_CUSTOM
        };
      
        //  Deletion.
        virtual ~CPU68000 ( );

        //  Identification.
        virtual const KString& getType     ( ) const;
        virtual DWord          getAddrSize ( ) const;

#ifdef DEBUGGER
        virtual const char* dbgDisassemble ( DWord& rdwAddress );
        virtual const char* dbgRegister    ( const DWord dwNum );
#endif

    protected:

        //  Creation is protected since a build method should be used.
        CPU68000 ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );


    private:

        //  Utility.
#ifdef DEBUGGER
        char* dbgMakeEA          ( 
            int nVal, DWord& rdwAddress, int nSize, char* strVals
        );
        char* dbgMakeRegList     ( char* pstrBuf, Word wVal );
        char* dbgMakeRevRegList  ( char* pstrBuf, Word wVal );
#endif

        //  Static Member Data.
#ifdef DEBUGGER
        static char* sm_astrCond[ 16 ];
#endif

};

#endif
