///////////////////////////////////////////////////////////////////////////////
//
//  File:       6809kbc.h
//
//  Class:      CPU6809KBC - Concrete
//  
//  Hierarchy:  CPU6809KBC - CPU6809 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class wraps my old 6809 emulation core.  This is the general
//      6809 core that can be used for any platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _6809kbc_h_
#define _6809kbc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpu6809.h"
#include "mc6809.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPU6809KBC Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPU6809KBC : public CPU6809
{
    public:

        //  Build method.
        static CPU6809KBC* s_build( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  Deletion.
        virtual ~CPU6809KBC ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        virtual void  reset     ( );
        virtual void  run       ( const int32 nCycles );
        virtual void  interrupt ( const int32 nType );

        //  Core access.
        virtual int32 getReg             ( int32 nReg );
        virtual void  setReg             ( int32 nReg, int32 nValue );

    protected:

        //  Creation is protected since a build method should be used.
        CPU6809KBC ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  The initialization member function is called from the build method.
        virtual void init ( );

        //  The 6809 context.
        MC6809 m_context;

    private:

};

#endif
