/******************************************************************************
*
*  File: 6809.h
*
*  Description:
*
*      This is the private header file for the 6809 CPU.
*
*  Author: Kevin Brisley
*
*  Copyright (c) 1996  Kevin Brisley
*  All rights reserved.
*
******************************************************************************/

#ifndef _6809_H_
#define _6809_H_

/******************************************************************************
*  Required Headers.
******************************************************************************/
/*
 *  Local headers.
 */
#include "cpu.h"
#include "reptypes.h"



/******************************************************************************
*  Types.
******************************************************************************/
/*
 *  A structure that allows access to both the word as a whole and the two
 *  bytes that make up the word.
 */
typedef union
{
#ifdef BYTE_LS_FIRST
    struct 
    {
        Byte l;
        Byte h;
    }
    B;
#else
    struct 
    {
        Byte h;
        Byte l;
    }
    B;
#endif
    Word W;
}
Pair;

/*
 *  A bitfield structure that allows access to the various Condition Code
 *  register bits.
 */
typedef union
{
    Byte all;
    struct 
    {
#ifdef BIT_LS_FIRST
        Byte      c : 1;
        Byte      v : 1;
        Byte      z : 1;
        Byte      n : 1;
        Byte      i : 1;
        Byte      h : 1;
        Byte      f : 1;
        Byte      e : 1;
#else
        Byte      e : 1;
        Byte      f : 1;
        Byte      h : 1;
        Byte      i : 1;
        Byte      n : 1;
        Byte      z : 1;
        Byte      v : 1;
        Byte      c : 1;
#endif
    }
    bit;
}
CCR;

/*
 *  The following structure is the context structure for the 6809 CPU.
 *
 *  ICount
 *      The cycles remaining in this execution slice.
 *
 *  pendingIRQ
 *      This indicates that there is an IRQ pending.
 *
 *  pendingFIRQ
 *      This indicates that there is an FIRQ pending.
 *
 *  pendingNMI
 *      This indicates that there is an NMI pending.
 *
 *  pendingCWAI
 *      This indicates that there is a pending CWAI instruction.
 *
 *  pendingSYNC
 *      This indicates that there is a pending SYNC instruction.
 *
 *  dp  
 *      The direct page register.
 *
 *  dpHi
 *      The direct page register as the high byte.  This is a convenience
 *      so we don't always have to do a dp << 8.
 *
 *  cc
 *      The condition code register.
 *
 *  u 
 *      A stack pointer.
 *
 *  s 
 *      A stack pointer.
 *
 *  x  
 *      An index register.
 *
 *  y
 *      An index register.
 *
 *  acc
 *      The combined accumulator.
 *
 *  a  
 *      Shortcut to the high byte of acc.
 *
 *  b  
 *      Shortcut to the low byte of acc.
 *
 *  d
 *      Shortcut to the word of acc.
 *
 *  pc  
 *      The Program Counter.
 */
typedef struct
{
    int32 ICount;
    Byte  pendingIRQ;
    Byte  pendingFIRQ;
    Byte  pendingNMI;
    Byte  pendingCWAI;
    Byte  pendingSYNC;
    Byte  dp;
    Word  dpHi;
    CCR   cc;
    Word  u;
    Word  s;
    Word  x;
    Word  y;
    Pair  acc;
    Word  pc;
}
MC6809;


/******************************************************************************
*  Interface Prototypes.
******************************************************************************/
void  MC6809Reset     (MC6809 *pMC6809);
int32 MC6809Execute   (MC6809 *pMC6809, int32 nCycles);
void  MC6809Interrupt (MC6809 *pMC6809, int32 nType);


#endif
