///////////////////////////////////////////////////////////////////////////////
//
//  File:       cpurh.h
//
//  Class:      ReadHandler - Concrete
//  
//  Hierarchy:  ReadHandler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a Handler used for reading memory from an
//      address space or from a hardware port.  It is used by CPUs when 
//      accessing memory or ports.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _cpurh_h_
#define _cpurh_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"

//  Forward class declarations.
class ReadHandler;


///////////////////////////////////////////////////////////////////////////////
//  ReadHandler Class Definition
///////////////////////////////////////////////////////////////////////////////
class ReadHandler : public RepBase
{
    public:

        //  The format of a read handler function.
        typedef DWord ( *ReadFunc )( DWord, ReadHandler* );

        //  Creation/Deletion.
        ReadHandler ( 
            const KString& iName, 
            DWord          dwStart, 
            DWord          dwEnd, 
            ReadFunc       pfHandler,
            void*          pData
        );
        virtual ~ReadHandler ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        DWord    getStart    ( ) const;
        DWord    getEnd      ( ) const;
        ReadFunc getHandler  ( ) const;
        void     setHandler  ( ReadFunc pfHandler );
        void*    getData     ( ) const;
        void     setData     ( void* pData );
        
    protected:

        //  Member data.
        DWord    m_dwStart;
        DWord    m_dwEnd;
        ReadFunc m_pfHandler;
        void*    m_pData;


    private:

};


///////////////////////////////////////////////////////////////////////////////
//  ReadHandler Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
DWord
ReadHandler::getStart(
) const
{
    return m_dwStart;
}

inline
DWord
ReadHandler::getEnd(
) const
{
    return m_dwEnd;
}

inline
ReadHandler::ReadFunc
ReadHandler::getHandler(
) const
{
    return m_pfHandler;
}

inline
void
ReadHandler::setHandler(
    ReadHandler::ReadFunc pfHandler
)
{
    m_pfHandler = pfHandler;
}

inline
void*
ReadHandler::getData(
) const
{
    return m_pData;
}

inline
void
ReadHandler::setData(
    void* pData
)
{
    m_pData = pData;
}


#endif
