///////////////////////////////////////////////////////////////////////////////
//
//  File:       cpuwh.h
//
//  Class:      WriteHandler - Concrete
//  
//  Hierarchy:  WriteHandler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a Handler used for writing to memory from an
//      address space or from a hardware port.  It is used by CPUs when 
//      accessing memory or ports.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _cpuwh_h_
#define _cpuwh_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"


//  Forward class declarations.
class WriteHandler;


///////////////////////////////////////////////////////////////////////////////
//  WriteHandler Class Definition
///////////////////////////////////////////////////////////////////////////////
class WriteHandler : public RepBase
{
    public:

        //  The format of a read handler function.
        typedef void ( *WriteFunc )( DWord, Byte, WriteHandler* );

        //  Creation/Deletion.
        WriteHandler ( 
            const KString& iName, 
            DWord          dwStart, 
            DWord          dwEnd, 
            WriteFunc      pfHandler,
            void*          pData
        );
        virtual ~WriteHandler ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        DWord     getStart    ( ) const;
        DWord     getEnd      ( ) const;
        WriteFunc getHandler  ( ) const;
        void      setHandler  ( WriteFunc pfHandler );
        void*     getData     ( ) const;
        void      setData     ( void* pData );

    protected:

        //  Member Data.
        DWord     m_dwStart;
        DWord     m_dwEnd;
        WriteFunc m_pfHandler;
        void*     m_pData;


    private:

};


///////////////////////////////////////////////////////////////////////////////
//  WriteHandler Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
DWord
WriteHandler::getStart(
) const
{
    return m_dwStart;
}

inline
DWord
WriteHandler::getEnd(
) const
{
    return m_dwEnd;
}

inline
WriteHandler::WriteFunc
WriteHandler::getHandler(
) const
{
    return m_pfHandler;
}

inline
void
WriteHandler::setHandler(
    WriteHandler::WriteFunc pfHandler
)
{
    m_pfHandler = pfHandler;
}

inline
void*
WriteHandler::getData(
) const
{
    return m_pData;
}

inline
void
WriteHandler::setData(
    void* pData
)
{
    m_pData = pData;
}


#endif
