///////////////////////////////////////////////////////////////////////////////
//
//  File:       cpuz80.h
//
//  Class:      CPUZ80 - Abstract
//  
//  Hierarchy:  CPUZ80 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class serves as a base class for any Z80 CPU emulation cores.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _cpuz80_h_
#define _cpuz80_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpu.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPUZ80 Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPUZ80 : public CPU
{
    public:

        //  All possible registers.
        enum
        {
            REG_AF = REG_CPU_CUSTOM,
            REG_BC,
            REG_DE,
            REG_HL,
            REG_AF_PRIME,
            REG_BC_PRIME,
            REG_DE_PRIME,
            REG_HL_PRIME,
            REG_IX,
            REG_IY,
            REG_SP,
            REG_I,
            REG_R,

            REG_Z80_CUSTOM
        };
      
        //  Deletion.
        virtual ~CPUZ80 ( );

        //  Identification.
        virtual const KString& getType     ( ) const;
        virtual DWord          getAddrSize ( ) const;

#ifdef DEBUGGER
        virtual const char* dbgDisassemble ( DWord& rdwAddress );
        virtual const char* dbgRegister    ( const DWord dwNum );
#endif

    protected:

        //  Creation is protected since a build method should be used.
        CPUZ80 ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  Static Member Data.
#ifdef DEBUGGER
        static char* sm_astrMnemonicMain[ 256 ];
        static char* sm_astrMnemonicCB[ 256 ];
        static char* sm_astrMnemonicED[ 256 ];
        static char* sm_astrMnemonicXX[ 256 ];
        static char* sm_astrMnemonicXXCB[ 256 ];
#endif

    private:

};

#endif
