/*** Z80Em: Portable Z80 emulator *******************************************/
/***                                                                      ***/
/***                                 Z80.h                                ***/
/***                                                                      ***/
/*** This file contains the function prototypes and variable declarations ***/
/***                                                                      ***/
/*** Copyright (C) Marcel de Kogel 1996,1997                              ***/
/***     You are not allowed to distribute this software commercially     ***/
/***     Please, notify me, if you make any changes to this file          ***/
/****************************************************************************/

#ifndef _Z80_H
#define _Z80_H

/****************************************************************************/
/*** Machine dependent definitions                                        ***/
/****************************************************************************/
/* #define DEBUG      */              /* Compile debugging version          */
/* #define X86_ASM    */              /* Compile optimised GCC/x86 version  */
/* #define LSB_FIRST  */              /* Compile for low-endian CPU         */
/* #define __64BIT__  */              /* Compile for 64 bit machines        */
/* #define __128BIT__ */              /* Compile for 128 bit machines       */

/****************************************************************************/
/* If your compiler doesn't know about inlined functions, uncomment this    */
/****************************************************************************/
/* #define INLINE static */

/****************************************************************************/
/* sizeof(byte)=1, sizeof(word)=2, sizeof(dword)>=4                         */
/****************************************************************************/
/* KSB:  The replay types. */
#include "reptypes.h"
/* KSB:  Needed for CPU declaration. */
#include "cpu.h"


/****************************************************************************/
/* Define a Z80 word. Upper bytes are always zero                           */
/****************************************************************************/
typedef union
{
#ifdef __128BIT__
 #ifdef BYTE_LS_FIRST
   struct { Byte l,h,h2,h3,h4,h5,h6,h7,h8,h9,h10,h11,h12,h13,h14,h15; } B;
   struct { Word l,h,h2,h3,h4,h5,h6,h7; } W;
   DWord D;
 #else
   struct { Byte h15,h14,h13,h12,h11,h10,h9,h8,h7,h6,h5,h4,h3,h2,h,l; } B;
   struct { Word h7,h6,h5,h4,h3,h2,h,l; } W;
   DWord D;
 #endif
#elif __64BIT__
 #ifdef BYTE_LS_FIRST
   struct { Byte l,h,h2,h3,h4,h5,h6,h7; } B;
   struct { Word l,h,h2,h3; } W;
   DWord D;
 #else
   struct { Byte h7,h6,h5,h4,h3,h2,h,l; } B;
   struct { Word h3,h2,h,l; } W;
   DWord D;
 #endif
#else
 #ifdef BYTE_LS_FIRST
   struct { Byte l,h,h2,h3; } B;
   struct { Word l,h; } W;
   DWord D;
 #else
   struct { Byte h3,h2,h,l; } B;
   struct { Word h,l; } W;
   DWord D;
 #endif
#endif
} z80_pair;	/* -NS- */

/****************************************************************************/
/*** End of machine dependent definitions                                 ***/
/****************************************************************************/

#ifndef INLINE
#define INLINE static inline
#endif

/****************************************************************************/
/* The Z80 registers. HALT is set to 1 when the CPU is halted, the refresh  */
/* register is calculated as follows: refresh=(Regs.R&127)|(Regs.R2&128)    */
/****************************************************************************/
typedef struct
{
  z80_pair AF,BC,DE,HL,IX,IY,PC,SP;	/* -NS- */
  z80_pair AF2,BC2,DE2,HL2;	/* -NS- */
  unsigned IFF1,IFF2,HALT,IM,I,R,R2;

  int pending_irq,pending_nmi;	/* NS 970904 */
  /* KSB:  Moved this into the context */
  int ICount;       
} 
Z80_Regs;


#define Z80_IGNORE_INT  CPU::INT_NONE   /* Ignore interrupt                 */
#define Z80_NMI_INT     CPU::INT_NMI    /* Execute NMI                      */


void Z80_GetRegs (Z80_Regs *Regs); /* Get registers                         */
void Z80_SetRegs (Z80_Regs *Regs); /* Set registers                         */
void Z80_Reset   (void);           /* Reset registers to the initial values */
int  Z80_Execute (int cycles);     /* Execute cycles T-States -             */
                                   /* returns number of cycles actually run */
void Z80_Patch   (Z80_Regs *Regs); /* Called when ED FE occurs. Can be used */
                                   /* to emulate disk access etc.           */
void Z80_Interrupt(int32 nType);   /* This is called to set a pending       */
void Z80_ClearInterrupts();        /* This is called to clear pending       */

void Z80_Reti (void);              /* Called when RETI occurs               */
void Z80_Retn (void);              /* Called when RETN occurs               */

/****************************************************************************/
/* Definitions of functions to read/write memory and I/O ports              */
/* You can replace these with your own, inlined if necessary                */
/****************************************************************************/
#include "z80io.h"

#endif /* _Z80_H */

