///////////////////////////////////////////////////////////////////////////////
//
//  File:       z80mdc.h
//
//  Class:      CPUZ80MDC - Concrete
//  
//  Hierarchy:  CPUZ80MDC - CPUZ80 - CPU - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class wraps Marcel's Z80 emulation core.  This is the general
//      Z80 core that can be used for any platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _z80mdc_h_
#define _z80mdc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "kstring.h"
#include "cpuz80.h"
#include "z80.h"

//  Forward class declarations.
class Game;
class AddrSpace;


///////////////////////////////////////////////////////////////////////////////
//  CPUZ80MDC Class Definition
///////////////////////////////////////////////////////////////////////////////
class CPUZ80MDC : public CPUZ80
{
    public:

        //  Build method.
        static CPUZ80MDC* s_build( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  Deletion.
        virtual ~CPUZ80MDC ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

        //  Interface.
        virtual void  reset       ( );
        virtual void  activate    ( );
        virtual void  deactivate  ( );
        virtual void  run         ( const int32 nCycles );
        virtual void  interrupt   ( const int32 nType );

        //  Core access.
        virtual int32 getReg             ( int32 nReg );
        virtual void  setReg             ( int32 nReg, int32 nValue );

    protected:

        //  Creation is protected since a build method should be used.
        CPUZ80MDC ( 
            const KString&   iName, 
            Game*            pGame, 
            AddrSpace*       pSpace,
            const CPUPurpose ePurpose = GAME
        );

        //  The initialization member function is called from the build method.
        virtual void init ( );

        //  The Z80 context.
        Z80_Regs m_context;

    private:

};

#endif
