///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbginfo.h
//
//  Class:      DebugInfo - Concrete
//  
//  Hierarchy:  DebugInfo - DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents an information window in the Replay debugger.
//      The information window displays miscellaneous information such
//      as the type and name of the current CPU being debugged.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbginfo_h_
#define _dbginfo_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "dbgwin.h"
#include "debugger.h"



///////////////////////////////////////////////////////////////////////////////
//  DebugInfo Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugInfo : public DebugWindow
{
    public:

        //  Creation/Deletion.
        DebugInfo ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugInfo ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( );

    protected:

        //  Member Data.

    private:

};

#endif

#endif
