///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbgmem.h
//
//  Class:      DebugMemory - Concrete
//  
//  Hierarchy:  DebugMemory - DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a window in the Replay+ debugger that
//      is used to browse the contents of memory for the current CPU.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbgmem_h_
#define _dbgmem_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "dbgwin.h"
#include "debugger.h"



///////////////////////////////////////////////////////////////////////////////
//  DebugMemory Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugMemory : public DebugWindow
{
    public:

        //  Creation/Deletion.
        DebugMemory ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugMemory ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( );

    protected:

        //  Member Data.

    private:

};

#endif

#endif
