///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbgreg.h
//
//  Class:      DebugRegisters - Concrete
//  
//  Hierarchy:  DebugRegisters - DebugWindow - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a window in the Replay+ debugger that 
//      displays the values of the registers for the current CPU being
//      debugged.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

#ifndef _dbgreg_h_
#define _dbgreg_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "dbgwin.h"
#include "debugger.h"


///////////////////////////////////////////////////////////////////////////////
//  DebugRegisters Class Definition
///////////////////////////////////////////////////////////////////////////////
class DebugRegisters : public DebugWindow
{
    public:

        //  Creation/Deletion.
        DebugRegisters ( 
            const KString& iName, 
            Debugger*      pDebugger,
            const DWord    dwX,
            const DWord    dwY,
            const DWord    dwWidth,
            const DWord    dwHeight
        );
        virtual ~DebugRegisters ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void            draw    ( );
        virtual Debugger::Leave execute ( );

    protected:

        //  Member Data.

    private:

};

#endif

#endif
