///////////////////////////////////////////////////////////////////////////////
//
//  File:    dbgstat.cpp
//
//  Class:   DebugStatus
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class represents a window in the Replay+ debugger that
//      is used to display various status messages pertaining to the
//      debugging procedure.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

#ifdef DEBUGGER

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdio.h>

//  Application Headers.
#include "dbgstat.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: DebugStatus
//
//  Description:
//
//      This is the main constructor for the debug status window object.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//      pDebugger (input)
//          The debugger that the window belongs to.
//
//      dwX (input)
//          The X position of the window.
//
//      dwY (input)
//          The Y position of the window.
//
//      dwWidth (input)
//          The width of the window.
//
//      dwHeight (input)
//          The height of the window.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
DebugStatus::DebugStatus(
    const KString& iName,
    Debugger*      pDebugger,
    const DWord    dwX,
    const DWord    dwY,
    const DWord    dwWidth,
    const DWord    dwHeight
)
:
    DebugWindow ( iName, pDebugger, dwX, dwY, dwWidth, dwHeight )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~DebugStatus
//
//  Description:
//
//      This is the destructor for the debugger status window object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
DebugStatus::~DebugStatus(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the debugger status window.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
DebugStatus::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "DebugStatus" );

    return( className );
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: draw
//
//  Description:
//
//      This member is called when the window is to draw itself.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
DebugStatus::draw(
)
{
    //  The line to draw.
    char strLine[ 80 ];
 

    DebugWindow::draw( );

    //  Draw the status. 
    sprintf( strLine, "   %-75s", m_pDebugger->m_strStatus );
    writeLine( strLine );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: execute
//
//  Description:
//
//      This member is called when the window is to execute.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      One of the "leave" status codes.
//
///////////////////////////////////////////////////////////////////////////////
Debugger::Leave
DebugStatus::execute(
)
{
    return( Debugger::LEAVE_NO );
}






#endif
