///////////////////////////////////////////////////////////////////////////////
//
//  File:       clockd.h
//
//  Class:      ClockDOS - Concrete
//  
//  Hierarchy:  ClockDOS - Clock - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The ClockDOS class is a class encapsulating timing on the DOS
//      platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _clockd_h_
#define _clockd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "clock.h"


///////////////////////////////////////////////////////////////////////////////
//  ClockDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class ClockDOS : public Clock
{
    public:

        //  Creation/Deletion.
                 ClockDOS ( const KString& iName );
        virtual ~ClockDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        virtual DWord getTime ( ) const;

        //  Frame control.
        virtual void frameWait    ( );

    protected:

    private:

};

#endif
