///////////////////////////////////////////////////////////////////////////////
//
//  File:    configd.cpp
//
//  Class:   ConfigurationDOS
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties in a DOS platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "configd.h"


///////////////////////////////////////////////////////////////////////////////
//  File Static Variables.
///////////////////////////////////////////////////////////////////////////////

//  The singleton instance.
ConfigurationDOS ConfigurationDOS::sm_configurationDOS( "Configuration" );


///////////////////////////////////////////////////////////////////////////////
//
//  Function: ConfigurationDOS
//
//  Description:
//
//      This is the main constructor for the DOS configuration 
//      object.  It is protected because it is a singleton and therefore 
//      cannot be instantiated by anyone but itself or a derived class.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationDOS::ConfigurationDOS(
    const KString& iName
)
:
    Configuration ( iName )
{
    //  Add the parameters that are used in DOS.
    addParam( "-vesa",   "",           "Use Vesa Mode." );
    addParam( "-lines",  "",           "Draw with scanlines." );
    addParam( "-awe",    "",           "Use AWE Sound driver if card found." );
    addParam( "-ipx",    "",           "Use IPX for network play." );
    addParam( "-socket", "<socknum>",  "Use this socket # for IPX." );
    addParam( "-irq",    "<irqnum>",   "Use this software interrupt for IPX" );
    addParam( "-tcp",    "",           "Use TCP/IP for network play." );
    addParam( "-host",   "<hostname>", "The host the server is running on." );
    addParam( "-port",   "<portnum>",  "The port the server is listening to." );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~ConfigurationDOS
//
//  Description:
//
//      This is the destructor for the DOS configuration object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ConfigurationDOS::~ConfigurationDOS(
)
{
    //  Nothing to do.
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the configuration object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
ConfigurationDOS::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "ConfigurationDOS" );

    return( className );
}
