///////////////////////////////////////////////////////////////////////////////
//
//  File:       configd.h
//
//  Class:      ConfigurationDOS - Concrete
//  
//  Hierarchy:  ConfigurationDOS - Configuration - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties in a DOS platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _configd_h_
#define _configd_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "config.h"


///////////////////////////////////////////////////////////////////////////////
//  ConfigurationDOS Class Definition
///////////////////////////////////////////////////////////////////////////////
class ConfigurationDOS : public Configuration
{
    public:

        //  Deletion.
        virtual ~ConfigurationDOS ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

        //  Creation/Deletion.
        ConfigurationDOS ( const KString& iName );

    private:

        //  Static Member Data.
        static ConfigurationDOS sm_configurationDOS;
};


#endif
