///////////////////////////////////////////////////////////////////////////////
//
//  File:       dbuffer.h
//
//  Class:      DOSBuffer - Concrete
//  
//  Hierarchy:  DOSBuffer - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a buffer that is stored in low memory for
//      access by RealMode calls.  In particular, it is used by IPX 
//      network access calls.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _dbuffer_h_
#define _dbuffer_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <dpmi.h>
#include <string.h>

//  Application Headers.
#include "repbase.h"


///////////////////////////////////////////////////////////////////////////////
//  DOSBuffer Class Definition
///////////////////////////////////////////////////////////////////////////////
class DOSBuffer : public RepBase
{
    public:

        //  Creation/Deletion.
                 DOSBuffer ( const KString& iName, const DWord dwSize );
        virtual ~DOSBuffer ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        Word  getSegment ( ) const;
        Word  getOffset  ( ) const;
        DWord getAddress ( ) const;
        void  in         ( void* pSource, const DWord dwLength );
        void  out        ( void* pDest,   const DWord dwLength );

    protected:

        //  Member Data.
        DWord              m_dwSize;
        _go32_dpmi_seginfo m_info;
        Word               m_wSegment;
        Word               m_wOffset;
        DWord              m_dwAddress;
        DWord              m_dwLinearAddress;
        
    private:

};

///////////////////////////////////////////////////////////////////////////////
//  DOSBuffer Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Word
DOSBuffer::getSegment(
) const
{
    return( m_wSegment );
}

inline
Word
DOSBuffer::getOffset(
) const
{
    return( m_wOffset );
}

inline
DWord
DOSBuffer::getAddress(
) const
{
    return( m_dwAddress );
}

inline
void
DOSBuffer::in( 
    void*       pSource, 
    const DWord dwLength 
)
{
    dosmemput( pSource, dwLength, m_dwLinearAddress );
}

inline
void
DOSBuffer::out(
    void*       pDest,
    const DWord dwLength
)
{
    dosmemget( m_dwLinearAddress, dwLength, pDest );
}


#endif
