///////////////////////////////////////////////////////////////////////////////
//
//  File:    diskd.cpp
//
//  Class:   DiskDOS
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The DiskDOS class is a class encapsulating disk access for the 
//      DOS platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "diskd.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: DiskDOS
//
//  Description:
//
//      This is the main constructor for a DOS disk object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
DiskDOS::DiskDOS(
    const KString&  iName
)
:
    Disk    ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~DiskDOS
//
//  Description:
//
//      This is the destructor for a DOS disk object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
DiskDOS::~DiskDOS(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the disk object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
DiskDOS::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "DiskDOS" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getDirectorySeparator
//
//  Description:
//
//      This member is used to return the directory separator character
//      as a string.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      A pointer to the directory separator character.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
DiskDOS::getDirectorySeparator(
) const
{
    //  The directory separator is a backslash.
    static KString separator( "\\" );

    //  Send it back.
    return( separator );
}
