///////////////////////////////////////////////////////////////////////////////
//
//  File:    gamfactd.cpp
//
//  Class:   GameFactoryDOS
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is responsible for creating game objects for the games
//      that Replay knows about.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "gamfactd.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: s_build
//
//  Description:
//
//      This is a factory method to create a DOS Game Factory object.
//
//  Parameters:
//
//      iName (input)
//          The name of the object.
//
//  Returns:
//
//      A pointer to the new object.
//
///////////////////////////////////////////////////////////////////////////////
GameFactoryDOS*
GameFactoryDOS::s_build(
    const KString& iName
)
{
    //  Create the new object.
    GameFactoryDOS* pThis = new GameFactoryDOS( iName );

    //  Initialize the new object.
    pThis->init( );

    //  Send back the new object.
    return( pThis );
}




///////////////////////////////////////////////////////////////////////////////
//
//  Function: GameFactoryDOS
//
//  Description:
//
//      This is the main constructor for a game factory object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameFactoryDOS::GameFactoryDOS(
    const KString& iName
)
:
    GameFactory    ( iName )
{
    //  All initialization is done in init( ).
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: init
//
//  Description:
//
//      This is called to initialize the game factory object.  By using an 
//      init member we get access to virtual functions that we wouldn't in the
//      constructor.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
GameFactoryDOS::init(
)
{
    //  Just call the base class.
    GameFactory::init( );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~GameFactoryDOS
//
//  Description:
//
//      This is the destructor for a Game Factory object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
GameFactoryDOS::~GameFactoryDOS(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the Game Factory class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
GameFactoryDOS::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "GameFactoryDOS" );

    return( className );
}
